/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import net.sf.samtools.SAMException;
import net.sf.samtools.util.SnappyLoader;

public class TempStreamFactory {
    private static SnappyLoader snappyLoader = null;

    private static synchronized SnappyLoader getSnappyLoader() {
        if (snappyLoader == null) {
            snappyLoader = new SnappyLoader();
        }
        return snappyLoader;
    }

    public InputStream wrapTempInputStream(InputStream inputStream, int n) {
        if (TempStreamFactory.getSnappyLoader().SnappyAvailable) {
            try {
                return TempStreamFactory.getSnappyLoader().wrapInputStream(inputStream);
            }
            catch (Exception exception) {
                throw new SAMException("Error creating SnappyInputStream", exception);
            }
        }
        if (n > 0) {
            return new BufferedInputStream(inputStream, n);
        }
        return inputStream;
    }

    public OutputStream wrapTempOutputStream(OutputStream outputStream, int n) {
        if (TempStreamFactory.getSnappyLoader().SnappyAvailable) {
            try {
                return TempStreamFactory.getSnappyLoader().wrapOutputStream(outputStream);
            }
            catch (Exception exception) {
                throw new SAMException("Error creating SnappyOutputStream", exception);
            }
        }
        if (n > 0) {
            return new BufferedOutputStream(outputStream, n);
        }
        return outputStream;
    }
}

