/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools.seekablestream;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import net.sf.samtools.seekablestream.UserPasswordInput;
import net.sf.samtools.util.ftp.FTPClient;
import net.sf.samtools.util.ftp.FTPReply;
import net.sf.samtools.util.ftp.FTPUtils;

public class SeekableFTPStreamHelper {
    private long position = 0L;
    private long contentLength = -1L;
    private String host;
    private String path;
    private String userInfo;
    FTPClient ftp = null;
    private UserPasswordInput userPasswordInput;

    SeekableFTPStreamHelper(URL uRL, UserPasswordInput userPasswordInput) throws IOException {
        this.userInfo = uRL.getUserInfo();
        this.host = uRL.getHost();
        this.path = uRL.getPath();
        this.userPasswordInput = userPasswordInput;
        this.ftp = FTPUtils.connect(this.host, this.userInfo, userPasswordInput);
        this.ftp.binary();
        FTPReply fTPReply = this.ftp.size(this.path);
        if (fTPReply.isSuccess()) {
            this.contentLength = Long.parseLong(fTPReply.getReplyString());
        }
    }

    public void seek(long l) {
        this.position = l;
    }

    public long position() {
        return this.position;
    }

    public boolean eof() throws IOException {
        return false;
    }

    public long length() {
        return this.contentLength;
    }

    public long skip(long l) throws IOException {
        long l2 = l;
        this.position += l2;
        if (this.ftp != null) {
            this.ftp.setRestPosition(this.position);
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.ftp == null) {
            this.ftp = FTPUtils.connect(this.host, this.userInfo, this.userPasswordInput);
        }
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        int n3 = 0;
        try {
            int n4;
            FTPReply fTPReply = this.ftp.pasv();
            if (this.contentLength >= 0L && this.position >= this.contentLength) {
                int n5 = -1;
                return n5;
            }
            if (this.position > 0L) {
                this.ftp.setRestPosition(this.position);
            }
            fTPReply = this.ftp.retr(this.path);
            InputStream inputStream = this.ftp.getDataStream();
            while (n3 < n2) {
                n4 = inputStream.read(byArray, n + n3, n2 - n3);
                if (n4 < 0) {
                    if (n3 != 0) break;
                    int n6 = -1;
                    return n6;
                }
                n3 += n4;
            }
            this.position += (long)n3;
            n4 = n3;
            return n4;
        }
        catch (EOFException eOFException) {
            if (n3 < 0) {
                int n7 = -1;
                return n7;
            }
            this.position += (long)n3;
            int n8 = n3;
            return n8;
        }
        finally {
            this.ftp.disconnect();
            this.ftp = null;
        }
    }

    private void reconnect() throws IOException {
        if (this.ftp != null) {
            this.ftp.disconnect();
        }
        this.ftp = FTPUtils.connect(this.host, this.userInfo, this.userPasswordInput);
    }

    public void close() throws IOException {
        if (this.ftp != null) {
            this.ftp.disconnect();
            this.ftp = null;
        }
    }

    public int read() throws IOException {
        throw new UnsupportedOperationException("read() is not supported on SeekableHTTPStream.  Must read in blocks.");
    }
}

