/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

import java.io.File;
import java.io.InputStream;
import net.sf.samtools.BAMIndex;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMFileSpan;
import net.sf.samtools.SAMLineParser;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMRecordFactory;
import net.sf.samtools.SAMTextHeaderCodec;
import net.sf.samtools.util.BufferedLineReader;
import net.sf.samtools.util.CloseableIterator;

class SAMTextReader
extends SAMFileReader.ReaderImplementation {
    private SAMRecordFactory samRecordFactory;
    private BufferedLineReader mReader;
    private SAMFileHeader mFileHeader = null;
    private String mCurrentLine = null;
    private RecordIterator mIterator = null;
    private File mFile = null;
    private SAMFileReader.ValidationStringency validationStringency = SAMFileReader.ValidationStringency.DEFAULT_STRINGENCY;
    private SAMFileReader mParentReader;

    SAMTextReader(InputStream inputStream, SAMFileReader.ValidationStringency validationStringency, SAMRecordFactory sAMRecordFactory) {
        this.mReader = new BufferedLineReader(inputStream);
        this.validationStringency = validationStringency;
        this.samRecordFactory = sAMRecordFactory;
        this.readHeader();
    }

    SAMTextReader(InputStream inputStream, File file, SAMFileReader.ValidationStringency validationStringency, SAMRecordFactory sAMRecordFactory) {
        this(inputStream, validationStringency, sAMRecordFactory);
        this.mFile = file;
    }

    @Override
    void enableFileSource(SAMFileReader sAMFileReader, boolean bl) {
        this.mParentReader = bl ? sAMFileReader : null;
    }

    @Override
    void enableIndexCaching(boolean bl) {
        throw new UnsupportedOperationException("Cannot enable index caching for a SAM text reader");
    }

    @Override
    void enableIndexMemoryMapping(boolean bl) {
        throw new UnsupportedOperationException("Cannot enable index memory mapping for a SAM text reader");
    }

    @Override
    void enableCrcChecking(boolean bl) {
    }

    @Override
    void setSAMRecordFactory(SAMRecordFactory sAMRecordFactory) {
        this.samRecordFactory = sAMRecordFactory;
    }

    @Override
    boolean hasIndex() {
        return false;
    }

    @Override
    BAMIndex getIndex() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void close() {
        if (this.mReader != null) {
            try {
                this.mReader.close();
            }
            finally {
                this.mReader = null;
            }
        }
    }

    @Override
    SAMFileHeader getFileHeader() {
        return this.mFileHeader;
    }

    @Override
    public SAMFileReader.ValidationStringency getValidationStringency() {
        return this.validationStringency;
    }

    @Override
    public void setValidationStringency(SAMFileReader.ValidationStringency validationStringency) {
        this.validationStringency = validationStringency;
    }

    @Override
    CloseableIterator<SAMRecord> getIterator() {
        if (this.mReader == null) {
            throw new IllegalStateException("File reader is closed");
        }
        if (this.mIterator != null) {
            throw new IllegalStateException("Iteration in progress");
        }
        this.mIterator = new RecordIterator();
        return this.mIterator;
    }

    @Override
    CloseableIterator<SAMRecord> getIterator(SAMFileSpan sAMFileSpan) {
        throw new UnsupportedOperationException("Cannot directly iterate over regions within SAM text files.");
    }

    @Override
    SAMFileSpan getFilePointerSpanningReads() {
        throw new UnsupportedOperationException("Cannot retrieve file pointers within SAM text files.");
    }

    @Override
    CloseableIterator<SAMRecord> query(String string, int n, int n2, boolean bl) {
        throw new UnsupportedOperationException("Cannot query SAM text files");
    }

    @Override
    CloseableIterator<SAMRecord> queryAlignmentStart(String string, int n) {
        throw new UnsupportedOperationException("Cannot query SAM text files");
    }

    @Override
    public CloseableIterator<SAMRecord> queryUnmapped() {
        throw new UnsupportedOperationException("Cannot query SAM text files");
    }

    private void readHeader() {
        SAMTextHeaderCodec sAMTextHeaderCodec = new SAMTextHeaderCodec();
        sAMTextHeaderCodec.setValidationStringency(this.validationStringency);
        this.mFileHeader = sAMTextHeaderCodec.decode(this.mReader, this.mFile != null ? this.mFile.toString() : null);
        this.advanceLine();
    }

    private String advanceLine() {
        this.mCurrentLine = this.mReader.readLine();
        return this.mCurrentLine;
    }

    private class RecordIterator
    implements CloseableIterator<SAMRecord> {
        private final SAMLineParser parser;

        private RecordIterator() {
            this.parser = new SAMLineParser(SAMTextReader.this.samRecordFactory, SAMTextReader.this.validationStringency, SAMTextReader.this.mFileHeader, SAMTextReader.this.mParentReader, SAMTextReader.this.mFile);
            if (SAMTextReader.this.mReader == null) {
                throw new IllegalStateException("Reader is closed.");
            }
        }

        @Override
        public void close() {
            SAMTextReader.this.close();
        }

        @Override
        public boolean hasNext() {
            return SAMTextReader.this.mCurrentLine != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SAMRecord next() {
            if (!this.hasNext()) {
                throw new IllegalStateException("Cannot call next() on exhausted iterator");
            }
            try {
                SAMRecord sAMRecord = this.parseLine();
                return sAMRecord;
            }
            finally {
                SAMTextReader.this.advanceLine();
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported: remove");
        }

        private SAMRecord parseLine() {
            return this.parser.parseLine(SAMTextReader.this.mCurrentLine, SAMTextReader.this.mReader.getLineNumber());
        }
    }
}

