/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

import net.sf.samtools.SAMRecord;
import org.testng.Assert;

public class SAMTestUtil {
    public void assertPairValid(SAMRecord sAMRecord, SAMRecord sAMRecord2) {
        Assert.assertEquals((String)sAMRecord.getReadName(), (String)sAMRecord2.getReadName());
        Assert.assertTrue((boolean)sAMRecord.getFirstOfPairFlag());
        Assert.assertTrue((boolean)sAMRecord2.getSecondOfPairFlag());
        Assert.assertFalse((boolean)sAMRecord2.getFirstOfPairFlag());
        Assert.assertFalse((boolean)sAMRecord.getSecondOfPairFlag());
        if (!sAMRecord.getReadUnmappedFlag() && !sAMRecord2.getReadUnmappedFlag()) {
            Assert.assertNotSame((Object)sAMRecord.getReadNegativeStrandFlag(), (Object)sAMRecord2.getReadNegativeStrandFlag());
        }
    }

    public void assertReadValid(SAMRecord sAMRecord) {
        Assert.assertEquals((int)sAMRecord.getReadBases().length, (int)sAMRecord.getBaseQualities().length);
        if (sAMRecord.getReferenceName().equals("*")) {
            Assert.assertEquals((int)sAMRecord.getAlignmentStart(), (int)0);
            Assert.assertTrue((boolean)sAMRecord.getReadUnmappedFlag());
        } else {
            Assert.assertNotSame((Object)sAMRecord.getAlignmentStart(), (Object)0);
        }
        if (sAMRecord.getReadUnmappedFlag()) {
            Assert.assertEquals((int)sAMRecord.getMappingQuality(), (int)0);
            Assert.assertEquals((int)sAMRecord.getCigar().getCigarElements().size(), (int)0);
        } else {
            Assert.assertNotSame(sAMRecord.getCigar().getCigarElements(), (Object)0);
        }
        if (sAMRecord.getReadPairedFlag()) {
            if (sAMRecord.getMateReferenceName().equals("*")) {
                Assert.assertEquals((int)sAMRecord.getMateAlignmentStart(), (int)0);
                Assert.assertTrue((boolean)sAMRecord.getMateUnmappedFlag());
            } else {
                Assert.assertNotSame((Object)sAMRecord.getMateAlignmentStart(), (Object)0);
            }
            if (sAMRecord.getReadUnmappedFlag() || sAMRecord.getMateUnmappedFlag() || !sAMRecord.getReferenceName().equals(sAMRecord.getMateReferenceName())) {
                Assert.assertEquals((int)sAMRecord.getInferredInsertSize(), (int)0);
            } else {
                Assert.assertNotSame((Object)sAMRecord.getInferredInsertSize(), (Object)0);
            }
            if (!sAMRecord.getReadUnmappedFlag() && !sAMRecord.getMateUnmappedFlag()) {
                Assert.assertNotSame((Object)sAMRecord.getReadNegativeStrandFlag(), (Object)sAMRecord.getMateNegativeStrandFlag(), (String)sAMRecord.getReadName());
            }
        } else {
            Assert.assertEquals((int)sAMRecord.getInferredInsertSize(), (int)0);
        }
    }
}

