/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Random;
import java.util.TreeSet;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMFileWriter;
import net.sf.samtools.SAMFileWriterFactory;
import net.sf.samtools.SAMProgramRecord;
import net.sf.samtools.SAMReadGroupRecord;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMRecordCoordinateComparator;
import net.sf.samtools.SAMRecordQueryNameComparator;
import net.sf.samtools.SAMSequenceDictionary;
import net.sf.samtools.SAMSequenceRecord;
import net.sf.samtools.SAMTag;
import net.sf.samtools.util.CloseableIterator;
import net.sf.samtools.util.CoordMath;
import net.sf.samtools.util.RuntimeIOException;

public class SAMRecordSetBuilder
implements Iterable<SAMRecord> {
    private static final String[] chroms = new String[]{"chrM", "chr1", "chr2", "chr3", "chr4", "chr5", "chr6", "chr7", "chr8", "chr9", "chr10", "chr11", "chr12", "chr13", "chr14", "chr15", "chr16", "chr17", "chr18", "chr19", "chr20", "chr21", "chr22", "chrX", "chrY"};
    private static final byte[] BASES = new byte[]{65, 67, 71, 84};
    private static final String READ_GROUP_ID = "1";
    private static final String SAMPLE = "FREE_SAMPLE";
    private final Random random = new Random();
    private SAMFileHeader header;
    private Collection<SAMRecord> records;
    private int readLength = 36;
    private SAMProgramRecord programRecord = null;
    private SAMReadGroupRecord readGroup = null;

    public SAMRecordSetBuilder() {
        this(true, SAMFileHeader.SortOrder.coordinate);
    }

    public SAMRecordSetBuilder(boolean bl, SAMFileHeader.SortOrder sortOrder) {
        this(bl, sortOrder, true);
    }

    public SAMRecordSetBuilder(boolean bl, SAMFileHeader.SortOrder sortOrder, boolean bl2) {
        Object object;
        ArrayList<SAMSequenceRecord> arrayList = new ArrayList<SAMSequenceRecord>();
        for (String string : chroms) {
            SAMSequenceRecord sAMSequenceRecord = new SAMSequenceRecord(string, 1000000);
            arrayList.add(sAMSequenceRecord);
        }
        this.header = new SAMFileHeader();
        this.header.setSequenceDictionary(new SAMSequenceDictionary(arrayList));
        this.header.setSortOrder(sortOrder);
        if (bl) {
            object = sortOrder == SAMFileHeader.SortOrder.queryname ? new SAMRecordQueryNameComparator() : new SAMRecordCoordinateComparator();
            this.records = new TreeSet<SAMRecord>((Comparator<SAMRecord>)object);
        } else {
            this.records = new ArrayList<SAMRecord>();
        }
        if (bl2) {
            object = new SAMReadGroupRecord(READ_GROUP_ID);
            ((SAMReadGroupRecord)object).setSample(SAMPLE);
            ArrayList<SAMReadGroupRecord> arrayList2 = new ArrayList<SAMReadGroupRecord>();
            arrayList2.add((SAMReadGroupRecord)object);
            this.header.setReadGroups(arrayList2);
        }
    }

    public void setRandomSeed(long l) {
        this.random.setSeed(l);
    }

    public void setProgramRecord(SAMProgramRecord sAMProgramRecord) {
        this.programRecord = sAMProgramRecord;
        if (sAMProgramRecord != null) {
            this.header.addProgramRecord(sAMProgramRecord);
        }
    }

    public void setReadGroup(SAMReadGroupRecord sAMReadGroupRecord) {
        this.readGroup = sAMReadGroupRecord;
        if (sAMReadGroupRecord != null) {
            this.header.addReadGroup(sAMReadGroupRecord);
        }
    }

    public Collection<SAMRecord> getRecords() {
        return this.records;
    }

    @Override
    public CloseableIterator<SAMRecord> iterator() {
        return new CloseableIterator<SAMRecord>(){
            private final Iterator<SAMRecord> iterator;
            {
                this.iterator = SAMRecordSetBuilder.this.records.iterator();
            }

            @Override
            public void close() {
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public SAMRecord next() {
                return this.iterator.next();
            }

            @Override
            public void remove() {
                this.iterator.remove();
            }
        };
    }

    public void addFrag(String string, int n, int n2, boolean bl) {
        SAMRecord sAMRecord = new SAMRecord(this.header);
        sAMRecord.setReadName(string);
        sAMRecord.setReferenceIndex(n);
        sAMRecord.setReferenceName(chroms[n]);
        sAMRecord.setAlignmentStart(n2);
        sAMRecord.setReadNegativeStrandFlag(bl);
        sAMRecord.setCigarString(this.readLength + "M");
        sAMRecord.setMappingQuality(255);
        sAMRecord.setAttribute(SAMTag.RG.name(), (Object)READ_GROUP_ID);
        if (this.programRecord != null) {
            sAMRecord.setAttribute(SAMTag.PG.name(), (Object)this.programRecord.getProgramGroupId());
        }
        if (this.readGroup != null) {
            sAMRecord.setAttribute(SAMTag.RG.name(), (Object)this.readGroup.getReadGroupId());
        }
        this.fillInBasesAndQualities(sAMRecord);
        this.records.add(sAMRecord);
    }

    public void addUnmappedFragment(String string) {
        SAMRecord sAMRecord = new SAMRecord(this.header);
        sAMRecord.setReadName(string);
        sAMRecord.setReadUnmappedFlag(true);
        sAMRecord.setAttribute(SAMTag.RG.name(), (Object)READ_GROUP_ID);
        if (this.programRecord != null) {
            sAMRecord.setAttribute(SAMTag.PG.name(), (Object)this.programRecord.getProgramGroupId());
        }
        if (this.readGroup != null) {
            sAMRecord.setAttribute(SAMTag.RG.name(), (Object)this.readGroup.getReadGroupId());
        }
        this.fillInBasesAndQualities(sAMRecord);
        this.records.add(sAMRecord);
    }

    public void addPair(String string, int n, int n2, int n3) {
        SAMRecord sAMRecord = new SAMRecord(this.header);
        SAMRecord sAMRecord2 = new SAMRecord(this.header);
        boolean bl = this.random.nextBoolean();
        sAMRecord.setReadName(string);
        sAMRecord.setReferenceIndex(n);
        sAMRecord.setAlignmentStart(n2);
        sAMRecord.setReadNegativeStrandFlag(false);
        sAMRecord.setCigarString(this.readLength + "M");
        sAMRecord.setMappingQuality(255);
        sAMRecord.setReadPairedFlag(true);
        sAMRecord.setProperPairFlag(true);
        sAMRecord.setMateReferenceIndex(n);
        sAMRecord.setMateAlignmentStart(n3);
        sAMRecord.setMateNegativeStrandFlag(true);
        sAMRecord.setFirstOfPairFlag(bl);
        sAMRecord.setSecondOfPairFlag(!bl);
        sAMRecord.setInferredInsertSize(CoordMath.getLength(n2, CoordMath.getEnd(n3, this.readLength)));
        sAMRecord.setAttribute(SAMTag.RG.name(), (Object)READ_GROUP_ID);
        if (this.programRecord != null) {
            sAMRecord.setAttribute(SAMTag.PG.name(), (Object)this.programRecord.getProgramGroupId());
        }
        if (this.readGroup != null) {
            sAMRecord.setAttribute(SAMTag.RG.name(), (Object)this.readGroup.getReadGroupId());
        }
        this.fillInBasesAndQualities(sAMRecord);
        sAMRecord2.setReadName(string);
        sAMRecord2.setReferenceIndex(n);
        sAMRecord2.setAlignmentStart(n3);
        sAMRecord2.setReadNegativeStrandFlag(true);
        sAMRecord2.setCigarString(this.readLength + "M");
        sAMRecord2.setMappingQuality(255);
        sAMRecord2.setReadPairedFlag(true);
        sAMRecord2.setProperPairFlag(true);
        sAMRecord2.setMateReferenceIndex(n);
        sAMRecord2.setMateAlignmentStart(n2);
        sAMRecord2.setMateNegativeStrandFlag(false);
        sAMRecord2.setFirstOfPairFlag(!bl);
        sAMRecord2.setSecondOfPairFlag(bl);
        sAMRecord2.setInferredInsertSize(sAMRecord.getInferredInsertSize());
        sAMRecord2.setAttribute(SAMTag.RG.name(), (Object)READ_GROUP_ID);
        if (this.programRecord != null) {
            sAMRecord2.setAttribute(SAMTag.PG.name(), (Object)this.programRecord.getProgramGroupId());
        }
        if (this.readGroup != null) {
            sAMRecord2.setAttribute(SAMTag.RG.name(), (Object)this.readGroup.getReadGroupId());
        }
        this.fillInBasesAndQualities(sAMRecord2);
        this.records.add(sAMRecord);
        this.records.add(sAMRecord2);
    }

    public void addUnmappedPair(String string) {
        SAMRecord sAMRecord = new SAMRecord(this.header);
        SAMRecord sAMRecord2 = new SAMRecord(this.header);
        boolean bl = this.random.nextBoolean();
        sAMRecord.setReadName(string);
        sAMRecord.setReadPairedFlag(false);
        sAMRecord.setReadUnmappedFlag(true);
        sAMRecord.setProperPairFlag(false);
        sAMRecord.setFirstOfPairFlag(bl);
        sAMRecord.setSecondOfPairFlag(!bl);
        sAMRecord.setAttribute(SAMTag.RG.name(), (Object)READ_GROUP_ID);
        if (this.programRecord != null) {
            sAMRecord.setAttribute(SAMTag.PG.name(), (Object)this.programRecord.getProgramGroupId());
        }
        this.fillInBasesAndQualities(sAMRecord);
        sAMRecord2.setReadName(string);
        sAMRecord2.setReadPairedFlag(false);
        sAMRecord2.setReadUnmappedFlag(true);
        sAMRecord2.setProperPairFlag(false);
        sAMRecord2.setFirstOfPairFlag(!bl);
        sAMRecord2.setSecondOfPairFlag(bl);
        sAMRecord2.setAttribute(SAMTag.RG.name(), (Object)READ_GROUP_ID);
        if (this.programRecord != null) {
            sAMRecord2.setAttribute(SAMTag.PG.name(), (Object)this.programRecord.getProgramGroupId());
        }
        this.fillInBasesAndQualities(sAMRecord2);
        this.records.add(sAMRecord);
        this.records.add(sAMRecord2);
    }

    private void fillInBasesAndQualities(SAMRecord sAMRecord) {
        int n = this.readLength;
        byte[] byArray = new byte[n];
        byte[] byArray2 = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = BASES[this.random.nextInt(BASES.length)];
            byArray2[i] = (byte)this.random.nextInt(50);
        }
        sAMRecord.setReadBases(byArray);
        sAMRecord.setBaseQualities(byArray2);
    }

    public SAMFileReader getSamReader() {
        File file;
        try {
            file = File.createTempFile("temp", ".sam");
        }
        catch (IOException iOException) {
            throw new RuntimeIOException("problems creating tempfile", iOException);
        }
        this.header.setAttribute("VN", "1.0");
        SAMFileWriter sAMFileWriter = new SAMFileWriterFactory().makeBAMWriter(this.header, true, file);
        for (SAMRecord sAMRecord : this.getRecords()) {
            sAMFileWriter.addAlignment(sAMRecord);
        }
        sAMFileWriter.close();
        SAMFileReader sAMFileReader = new SAMFileReader(file);
        file.deleteOnExit();
        return sAMFileReader;
    }

    public SAMFileHeader getHeader() {
        return this.header;
    }
}

