/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

import java.io.File;
import java.util.NoSuchElementException;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMFileSpan;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMRecordIterator;

public class SAMFileTruncatedReader
extends SAMFileReader {
    private final long maxRecordsToIterate;

    public SAMFileTruncatedReader(File file, long l) {
        super(file);
        this.maxRecordsToIterate = l;
    }

    @Override
    public SAMRecordIterator iterator() {
        return new TruncatedIterator(super.iterator(), this.maxRecordsToIterate);
    }

    @Override
    public SAMRecordIterator iterator(SAMFileSpan sAMFileSpan) {
        return new TruncatedIterator(super.iterator(sAMFileSpan), this.maxRecordsToIterate);
    }

    private class TruncatedIterator
    implements SAMRecordIterator {
        final SAMRecordIterator i;
        final long max;
        long currentRecord = 0L;

        TruncatedIterator(SAMRecordIterator sAMRecordIterator, long l) {
            this.i = sAMRecordIterator;
            this.max = l;
        }

        @Override
        public boolean hasNext() {
            return this.i.hasNext() && this.max != this.currentRecord;
        }

        @Override
        public SAMRecord next() {
            if (this.hasNext()) {
                ++this.currentRecord;
                return (SAMRecord)this.i.next();
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            this.i.remove();
        }

        @Override
        public void close() {
            this.i.close();
        }

        @Override
        public SAMRecordIterator assertSorted(SAMFileHeader.SortOrder sortOrder) {
            return this.i.assertSorted(sortOrder);
        }
    }
}

