/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

import net.sf.samtools.AbstractBAMFileIndex;

public class LinearIndex {
    public static final int MAX_LINEAR_INDEX_SIZE = AbstractBAMFileIndex.MAX_LINEAR_INDEX_SIZE;
    public static final int BAM_LIDX_SHIFT = 14;
    private final int mReferenceSequence;
    private final int mIndexStart;
    private final long[] mIndexEntries;

    public LinearIndex(int n, int n2, long[] lArray) {
        this.mReferenceSequence = n;
        this.mIndexStart = n2;
        this.mIndexEntries = lArray;
    }

    public int getReferenceSequence() {
        return this.mReferenceSequence;
    }

    public int size() {
        return this.mIndexEntries.length;
    }

    public long get(int n) {
        return this.mIndexEntries[n - this.mIndexStart];
    }

    public static int convertToLinearIndexOffset(int n) {
        int n2 = n <= 0 ? 0 : n - 1;
        return n2 >> 14;
    }

    public long getMinimumOffset(int n) {
        int n2 = n <= 0 ? 0 : n - 1;
        int n3 = n2 >> 14;
        long l = 0L;
        if (n3 - this.mIndexStart < this.mIndexEntries.length) {
            l = this.mIndexEntries[n3 - this.mIndexStart];
        }
        return l;
    }

    protected long[] getIndexEntries() {
        return this.mIndexEntries;
    }

    protected int getIndexStart() {
        return this.mIndexStart;
    }
}

