/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

public enum CigarOperator {
    M(true, true, 'M'),
    I(true, false, 'I'),
    D(false, true, 'D'),
    N(false, true, 'N'),
    S(true, false, 'S'),
    H(false, false, 'H'),
    P(false, false, 'P'),
    EQ(true, true, '='),
    X(true, true, 'X');

    private static final byte OP_M = 0;
    private static final byte OP_I = 1;
    private static final byte OP_D = 2;
    private static final byte OP_N = 3;
    private static final byte OP_S = 4;
    private static final byte OP_H = 5;
    private static final byte OP_P = 6;
    private static final byte OP_EQ = 7;
    private static final byte OP_X = 8;
    private final boolean consumesReadBases;
    private final boolean consumesReferenceBases;
    private final byte character;
    private final String string;
    public static final CigarOperator MATCH_OR_MISMATCH;
    public static final CigarOperator INSERTION;
    public static final CigarOperator DELETION;
    public static final CigarOperator SKIPPED_REGION;
    public static final CigarOperator SOFT_CLIP;
    public static final CigarOperator HARD_CLIP;
    public static final CigarOperator PADDING;

    private CigarOperator(boolean bl, boolean bl2, char c) {
        this.consumesReadBases = bl;
        this.consumesReferenceBases = bl2;
        this.character = (byte)c;
        this.string = new String(new char[]{c}).intern();
    }

    public boolean consumesReadBases() {
        return this.consumesReadBases;
    }

    public boolean consumesReferenceBases() {
        return this.consumesReferenceBases;
    }

    public static CigarOperator characterToEnum(int n) {
        switch (n) {
            case 77: {
                return M;
            }
            case 73: {
                return I;
            }
            case 68: {
                return D;
            }
            case 78: {
                return N;
            }
            case 83: {
                return S;
            }
            case 72: {
                return H;
            }
            case 80: {
                return P;
            }
            case 61: {
                return EQ;
            }
            case 88: {
                return X;
            }
        }
        throw new IllegalArgumentException("Unrecognized CigarOperator: " + n);
    }

    public static CigarOperator binaryToEnum(int n) {
        switch (n) {
            case 0: {
                return M;
            }
            case 1: {
                return I;
            }
            case 2: {
                return D;
            }
            case 3: {
                return N;
            }
            case 4: {
                return S;
            }
            case 5: {
                return H;
            }
            case 6: {
                return P;
            }
            case 7: {
                return EQ;
            }
            case 8: {
                return X;
            }
        }
        throw new IllegalArgumentException("Unrecognized CigarOperator: " + n);
    }

    public static int enumToBinary(CigarOperator cigarOperator) {
        switch (cigarOperator) {
            case M: {
                return 0;
            }
            case I: {
                return 1;
            }
            case D: {
                return 2;
            }
            case N: {
                return 3;
            }
            case S: {
                return 4;
            }
            case H: {
                return 5;
            }
            case P: {
                return 6;
            }
            case EQ: {
                return 7;
            }
            case X: {
                return 8;
            }
        }
        throw new IllegalArgumentException("Unrecognized CigarOperator: " + (Object)((Object)cigarOperator));
    }

    public static byte enumToCharacter(CigarOperator cigarOperator) {
        return cigarOperator.character;
    }

    public String toString() {
        return this.string;
    }

    static {
        MATCH_OR_MISMATCH = M;
        INSERTION = I;
        DELETION = D;
        SKIPPED_REGION = N;
        SOFT_CLIP = S;
        HARD_CLIP = H;
        PADDING = P;
    }
}

