/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

import java.io.File;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.WeakHashMap;
import net.sf.samtools.AbstractBAMFileIndex;
import net.sf.samtools.BAMFileSpan;
import net.sf.samtools.BAMIndexContent;
import net.sf.samtools.Bin;
import net.sf.samtools.BinList;
import net.sf.samtools.BrowseableBAMIndex;
import net.sf.samtools.Chunk;
import net.sf.samtools.SAMSequenceDictionary;
import net.sf.samtools.seekablestream.SeekableStream;

class CachingBAMFileIndex
extends AbstractBAMFileIndex
implements BrowseableBAMIndex {
    private Integer mLastReferenceRetrieved = null;
    private WeakHashMap<Integer, BAMIndexContent> mQueriesByReference = new WeakHashMap();

    public CachingBAMFileIndex(File file, SAMSequenceDictionary sAMSequenceDictionary) {
        super(file, sAMSequenceDictionary);
    }

    public CachingBAMFileIndex(SeekableStream seekableStream, SAMSequenceDictionary sAMSequenceDictionary) {
        super(seekableStream, sAMSequenceDictionary);
    }

    public CachingBAMFileIndex(File file, SAMSequenceDictionary sAMSequenceDictionary, boolean bl) {
        super(file, sAMSequenceDictionary, bl);
    }

    @Override
    public BAMFileSpan getSpanOverlapping(int n, int n2, int n3) {
        BAMIndexContent bAMIndexContent = this.getQueryResults(n);
        if (bAMIndexContent == null) {
            return null;
        }
        BinList binList = this.getBinsOverlapping(n, n2, n3);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Object object : bAMIndexContent.getBins()) {
            if (!binList.getBins().get(((Bin)object).getBinNumber())) continue;
            arrayList.add(object);
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        List<Chunk> list = new ArrayList();
        for (Bin bin : arrayList) {
            for (Chunk chunk : bin.getChunkList()) {
                list.add(chunk.clone());
            }
        }
        if (list.isEmpty()) {
            return null;
        }
        list = this.optimizeChunkList(list, bAMIndexContent.getLinearIndex().getMinimumOffset(n2));
        return new BAMFileSpan(list);
    }

    @Override
    public BinList getBinsOverlapping(int n, int n2, int n3) {
        BitSet bitSet = this.regionToBins(n2, n3);
        if (bitSet == null) {
            return null;
        }
        return new BinList(n, bitSet);
    }

    @Override
    public BAMFileSpan getSpanOverlapping(Bin bin) {
        if (bin == null) {
            return null;
        }
        int n = bin.getReferenceSequence();
        BAMIndexContent bAMIndexContent = this.getQueryResults(n);
        if (bAMIndexContent == null) {
            return null;
        }
        int n2 = this.getLevelForBin(bin);
        int n3 = this.getFirstLocusInBin(bin);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (bAMIndexContent.containsBin(bin)) {
            arrayList.add(bAMIndexContent.getBins().getBin(bin.getBinNumber()));
        }
        int n4 = n2;
        while (--n4 >= 0) {
            int n5 = CachingBAMFileIndex.getFirstBinInLevel(n4);
            int n6 = this.getMaxAddressibleGenomicLocation() / this.getLevelSize(n4);
            int n7 = n3 / n6 + n5;
            Bin bin2 = bAMIndexContent.getBins().getBin(n7);
            if (bin2 == null || !bAMIndexContent.containsBin(bin2)) continue;
            arrayList.add(bin2);
        }
        List<Chunk> list = new ArrayList<Chunk>();
        for (Bin bin3 : arrayList) {
            for (Chunk chunk : bin3.getChunkList()) {
                list.add(chunk.clone());
            }
        }
        int n8 = this.getFirstLocusInBin(bin);
        list = this.optimizeChunkList(list, bAMIndexContent.getLinearIndex().getMinimumOffset(n8));
        return new BAMFileSpan(list);
    }

    @Override
    protected BAMIndexContent getQueryResults(int n) {
        if (this.mLastReferenceRetrieved != null && this.mLastReferenceRetrieved == n) {
            return this.mQueriesByReference.get(n);
        }
        BAMIndexContent bAMIndexContent = this.mQueriesByReference.get(n);
        if (bAMIndexContent != null) {
            this.mLastReferenceRetrieved = n;
            this.mQueriesByReference.put(n, bAMIndexContent);
            return bAMIndexContent;
        }
        bAMIndexContent = this.query(n, 1, -1);
        if (bAMIndexContent != null) {
            this.mLastReferenceRetrieved = n;
            this.mQueriesByReference.put(n, bAMIndexContent);
            return bAMIndexContent;
        }
        return null;
    }
}

