/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import net.sf.samtools.SAMBinaryTagAndUnsignedArrayValue;
import net.sf.samtools.SAMBinaryTagAndValue;
import net.sf.samtools.SAMException;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMFormatException;
import net.sf.samtools.SAMUtils;
import net.sf.samtools.SAMValidationError;
import net.sf.samtools.TagValueAndUnsignedArrayFlag;
import net.sf.samtools.util.BinaryCodec;
import net.sf.samtools.util.StringUtil;

class BinaryTagCodec {
    private static final int FIXED_TAG_SIZE = 3;
    private static final int FIXED_BINARY_ARRAY_TAG_SIZE = 5;
    private static final long MAX_INT = Integer.MAX_VALUE;
    private static final long MAX_UINT = 0xFFFFFFFFL;
    private static final long MAX_SHORT = 32767L;
    private static final long MAX_USHORT = 65535L;
    private static final long MAX_BYTE = 127L;
    private static final long MAX_UBYTE = 255L;
    final BinaryCodec binaryCodec;

    BinaryTagCodec(BinaryCodec binaryCodec) {
        this.binaryCodec = binaryCodec;
    }

    private static int getBinaryValueSize(Object object) {
        switch (BinaryTagCodec.getTagValueType(object)) {
            case 'Z': {
                return ((String)object).length() + 1;
            }
            case 'A': {
                return 1;
            }
            case 'I': 
            case 'i': {
                return 4;
            }
            case 'S': 
            case 's': {
                return 2;
            }
            case 'C': 
            case 'c': {
                return 1;
            }
            case 'f': {
                return 4;
            }
            case 'H': {
                byte[] byArray = (byte[])object;
                return byArray.length * 2 + 1;
            }
            case 'B': {
                int n;
                int n2 = Array.getLength(object);
                if (object instanceof byte[]) {
                    n = 1;
                } else if (object instanceof short[]) {
                    n = 2;
                } else if (object instanceof int[]) {
                    n = 4;
                } else if (object instanceof float[]) {
                    n = 4;
                } else {
                    throw new IllegalArgumentException("Unsupported array type: " + object.getClass());
                }
                return n2 * n + 5;
            }
        }
        throw new IllegalArgumentException("When writing BAM, unrecognized tag type " + object.getClass().getName());
    }

    static int getTagSize(Object object) {
        return 3 + BinaryTagCodec.getBinaryValueSize(object);
    }

    static char getTagValueType(Object object) {
        if (object instanceof String) {
            return 'Z';
        }
        if (object instanceof Character) {
            return 'A';
        }
        if (object instanceof Float) {
            return 'f';
        }
        if (object instanceof Number) {
            if (!(object instanceof Byte || object instanceof Short || object instanceof Integer || object instanceof Long)) {
                throw new IllegalArgumentException("Unrecognized tag type " + object.getClass().getName());
            }
            return BinaryTagCodec.getIntegerType(((Number)object).longValue());
        }
        if (object instanceof byte[] || object instanceof short[] || object instanceof int[] || object instanceof float[]) {
            return 'B';
        }
        throw new IllegalArgumentException("When writing BAM, unrecognized tag type " + object.getClass().getName());
    }

    private static char getIntegerType(long l) {
        if (l > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Integer attribute value too large to be encoded in BAM");
        }
        if (l > Integer.MAX_VALUE) {
            return 'I';
        }
        if (l > 65535L) {
            return 'i';
        }
        if (l > 32767L) {
            return 'S';
        }
        if (l > 255L) {
            return 's';
        }
        if (l > 127L) {
            return 'C';
        }
        if (l >= -128L) {
            return 'c';
        }
        if (l >= -32768L) {
            return 's';
        }
        if (l >= Integer.MIN_VALUE) {
            return 'i';
        }
        throw new IllegalArgumentException("Integer attribute value too negative to be encoded in BAM");
    }

    void writeTag(short s, Object object, boolean bl) {
        this.binaryCodec.writeShort(s);
        char c = BinaryTagCodec.getTagValueType(object);
        this.binaryCodec.writeByte(c);
        switch (c) {
            case 'Z': {
                this.binaryCodec.writeString((String)object, false, true);
                break;
            }
            case 'A': {
                this.binaryCodec.writeByte(((Character)object).charValue());
                break;
            }
            case 'I': {
                this.binaryCodec.writeUInt((Long)object);
                break;
            }
            case 'i': {
                this.binaryCodec.writeInt(((Number)object).intValue());
                break;
            }
            case 's': {
                this.binaryCodec.writeShort(((Number)object).shortValue());
                break;
            }
            case 'S': {
                this.binaryCodec.writeUShort(((Number)object).intValue());
                break;
            }
            case 'c': {
                this.binaryCodec.writeByte(((Number)object).byteValue());
                break;
            }
            case 'C': {
                this.binaryCodec.writeUByte(((Integer)object).shortValue());
                break;
            }
            case 'f': {
                this.binaryCodec.writeFloat(((Float)object).floatValue());
                break;
            }
            case 'B': {
                this.writeArray(object, bl);
                break;
            }
            default: {
                throw new IllegalArgumentException("When writing BAM, unrecognized tag type " + object.getClass().getName());
            }
        }
    }

    private void writeArray(Object object, boolean bl) {
        if (object instanceof byte[]) {
            this.binaryCodec.writeByte(bl ? 67 : 99);
            byte[] byArray = (byte[])object;
            this.binaryCodec.writeInt(byArray.length);
            for (byte by : byArray) {
                this.binaryCodec.writeByte(by);
            }
        } else if (object instanceof short[]) {
            this.binaryCodec.writeByte(bl ? 83 : 115);
            short[] sArray = (short[])object;
            this.binaryCodec.writeInt(sArray.length);
            for (short s : sArray) {
                this.binaryCodec.writeShort(s);
            }
        } else if (object instanceof int[]) {
            this.binaryCodec.writeByte(bl ? 73 : 105);
            int[] nArray = (int[])object;
            this.binaryCodec.writeInt(nArray.length);
            for (int n : nArray) {
                this.binaryCodec.writeInt(n);
            }
        } else if (object instanceof float[]) {
            this.binaryCodec.writeByte(102);
            float[] fArray = (float[])object;
            this.binaryCodec.writeInt(fArray.length);
            for (float f : fArray) {
                this.binaryCodec.writeFloat(f);
            }
        } else {
            throw new SAMException("Unrecognized array value type: " + object.getClass());
        }
    }

    static SAMBinaryTagAndValue readTags(byte[] byArray, int n, int n2, SAMFileReader.ValidationStringency validationStringency) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n, n2);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        SAMBinaryTagAndValue sAMBinaryTagAndValue = null;
        SAMBinaryTagAndValue sAMBinaryTagAndValue2 = null;
        while (byteBuffer.hasRemaining()) {
            SAMBinaryTagAndValue sAMBinaryTagAndValue3;
            short s = byteBuffer.getShort();
            byte by = byteBuffer.get();
            if (by != 66) {
                sAMBinaryTagAndValue3 = new SAMBinaryTagAndValue(s, BinaryTagCodec.readSingleValue(by, byteBuffer, validationStringency));
            } else {
                TagValueAndUnsignedArrayFlag tagValueAndUnsignedArrayFlag = BinaryTagCodec.readArray(byteBuffer, validationStringency);
                sAMBinaryTagAndValue3 = tagValueAndUnsignedArrayFlag.isUnsignedArray ? new SAMBinaryTagAndUnsignedArrayValue(s, tagValueAndUnsignedArrayFlag.value) : new SAMBinaryTagAndValue(s, tagValueAndUnsignedArrayFlag.value);
            }
            if (sAMBinaryTagAndValue == null) {
                sAMBinaryTagAndValue = sAMBinaryTagAndValue3;
                sAMBinaryTagAndValue2 = sAMBinaryTagAndValue3;
                continue;
            }
            if (sAMBinaryTagAndValue3.tag > sAMBinaryTagAndValue2.tag) {
                sAMBinaryTagAndValue2.insert(sAMBinaryTagAndValue3);
                sAMBinaryTagAndValue2 = sAMBinaryTagAndValue3;
                continue;
            }
            sAMBinaryTagAndValue = sAMBinaryTagAndValue.insert(sAMBinaryTagAndValue3);
        }
        return sAMBinaryTagAndValue;
    }

    private static Object readSingleValue(byte by, ByteBuffer byteBuffer, SAMFileReader.ValidationStringency validationStringency) {
        switch (by) {
            case 90: {
                return BinaryTagCodec.readNullTerminatedString(byteBuffer);
            }
            case 65: {
                return Character.valueOf((char)byteBuffer.get());
            }
            case 73: {
                long l = (long)byteBuffer.getInt() & 0xFFFFFFFFL;
                if (l <= Integer.MAX_VALUE) {
                    return (int)l;
                }
                SAMUtils.processValidationError(new SAMValidationError(SAMValidationError.Type.TAG_VALUE_TOO_LARGE, "Tag value " + l + " too large to store as signed integer.", null), validationStringency);
                return l;
            }
            case 105: {
                return byteBuffer.getInt();
            }
            case 115: {
                return (int)byteBuffer.getShort();
            }
            case 83: {
                return byteBuffer.getShort() & 0xFFFF;
            }
            case 99: {
                return (int)byteBuffer.get();
            }
            case 67: {
                return byteBuffer.get() & 0xFF;
            }
            case 102: {
                return Float.valueOf(byteBuffer.getFloat());
            }
            case 72: {
                String string = BinaryTagCodec.readNullTerminatedString(byteBuffer);
                return StringUtil.hexStringToBytes(string);
            }
        }
        throw new SAMFormatException("Unrecognized tag type: " + (char)by);
    }

    private static TagValueAndUnsignedArrayFlag readArray(ByteBuffer byteBuffer, SAMFileReader.ValidationStringency validationStringency) {
        Object[] objectArray;
        byte by = byteBuffer.get();
        boolean bl = Character.isUpperCase(by);
        int n = byteBuffer.getInt();
        switch (Character.toLowerCase(by)) {
            case 99: {
                byte[] byArray;
                objectArray = byArray = new byte[n];
                byteBuffer.get(byArray);
                break;
            }
            case 115: {
                short[] sArray = new short[n];
                objectArray = sArray;
                for (int i = 0; i < n; ++i) {
                    sArray[i] = byteBuffer.getShort();
                }
                break;
            }
            case 105: {
                int[] nArray = new int[n];
                objectArray = nArray;
                for (int i = 0; i < n; ++i) {
                    nArray[i] = byteBuffer.getInt();
                }
                break;
            }
            case 102: {
                float[] fArray = new float[n];
                objectArray = fArray;
                for (int i = 0; i < n; ++i) {
                    fArray[i] = byteBuffer.getFloat();
                }
                break;
            }
            default: {
                throw new SAMFormatException("Unrecognized tag array type: " + (char)by);
            }
        }
        return new TagValueAndUnsignedArrayFlag(objectArray, bl);
    }

    private static String readNullTerminatedString(ByteBuffer byteBuffer) {
        byteBuffer.mark();
        int n = byteBuffer.position();
        while (byteBuffer.get() != 0) {
        }
        int n2 = byteBuffer.position();
        byte[] byArray = new byte[n2 - n - 1];
        byteBuffer.reset();
        byteBuffer.get(byArray);
        byteBuffer.get();
        return StringUtil.bytesToString(byArray);
    }
}

