/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

import java.io.DataOutputStream;
import java.io.File;
import java.io.OutputStream;
import net.sf.samtools.BAMFileConstants;
import net.sf.samtools.BAMFileSpan;
import net.sf.samtools.BAMIndexer;
import net.sf.samtools.BAMRecordCodec;
import net.sf.samtools.Chunk;
import net.sf.samtools.SAMException;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileSource;
import net.sf.samtools.SAMFileWriterImpl;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMSequenceRecord;
import net.sf.samtools.util.BinaryCodec;
import net.sf.samtools.util.BlockCompressedOutputStream;

public class BAMFileWriter
extends SAMFileWriterImpl {
    private final BinaryCodec outputBinaryCodec;
    private BAMRecordCodec bamRecordCodec = null;
    private final BlockCompressedOutputStream blockCompressedOutputStream;
    private BAMIndexer bamIndexer = null;

    public BAMFileWriter(File file) {
        this.blockCompressedOutputStream = new BlockCompressedOutputStream(file);
        this.outputBinaryCodec = new BinaryCodec(new DataOutputStream(this.blockCompressedOutputStream));
        this.outputBinaryCodec.setOutputFileName(file.getAbsolutePath());
    }

    public BAMFileWriter(File file, int n) {
        this.blockCompressedOutputStream = new BlockCompressedOutputStream(file, n);
        this.outputBinaryCodec = new BinaryCodec(new DataOutputStream(this.blockCompressedOutputStream));
        this.outputBinaryCodec.setOutputFileName(file.getAbsolutePath());
    }

    public BAMFileWriter(OutputStream outputStream, File file) {
        this.blockCompressedOutputStream = new BlockCompressedOutputStream(outputStream, file);
        this.outputBinaryCodec = new BinaryCodec(new DataOutputStream(this.blockCompressedOutputStream));
        this.outputBinaryCodec.setOutputFileName(this.getPathString(file));
    }

    public BAMFileWriter(OutputStream outputStream, File file, int n) {
        this.blockCompressedOutputStream = new BlockCompressedOutputStream(outputStream, file, n);
        this.outputBinaryCodec = new BinaryCodec(new DataOutputStream(this.blockCompressedOutputStream));
        this.outputBinaryCodec.setOutputFileName(this.getPathString(file));
    }

    private void prepareToWriteAlignments() {
        if (this.bamRecordCodec == null) {
            this.bamRecordCodec = new BAMRecordCodec(this.getFileHeader());
            this.bamRecordCodec.setOutputStream(this.outputBinaryCodec.getOutputStream(), this.getFilename());
        }
    }

    private String getPathString(File file) {
        return file != null ? file.getAbsolutePath() : null;
    }

    void enableBamIndexConstruction() {
        if (!this.getSortOrder().equals((Object)SAMFileHeader.SortOrder.coordinate)) {
            throw new SAMException("Not creating BAM index since not sorted by coordinates: " + (Object)((Object)this.getSortOrder()));
        }
        if (this.getFilename() == null) {
            throw new SAMException("Not creating BAM index since we don't have an output file name");
        }
        this.bamIndexer = this.createBamIndex(this.getFilename());
    }

    private BAMIndexer createBamIndex(String string) {
        try {
            String string2 = string.endsWith(".bam") ? string.substring(0, string.lastIndexOf(".")) : string;
            File file = new File(string2 + ".bai");
            if (file.exists() && !file.canWrite()) {
                throw new SAMException("Not creating BAM index since unable to write index file " + file);
            }
            return new BAMIndexer(file, this.getFileHeader());
        }
        catch (Exception exception) {
            throw new SAMException("Not creating BAM index", exception);
        }
    }

    @Override
    protected void writeAlignment(SAMRecord sAMRecord) {
        this.prepareToWriteAlignments();
        if (this.bamIndexer != null) {
            try {
                long l = this.blockCompressedOutputStream.getFilePointer();
                this.bamRecordCodec.encode(sAMRecord);
                long l2 = this.blockCompressedOutputStream.getFilePointer();
                sAMRecord.setFileSource(new SAMFileSource(null, new BAMFileSpan(new Chunk(l, l2))));
                this.bamIndexer.processAlignment(sAMRecord);
            }
            catch (Exception exception) {
                this.bamIndexer = null;
                throw new SAMException("Exception when processing alignment for BAM index " + sAMRecord, exception);
            }
        } else {
            this.bamRecordCodec.encode(sAMRecord);
        }
    }

    @Override
    protected void writeHeader(String string) {
        this.outputBinaryCodec.writeBytes(BAMFileConstants.BAM_MAGIC);
        this.outputBinaryCodec.writeString(string, true, false);
        this.outputBinaryCodec.writeInt(this.getFileHeader().getSequenceDictionary().size());
        for (SAMSequenceRecord sAMSequenceRecord : this.getFileHeader().getSequenceDictionary().getSequences()) {
            this.outputBinaryCodec.writeString(sAMSequenceRecord.getSequenceName(), true, true);
            this.outputBinaryCodec.writeInt(sAMSequenceRecord.getSequenceLength());
        }
    }

    @Override
    protected void finish() {
        this.outputBinaryCodec.close();
        try {
            if (this.bamIndexer != null) {
                this.bamIndexer.finish();
            }
        }
        catch (Exception exception) {
            throw new SAMException("Exception writing BAM index file", exception);
        }
    }

    @Override
    protected String getFilename() {
        return this.outputBinaryCodec.getOutputFileName();
    }
}

