/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sf.samtools.Chunk;
import net.sf.samtools.SAMException;
import net.sf.samtools.SAMFileSpan;

class BAMFileSpan
implements SAMFileSpan,
Serializable {
    private static final long serialVersionUID = 1L;
    private final List<Chunk> chunks;

    protected BAMFileSpan() {
        this.chunks = new ArrayList<Chunk>();
    }

    protected BAMFileSpan(Chunk chunk) {
        this.chunks = new ArrayList<Chunk>();
        this.chunks.add(chunk);
    }

    protected BAMFileSpan(List<Chunk> list) {
        this.chunks = new ArrayList<Chunk>(list);
    }

    @Override
    public boolean isEmpty() {
        return this.chunks.isEmpty();
    }

    public BAMFileSpan clone() {
        BAMFileSpan bAMFileSpan = new BAMFileSpan();
        for (Chunk chunk : this.chunks) {
            bAMFileSpan.chunks.add(chunk.clone());
        }
        return bAMFileSpan;
    }

    @Override
    public SAMFileSpan removeContentsBefore(SAMFileSpan sAMFileSpan) {
        if (sAMFileSpan == null) {
            return this.clone();
        }
        if (!(sAMFileSpan instanceof BAMFileSpan)) {
            throw new SAMException("Unable to compare ");
        }
        BAMFileSpan bAMFileSpan = (BAMFileSpan)sAMFileSpan;
        if (bAMFileSpan.isEmpty()) {
            return this.clone();
        }
        this.validateSorted();
        BAMFileSpan bAMFileSpan2 = new BAMFileSpan();
        for (Chunk chunk : this.chunks) {
            if (chunk.getChunkEnd() <= chunk.getChunkStart()) continue;
            if (chunk.getChunkStart() >= bAMFileSpan.chunks.get(0).getChunkStart()) {
                bAMFileSpan2.add(chunk.clone());
                continue;
            }
            bAMFileSpan2.add(new Chunk(bAMFileSpan.chunks.get(0).getChunkStart(), chunk.getChunkEnd()));
        }
        return bAMFileSpan2;
    }

    @Override
    public SAMFileSpan getContentsFollowing() {
        if (this.chunks.isEmpty()) {
            throw new SAMException("Unable to get the file pointer following this one: no data present.");
        }
        this.validateSorted();
        return new BAMFileSpan(new Chunk(this.chunks.get(this.chunks.size() - 1).getChunkEnd(), Long.MAX_VALUE));
    }

    public void add(BAMFileSpan bAMFileSpan) {
        for (Chunk chunk : bAMFileSpan.chunks) {
            this.chunks.add(chunk);
        }
    }

    protected void add(Chunk chunk) {
        this.chunks.add(chunk);
    }

    protected long[] toCoordinateArray() {
        int n = this.chunks.size() * 2;
        if (n == 0) {
            return null;
        }
        int n2 = 0;
        long[] lArray = new long[n];
        for (Chunk chunk : this.chunks) {
            lArray[n2++] = chunk.getChunkStart();
            lArray[n2++] = chunk.getChunkEnd();
        }
        return lArray;
    }

    protected long getFirstOffset() {
        long l = 0L;
        if (this.chunks == null) {
            return l;
        }
        Iterator<Chunk> iterator = this.chunks.iterator();
        if (iterator.hasNext()) {
            Chunk chunk = iterator.next();
            return chunk.getChunkStart();
        }
        return l;
    }

    protected List<Chunk> getChunks() {
        return Collections.unmodifiableList(this.chunks);
    }

    protected Chunk getSingleChunk() {
        if (this.chunks.size() != 1) {
            throw new SAMException("Expecting a single chunk for span. Found " + this.chunks.size());
        }
        return this.chunks.get(0);
    }

    protected static SAMFileSpan toChunkList(long[] lArray) {
        if (lArray.length % 2 != 0) {
            throw new SAMException("Data supplied does not appear to be in coordinate array format.");
        }
        BAMFileSpan bAMFileSpan = new BAMFileSpan();
        for (int i = 0; i < lArray.length; i += 2) {
            bAMFileSpan.add(new Chunk(lArray[i], lArray[i + 1]));
        }
        bAMFileSpan.validateSorted();
        return bAMFileSpan;
    }

    private void validateSorted() {
        for (int i = 1; i < this.chunks.size(); ++i) {
            if (this.chunks.get(i).getChunkStart() >= this.chunks.get(i - 1).getChunkEnd()) continue;
            throw new SAMException(String.format("Chunk list is unsorted; chunk %s is before chunk %s", this.chunks.get(i - 1), this.chunks.get(i)));
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (Chunk chunk : this.chunks) {
            if (!bl) {
                stringBuilder.append(';');
                bl = false;
            }
            stringBuilder.append(chunk);
        }
        return stringBuilder.toString();
    }
}

