/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileWriter;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.util.AbstractAsyncWriter;

class AsyncSAMFileWriter
extends AbstractAsyncWriter<SAMRecord>
implements SAMFileWriter {
    private final SAMFileWriter underlyingWriter;

    public AsyncSAMFileWriter(SAMFileWriter sAMFileWriter) {
        this(sAMFileWriter, 2000);
    }

    public AsyncSAMFileWriter(SAMFileWriter sAMFileWriter, int n) {
        super(n);
        this.underlyingWriter = sAMFileWriter;
    }

    @Override
    protected void synchronouslyWrite(SAMRecord sAMRecord) {
        this.underlyingWriter.addAlignment(sAMRecord);
    }

    @Override
    protected void synchronouslyClose() {
        this.underlyingWriter.close();
    }

    @Override
    protected final String getThreadNamePrefix() {
        return "SAMFileWriterThread-";
    }

    @Override
    public void addAlignment(SAMRecord sAMRecord) {
        this.write(sAMRecord);
    }

    @Override
    public SAMFileHeader getFileHeader() {
        return this.underlyingWriter.getFileHeader();
    }
}

