/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import net.sf.picard.PicardException;
import net.sf.picard.io.IoUtil;
import net.sf.picard.util.Log;
import net.sf.picard.util.ProcessExecutor;
import net.sf.samtools.util.CollectionUtil;
import net.sf.samtools.util.IOUtil;

public class RExecutor {
    private static final Log LOG = Log.getInstance(RExecutor.class);
    private static final String R_EXE = "Rscript";

    public static int executeFromClasspath(String string, String ... stringArray) {
        File file = RExecutor.writeScriptFile(string);
        int n = RExecutor.executeFromFile(file, stringArray);
        IOUtil.deleteFiles(file);
        return n;
    }

    public static int executeFromFile(File file, String ... stringArray) {
        String[] stringArray2 = new String[stringArray.length + 2];
        stringArray2[0] = R_EXE;
        stringArray2[1] = file.getAbsolutePath();
        System.arraycopy(stringArray, 0, stringArray2, 2, stringArray.length);
        LOG.info(String.format("Executing R script via command: %s", CollectionUtil.join(Arrays.asList(stringArray2), " ")));
        return ProcessExecutor.execute(stringArray2);
    }

    private static File writeScriptFile(String string) {
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            inputStream = RExecutor.class.getClassLoader().getResourceAsStream(string);
            if (inputStream == null) {
                throw new IllegalArgumentException("Script [" + string + "] not found in classpath");
            }
            File file = File.createTempFile("script", ".R");
            outputStream = IoUtil.openFileForWriting(file);
            IoUtil.copyStream(inputStream, outputStream);
            File file2 = file;
            return file2;
        }
        catch (IOException iOException) {
            throw new PicardException("Unexpected exception creating R script file", iOException);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

