/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.util;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import net.sf.picard.util.Log;
import net.sf.samtools.SAMRecord;

public class ProgressLogger {
    private final Log log;
    private final int n;
    private final String verb;
    private final long startTime = System.currentTimeMillis();
    private final NumberFormat fmt = new DecimalFormat("#,###");
    private final NumberFormat timeFmt = new DecimalFormat("00");
    private long processed = 0L;
    private long lastStartTime = this.startTime;

    public ProgressLogger(Log log, int n, String string) {
        this.log = log;
        this.n = n;
        this.verb = string;
    }

    public ProgressLogger(Log log, int n) {
        this(log, n, "Processed");
    }

    public ProgressLogger(Log log) {
        this(log, 1000000);
    }

    public synchronized boolean record(String string, int n) {
        if (++this.processed % (long)this.n == 0L) {
            long l = System.currentTimeMillis();
            long l2 = (l - this.lastStartTime) / 1000L;
            this.lastStartTime = l;
            long l3 = (System.currentTimeMillis() - this.startTime) / 1000L;
            String string2 = this.formatElapseTime(l3);
            String string3 = this.pad(this.fmt.format(l2), 4);
            String string4 = this.pad(this.fmt.format(this.processed), 13);
            String string5 = string == null ? "*/*" : string + ":" + this.fmt.format(n);
            this.log.info(this.verb, " ", string4, " records.  Elapsed time: ", string2, "s.  Time for last ", this.fmt.format(this.n), ": ", string3, "s.  Last read position: ", string5);
            return true;
        }
        return false;
    }

    public synchronized boolean record(SAMRecord sAMRecord) {
        if (sAMRecord.getReferenceIndex() == -1) {
            return this.record(null, 0);
        }
        return this.record(sAMRecord.getReferenceName(), sAMRecord.getAlignmentStart());
    }

    public boolean record(SAMRecord ... sAMRecordArray) {
        boolean bl = false;
        for (SAMRecord sAMRecord : sAMRecordArray) {
            bl = this.record(sAMRecord) || bl;
        }
        return bl;
    }

    public long getCount() {
        return this.processed;
    }

    public long getElapsedSeconds() {
        return (System.currentTimeMillis() - this.startTime) / 1000L;
    }

    private String pad(String string, int n) {
        while (string.length() < n) {
            string = " " + string;
        }
        return string;
    }

    private String formatElapseTime(long l) {
        long l2 = l % 60L;
        long l3 = l / 60L;
        long l4 = l3 % 60L;
        long l5 = l3 / 60L;
        return this.timeFmt.format(l5) + ":" + this.timeFmt.format(l4) + ":" + this.timeFmt.format(l2);
    }
}

