/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.util;

import java.math.BigDecimal;

public class MathUtil {
    public static final double MAX_PROB_BELOW_ONE = 0.9999999999999999;

    public static double mean(double[] dArray, int n, int n2) {
        double d = 0.0;
        for (int i = n; i < n2; ++i) {
            d += dArray[i];
        }
        return d / (double)(n2 - n);
    }

    public static double stddev(double[] dArray, int n, int n2) {
        return MathUtil.stddev(dArray, n, n2, MathUtil.mean(dArray, n, n2));
    }

    public static double stddev(double[] dArray, int n, int n2, double d) {
        double d2 = 0.0;
        for (int i = n; i < n2; ++i) {
            d2 += dArray[i] * dArray[i];
        }
        return Math.sqrt(d2 / (double)(n2 - n) - d * d);
    }

    public static int compare(int n, int n2) {
        return n < n2 ? -1 : (n == n2 ? 0 : 1);
    }

    public static Double percentageOrNull(Long l, Long l2) {
        if (l != null && l2 != null && l2 != 0L) {
            return l.doubleValue() / l2.doubleValue();
        }
        return null;
    }

    public static double round(double d, int n) {
        BigDecimal bigDecimal = new BigDecimal(d);
        bigDecimal = bigDecimal.setScale(n, 4);
        return bigDecimal.doubleValue();
    }

    public static double max(double[] dArray) {
        double d = dArray[0];
        for (int i = 1; i < dArray.length; ++i) {
            if (!(dArray[i] > d)) continue;
            d = dArray[i];
        }
        return d;
    }

    public static double min(double[] dArray) {
        double d = dArray[0];
        for (int i = 1; i < dArray.length; ++i) {
            if (!(dArray[i] < d)) continue;
            d = dArray[i];
        }
        return d;
    }

    public static double[] promote(int[] nArray) {
        double[] dArray = new double[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            dArray[i] = nArray[i];
        }
        return dArray;
    }

    public static double[] logLikelihoodsToProbs(double[] dArray) {
        double d = MathUtil.max(dArray);
        double d2 = 300.0 - d;
        double[] dArray2 = new double[dArray.length];
        double d3 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = Math.pow(10.0, dArray[i] + d2);
            d3 += dArray2[i];
        }
        double d4 = (double)1.110223E-16f / (double)(dArray2.length - 1);
        for (int i = 0; i < dArray.length; ++i) {
            int n = i;
            dArray2[n] = dArray2[n] / d3;
            if (dArray2[i] > 0.9999999999999999) {
                dArray2[i] = 0.9999999999999999;
                continue;
            }
            if (!(dArray2[i] < d4)) continue;
            dArray2[i] = d4;
        }
        return dArray2;
    }

    public static double[] multiply(double[] dArray, double[] dArray2) {
        if (dArray.length != dArray2.length) {
            throw new IllegalArgumentException("Arrays must be of same length.");
        }
        int n = dArray.length;
        double[] dArray3 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray3[i] = dArray[i] * dArray2[i];
        }
        return dArray3;
    }

    public static double sum(double[] dArray) {
        double d = 0.0;
        for (double d2 : dArray) {
            d += d2;
        }
        return d;
    }
}

