/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.util;

import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;

public final class Log {
    private static LogLevel globalLogLevel = LogLevel.DEBUG;
    private final Class<?> clazz;
    private final String className;
    private final PrintStream out = System.err;

    private Log(Class<?> clazz) {
        this.clazz = clazz;
        this.className = clazz.getSimpleName();
    }

    public static Log getInstance(Class<?> clazz) {
        return new Log(clazz);
    }

    public static void setGlobalLogLevel(LogLevel logLevel) {
        globalLogLevel = logLevel;
    }

    public final boolean isEnabled(LogLevel logLevel) {
        return logLevel.ordinal() <= globalLogLevel.ordinal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void emit(LogLevel logLevel, Throwable throwable, Object ... objectArray) {
        if (this.isEnabled(logLevel)) {
            Log log = this;
            synchronized (log) {
                this.out.print(logLevel.name());
                this.out.print('\t');
                this.out.print(this.getTimestamp());
                this.out.print('\t');
                this.out.print(this.className);
                this.out.print('\t');
                for (Object object : objectArray) {
                    if (object != null && object.getClass().isArray()) {
                        Class<?> clazz = object.getClass().getComponentType();
                        if (clazz.equals(Boolean.TYPE)) {
                            this.out.print(Arrays.toString((boolean[])object));
                            continue;
                        }
                        if (clazz.equals(Byte.TYPE)) {
                            this.out.print(Arrays.toString((byte[])object));
                            continue;
                        }
                        if (clazz.equals(Character.TYPE)) {
                            this.out.print(Arrays.toString((char[])object));
                            continue;
                        }
                        if (clazz.equals(Double.TYPE)) {
                            this.out.print(Arrays.toString((double[])object));
                            continue;
                        }
                        if (clazz.equals(Float.TYPE)) {
                            this.out.print(Arrays.toString((float[])object));
                            continue;
                        }
                        if (clazz.equals(Integer.TYPE)) {
                            this.out.print(Arrays.toString((int[])object));
                            continue;
                        }
                        if (clazz.equals(Long.TYPE)) {
                            this.out.print(Arrays.toString((long[])object));
                            continue;
                        }
                        if (clazz.equals(Short.TYPE)) {
                            this.out.print(Arrays.toString((short[])object));
                            continue;
                        }
                        this.out.print(Arrays.toString((Object[])object));
                        continue;
                    }
                    this.out.print(object);
                }
                this.out.println();
                if (throwable != null) {
                    throwable.printStackTrace(this.out);
                }
            }
        }
    }

    protected String getTimestamp() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return simpleDateFormat.format(new Date());
    }

    public final void error(Throwable throwable, Object ... objectArray) {
        this.emit(LogLevel.ERROR, throwable, objectArray);
    }

    public final void warn(Throwable throwable, Object ... objectArray) {
        this.emit(LogLevel.WARNING, throwable, objectArray);
    }

    public final void info(Throwable throwable, Object ... objectArray) {
        this.emit(LogLevel.INFO, throwable, objectArray);
    }

    public final void debug(Throwable throwable, Object ... objectArray) {
        this.emit(LogLevel.DEBUG, throwable, objectArray);
    }

    public final void error(Object ... objectArray) {
        this.emit(LogLevel.ERROR, null, objectArray);
    }

    public final void warn(Object ... objectArray) {
        this.emit(LogLevel.WARNING, null, objectArray);
    }

    public final void info(Object ... objectArray) {
        this.emit(LogLevel.INFO, null, objectArray);
    }

    public final void debug(Object ... objectArray) {
        this.emit(LogLevel.DEBUG, null, objectArray);
    }

    public static enum LogLevel {
        ERROR,
        WARNING,
        INFO,
        DEBUG;

    }
}

