/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeMap;

public class Histogram<K extends Comparable>
extends TreeMap<K, Bin> {
    private String binLabel = "BIN";
    private String valueLabel = "VALUE";
    private Double mean;

    public Histogram() {
    }

    public Histogram(String string, String string2) {
        this.binLabel = string;
        this.valueLabel = string2;
    }

    public Histogram(Comparator<K> comparator) {
        super(comparator);
    }

    public Histogram(String string, String string2, Comparator<K> comparator) {
        this(comparator);
        this.binLabel = string;
        this.valueLabel = string2;
    }

    public Histogram(Histogram<K> histogram) {
        super(histogram);
        this.binLabel = histogram.binLabel;
        this.valueLabel = histogram.valueLabel;
        this.mean = histogram.mean;
    }

    public void prefillBins(K ... KArray) {
        for (K k : KArray) {
            this.put(k, new Bin(this, (Comparable)k));
        }
    }

    public void increment(K k) {
        this.increment(k, 1.0);
    }

    public void increment(K k, double d) {
        Bin bin = (Bin)this.get(k);
        if (bin == null) {
            bin = new Bin(this, (Comparable)k);
            this.put(k, bin);
        }
        bin.value += d;
        this.mean = null;
    }

    public String getBinLabel() {
        return this.binLabel;
    }

    public void setBinLabel(String string) {
        this.binLabel = string;
    }

    public String getValueLabel() {
        return this.valueLabel;
    }

    public void setValueLabel(String string) {
        this.valueLabel = string;
    }

    @Override
    public boolean equals(Object object) {
        return object != null && object instanceof Histogram && ((Histogram)object).binLabel.equals(this.binLabel) && ((Histogram)object).valueLabel.equals(this.valueLabel) && super.equals(object);
    }

    public double getMean() {
        if (this.mean == null) {
            this.mean = this.getSum() / this.getCount();
        }
        return this.mean;
    }

    public double getSum() {
        double d = 0.0;
        for (Bin bin : this.values()) {
            d += bin.getValue() * bin.getIdValue();
        }
        return d;
    }

    public double getSumOfValues() {
        double d = 0.0;
        for (Bin bin : this.values()) {
            d += bin.getValue();
        }
        return d;
    }

    public double getStandardDeviation() {
        double d = this.getMean();
        double d2 = 0.0;
        double d3 = 0.0;
        for (Bin bin : this.values()) {
            double d4 = bin.getValue();
            double d5 = bin.getIdValue();
            d2 += d4;
            d3 += d4 * Math.pow(d5 - d, 2.0);
        }
        return Math.sqrt(d3 / (d2 - 1.0));
    }

    public double getMeanBinSize() {
        return this.getSumOfValues() / (double)this.size();
    }

    public double getMedianBinSize() {
        if (this.size() == 0) {
            return 0.0;
        }
        ArrayList<Double> arrayList = new ArrayList<Double>();
        for (Bin bin : this.values()) {
            arrayList.add(bin.getValue());
        }
        Collections.sort(arrayList);
        int n = arrayList.size() / 2;
        double d = (Double)arrayList.get(n);
        if (arrayList.size() % 2 == 0) {
            d = (d + (Double)arrayList.get(n - 1)) / 2.0;
        }
        return d;
    }

    public double getStandardDeviationBinSize(double d) {
        double d2 = 0.0;
        for (Bin bin : this.values()) {
            d2 += Math.pow(bin.getValue() - d, 2.0);
        }
        return Math.sqrt(d2 / (double)Math.max(1, this.values().size() - 1));
    }

    public double getPercentile(double d) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("Cannot query percentiles of 0 or below");
        }
        if (d >= 1.0) {
            throw new IllegalArgumentException("Cannot query percentiles of 1 or above");
        }
        double d2 = this.getCount();
        double d3 = 0.0;
        for (Bin bin : this.values()) {
            if (!((d3 += bin.getValue()) / d2 >= d)) continue;
            return bin.getIdValue();
        }
        throw new IllegalStateException("Could not find percentile: " + d);
    }

    public double getCumulativeProbability(double d) {
        double d2 = 0.0;
        double d3 = 0.0;
        for (Bin bin : this.values()) {
            double d4 = bin.getIdValue();
            if (d4 <= d) {
                d2 += bin.getValue();
            }
            d3 += bin.getValue();
        }
        return d2 / d3;
    }

    public double getMedian() {
        double d;
        double d2;
        double d3 = 0.0;
        double d4 = this.getCount();
        if (d4 == 0.0) {
            return 0.0;
        }
        if (d4 == 1.0) {
            return ((Bin)this.values().iterator().next()).getIdValue();
        }
        if (d4 % 2.0 == 0.0) {
            d2 = d4 / 2.0;
            d = d2 + 1.0;
        } else {
            d = d2 = Math.ceil(d4 / 2.0);
        }
        Double d5 = null;
        Double d6 = null;
        for (Bin bin : this.values()) {
            d3 += bin.getValue();
            if (d5 == null && d3 >= d2) {
                d5 = bin.getIdValue();
            }
            if (d6 == null && d3 >= d) {
                d6 = bin.getIdValue();
            }
            if (d5 == null || d6 == null) continue;
            break;
        }
        return (d5 + d6) / 2.0;
    }

    public double getMedianAbsoluteDeviation() {
        double d = this.getMedian();
        Histogram<Double> histogram = new Histogram<Double>();
        for (Bin bin : this.values()) {
            double d2 = Math.abs(bin.getIdValue() - d);
            histogram.increment(d2, bin.getValue());
        }
        return histogram.getMedian();
    }

    public double estimateSdViaMad() {
        return 1.4826 * this.getMedianAbsoluteDeviation();
    }

    public double getMode() {
        return this.getModeBin().getIdValue();
    }

    private Bin getModeBin() {
        Bin bin = null;
        for (Bin bin2 : this.values()) {
            if (bin != null && !(bin.value < bin2.value)) continue;
            bin = bin2;
        }
        return bin;
    }

    public double getMin() {
        return ((Bin)this.firstEntry().getValue()).getIdValue();
    }

    public double getMax() {
        return ((Bin)this.lastEntry().getValue()).getIdValue();
    }

    public double getCount() {
        double d = 0.0;
        for (Bin bin : this.values()) {
            d += bin.value;
        }
        return d;
    }

    public double getGeometricMean() {
        double d = 0.0;
        double d2 = 0.0;
        for (Bin bin : this.values()) {
            d += bin.value * Math.log(bin.getIdValue());
            d2 += bin.value;
        }
        return Math.exp(d / d2);
    }

    public void trimByTailLimit(int n) {
        if (this.isEmpty()) {
            return;
        }
        Bin bin = this.getModeBin();
        double d = bin.getIdValue();
        double d2 = bin.getValue();
        double d3 = d2 / (double)n;
        Object[] objectArray = null;
        ArrayList arrayList = new ArrayList();
        Object[] objectArray2 = this.values().iterator();
        while (objectArray2.hasNext()) {
            Object[] objectArray3 = (Object[])objectArray2.next();
            double d4 = ((Number)objectArray3.getId()).doubleValue();
            if (d4 <= d) {
                arrayList.add(objectArray3.getId());
            } else {
                if (objectArray != null && ((Number)objectArray.getId()).doubleValue() != d4 - 1.0 || objectArray3.getValue() < d3) break;
                arrayList.add(objectArray3.getId());
            }
            objectArray = objectArray3;
        }
        for (Object object : objectArray2 = this.keySet().toArray()) {
            if (arrayList.contains((Comparable)object)) continue;
            this.remove(object);
        }
    }

    public void trimByWidth(int n) {
        Iterator iterator = this.descendingKeySet().iterator();
        while (iterator.hasNext() && ((Number)iterator.next()).doubleValue() > (double)n) {
            iterator.remove();
        }
    }

    public Histogram<K> divideByHistogram(Histogram<K> histogram) throws IllegalArgumentException {
        Histogram<Comparable> histogram2 = new Histogram<Comparable>();
        if (!this.keySet().equals(histogram.keySet())) {
            throw new IllegalArgumentException("Attempting to divide Histograms with non-identical bins");
        }
        for (Comparable comparable : this.keySet()) {
            Bin bin = (Bin)this.get(comparable);
            Bin bin2 = (Bin)histogram.get(comparable);
            histogram2.increment(comparable, bin.getValue() / bin2.getValue());
        }
        return histogram2;
    }

    public void addHistogram(Histogram<K> histogram) {
        for (Comparable comparable : histogram.keySet()) {
            this.increment(comparable, ((Bin)histogram.get(comparable)).getValue());
        }
    }

    public static class Bin {
        private final K id;
        private double value = 0.0;
        final /* synthetic */ Histogram this$0;

        private Bin(K k) {
            this.this$0 = var1_1;
            this.id = k;
        }

        public K getId() {
            return this.id;
        }

        public double getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Bin bin = (Bin)object;
            if (Double.compare(bin.value, this.value) != 0) {
                return false;
            }
            return this.id.equals(bin.id);
        }

        public int hashCode() {
            int n = this.id.hashCode();
            long l = this.value != 0.0 ? Double.doubleToLongBits(this.value) : 0L;
            n = 31 * n + (int)(l ^ l >>> 32);
            return n;
        }

        public double getIdValue() {
            if (this.id instanceof Number) {
                return ((Number)this.id).doubleValue();
            }
            throw new UnsupportedOperationException("getIdValue only supported for Histogram<? extends Number>");
        }
    }
}

