/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.sam;

import java.util.NoSuchElementException;
import net.sf.picard.PicardException;
import net.sf.picard.filter.FilteringIterator;
import net.sf.picard.filter.SamRecordFilter;
import net.sf.picard.sam.HitsForInsert;
import net.sf.picard.sam.PrimaryAlignmentSelectionStrategy;
import net.sf.picard.util.PeekableIterator;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMRecordQueryNameComparator;
import net.sf.samtools.SAMTag;
import net.sf.samtools.SAMUtils;
import net.sf.samtools.util.CloseableIterator;

class MultiHitAlignedReadIterator
implements CloseableIterator<HitsForInsert> {
    private final PeekableIterator<SAMRecord> peekIterator;
    private final SAMRecordQueryNameComparator queryNameComparator = new SAMRecordQueryNameComparator();
    private final PrimaryAlignmentSelectionStrategy primaryAlignmentSelectionStrategy;
    private HitsForInsert theNext = null;

    MultiHitAlignedReadIterator(CloseableIterator<SAMRecord> closeableIterator, PrimaryAlignmentSelectionStrategy primaryAlignmentSelectionStrategy) {
        this.primaryAlignmentSelectionStrategy = primaryAlignmentSelectionStrategy;
        this.peekIterator = new PeekableIterator<SAMRecord>(new FilteringIterator(closeableIterator, new SamRecordFilter(){

            @Override
            public boolean filterOut(SAMRecord sAMRecord) {
                return sAMRecord.getReadUnmappedFlag() || SAMUtils.cigarMapsNoBasesToRef(sAMRecord.getCigar());
            }

            @Override
            public boolean filterOut(SAMRecord sAMRecord, SAMRecord sAMRecord2) {
                return !(!sAMRecord.getReadUnmappedFlag() && !SAMUtils.cigarMapsNoBasesToRef(sAMRecord.getCigar()) || !sAMRecord2.getReadUnmappedFlag() && !SAMUtils.cigarMapsNoBasesToRef(sAMRecord2.getCigar()));
            }
        }));
        this.advance();
    }

    @Override
    public void close() {
        this.peekIterator.close();
    }

    @Override
    public boolean hasNext() {
        return this.theNext != null;
    }

    @Override
    public HitsForInsert next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        HitsForInsert hitsForInsert = this.theNext;
        this.advance();
        return hitsForInsert;
    }

    private void advance() {
        while (this.peekIterator.hasNext()) {
            this.theNext = this.nextMaybeEmpty();
            if (this.theNext.numHits() <= 0) continue;
            return;
        }
        this.theNext = null;
    }

    private HitsForInsert nextMaybeEmpty() {
        if (!this.peekIterator.hasNext()) {
            throw new IllegalStateException();
        }
        String string = this.peekIterator.peek().getReadName();
        HitsForInsert hitsForInsert = new HitsForInsert();
        Boolean bl = null;
        do {
            SAMRecord sAMRecord = this.peekIterator.next();
            if (this.peekIterator.hasNext() && this.queryNameComparator.fileOrderCompare(sAMRecord, this.peekIterator.peek()) > 0) {
                throw new IllegalStateException("Underlying iterator is not queryname sorted: " + sAMRecord + " > " + this.peekIterator.peek());
            }
            if (bl == null) {
                bl = sAMRecord.getReadPairedFlag();
            } else if (bl.booleanValue() != sAMRecord.getReadPairedFlag()) {
                throw new PicardException("Got a mix of paired and unpaired alignments for read " + string);
            }
            if (!sAMRecord.getReadPairedFlag() || sAMRecord.getFirstOfPairFlag()) {
                if (sAMRecord.getSupplementaryAlignmentFlag()) {
                    hitsForInsert.addSupplementalFirstOfPairOrFragment(sAMRecord);
                    continue;
                }
                hitsForInsert.addFirstOfPairOrFragment(sAMRecord);
                continue;
            }
            if (sAMRecord.getSecondOfPairFlag()) {
                if (sAMRecord.getSupplementaryAlignmentFlag()) {
                    hitsForInsert.addSupplementalSecondOfPair(sAMRecord);
                    continue;
                }
                hitsForInsert.addSecondOfPair(sAMRecord);
                continue;
            }
            throw new PicardException("Read is marked as pair but neither first or second: " + string);
        } while (this.peekIterator.hasNext() && this.peekIterator.peek().getReadName().equals(string));
        if (hitsForInsert.getSupplementalSecondOfPair().size() > 0 && hitsForInsert.getSupplementalSecondOfPair().size() != hitsForInsert.getSupplementalFirstOfPairOrFragment().size()) {
            throw new PicardException("Number of supplemental second of pairs do not equal the number of supplemental first of pairs");
        }
        if (hitsForInsert.numHits() <= 1) {
            if (hitsForInsert.getFirstOfPair(0) != null) {
                hitsForInsert.getFirstOfPair(0).setAttribute(SAMTag.HI.name(), null);
                hitsForInsert.getFirstOfPair(0).setNotPrimaryAlignmentFlag(false);
            }
            if (hitsForInsert.getSecondOfPair(0) != null) {
                hitsForInsert.getSecondOfPair(0).setAttribute(SAMTag.HI.name(), null);
                hitsForInsert.getSecondOfPair(0).setNotPrimaryAlignmentFlag(false);
            }
        } else {
            this.primaryAlignmentSelectionStrategy.pickPrimaryAlignment(hitsForInsert);
        }
        return hitsForInsert;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

