/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.sam;

import java.util.Comparator;
import net.sf.picard.util.PeekableIterator;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.util.CloseableIterator;

class ComparableSamRecordIterator
extends PeekableIterator<SAMRecord>
implements Comparable<ComparableSamRecordIterator> {
    private final Comparator<SAMRecord> comparator;
    private final SAMFileReader reader;

    public ComparableSamRecordIterator(SAMFileReader sAMFileReader, CloseableIterator<SAMRecord> closeableIterator, Comparator<SAMRecord> comparator) {
        super(closeableIterator);
        this.reader = sAMFileReader;
        this.comparator = comparator;
    }

    public SAMFileReader getReader() {
        return this.reader;
    }

    @Override
    public int compareTo(ComparableSamRecordIterator comparableSamRecordIterator) {
        if (this.comparator.getClass() != comparableSamRecordIterator.comparator.getClass()) {
            throw new IllegalStateException("Attempt to compare two ComparableSAMRecordIterators that have different orderings internally");
        }
        SAMRecord sAMRecord = (SAMRecord)this.peek();
        SAMRecord sAMRecord2 = (SAMRecord)comparableSamRecordIterator.peek();
        return this.comparator.compare(sAMRecord, sAMRecord2);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        return this.compareTo((ComparableSamRecordIterator)object) == 0;
    }

    public int hashCode() {
        throw new UnsupportedOperationException("ComparableSamRecordIterator should not be hashed because it can change value");
    }
}

