/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.sam;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.picard.cmdline.CommandLineProgram;
import net.sf.picard.cmdline.Option;
import net.sf.picard.util.Log;
import net.sf.samtools.util.StringUtil;

public abstract class AbstractDuplicateFindingAlgorithm
extends CommandLineProgram {
    private static Log LOG = Log.getInstance(AbstractDuplicateFindingAlgorithm.class);
    private static final String DEFAULT_READ_NAME_REGEX = "[a-zA-Z0-9]+:[0-9]:([0-9]+):([0-9]+):([0-9]+).*".intern();
    @Option(doc="Regular expression that can be used to parse read names in the incoming SAM file. Read names are parsed to extract three variables: tile/region, x coordinate and y coordinate. These values are used to estimate the rate of optical duplication in order to give a more accurate estimated library size. The regular expression should contain three capture groups for the three variables, in order. It must match the entire read name. Note that if the default regex is specified, a regex match is not actually done, but instead the read name  is split on colon character and the 2nd, 3rd and 4th elements are assumed to be tile, x and y values.")
    public String READ_NAME_REGEX = DEFAULT_READ_NAME_REGEX;
    @Option(doc="The maximum offset between two duplicte clusters in order to consider them optical duplicates. This should usually be set to some fairly small number (e.g. 5-10 pixels) unless using later versions of the Illumina pipeline that multiply pixel values by 10, in which case 50-100 is more normal.")
    public int OPTICAL_DUPLICATE_PIXEL_DISTANCE = 100;
    private Pattern READ_NAME_PATTERN = null;
    private boolean warnedAboutRegexNotMatching = false;
    private final String[] tmpLocationFields = new String[10];

    boolean addLocationInformation(String string, PhysicalLocation physicalLocation) {
        Matcher matcher;
        if (this.READ_NAME_REGEX == DEFAULT_READ_NAME_REGEX) {
            int n = StringUtil.split(string, this.tmpLocationFields, ':');
            if (n < 5) {
                if (!this.warnedAboutRegexNotMatching) {
                    LOG.warn(String.format("Default READ_NAME_REGEX '%s' did not match read name '%s'.  You may need to specify a READ_NAME_REGEX in order to correctly identify optical duplicates.  Note that this message will not be emitted again even if other read names do not match the regex.", this.READ_NAME_REGEX, string));
                    this.warnedAboutRegexNotMatching = true;
                }
                return false;
            }
            physicalLocation.setTile((short)this.rapidParseInt(this.tmpLocationFields[2]));
            physicalLocation.setX((short)this.rapidParseInt(this.tmpLocationFields[3]));
            physicalLocation.setY((short)this.rapidParseInt(this.tmpLocationFields[4]));
            return true;
        }
        if (this.READ_NAME_REGEX == null) {
            return false;
        }
        if (this.READ_NAME_PATTERN == null) {
            this.READ_NAME_PATTERN = Pattern.compile(this.READ_NAME_REGEX);
        }
        if ((matcher = this.READ_NAME_PATTERN.matcher(string)).matches()) {
            physicalLocation.setTile((short)Integer.parseInt(matcher.group(1)));
            physicalLocation.setX((short)Integer.parseInt(matcher.group(2)));
            physicalLocation.setY((short)Integer.parseInt(matcher.group(3)));
            return true;
        }
        if (!this.warnedAboutRegexNotMatching) {
            LOG.warn(String.format("READ_NAME_REGEX '%s' did not match read name '%s'.  Your regex may not be correct.  Note that this message will not be emitted again even if other read names do not match the regex.", this.READ_NAME_REGEX, string));
            this.warnedAboutRegexNotMatching = true;
        }
        return false;
    }

    private final int rapidParseInt(String string) {
        int n = string.length();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (!Character.isDigit(c)) continue;
            n2 = n2 * 10 + (c - 48);
        }
        return n2;
    }

    boolean[] findOpticalDuplicates(List<? extends PhysicalLocation> list, int n) {
        int n2 = list.size();
        boolean[] blArray = new boolean[n2];
        Collections.sort(list, new Comparator<PhysicalLocation>(){

            @Override
            public int compare(PhysicalLocation physicalLocation, PhysicalLocation physicalLocation2) {
                int n = physicalLocation.getReadGroup() - physicalLocation2.getReadGroup();
                if (n == 0) {
                    n = physicalLocation.getTile() - physicalLocation2.getTile();
                }
                if (n == 0) {
                    n = physicalLocation.getX() - physicalLocation2.getX();
                }
                if (n == 0) {
                    n = physicalLocation.getY() - physicalLocation2.getY();
                }
                return n;
            }
        });
        block0: for (int i = 0; i < n2; ++i) {
            PhysicalLocation physicalLocation = list.get(i);
            if (physicalLocation.getTile() < 0) continue;
            for (int j = i + 1; j < n2; ++j) {
                PhysicalLocation physicalLocation2 = list.get(j);
                if (physicalLocation.getReadGroup() != physicalLocation2.getReadGroup() || physicalLocation.getTile() != physicalLocation2.getTile() || physicalLocation2.getX() > physicalLocation.getX() + n) continue block0;
                if (Math.abs(physicalLocation.getY() - physicalLocation2.getY()) > n) continue;
                blArray[j] = true;
            }
        }
        return blArray;
    }

    public static interface PhysicalLocation {
        public short getReadGroup();

        public void setReadGroup(short var1);

        public short getTile();

        public void setTile(short var1);

        public short getX();

        public void setX(short var1);

        public short getY();

        public void setY(short var1);
    }
}

