/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.reference;

import java.io.File;
import net.sf.picard.PicardException;
import net.sf.picard.reference.ReferenceSequence;
import net.sf.picard.reference.ReferenceSequenceFile;
import net.sf.picard.reference.ReferenceSequenceFileFactory;
import net.sf.samtools.SAMSequenceDictionary;

public class ReferenceSequenceFileWalker {
    private final ReferenceSequenceFile referenceSequenceFile;
    private ReferenceSequence referenceSequence = null;

    public ReferenceSequenceFileWalker(ReferenceSequenceFile referenceSequenceFile) {
        this.referenceSequenceFile = referenceSequenceFile;
    }

    public ReferenceSequenceFileWalker(File file) {
        this(ReferenceSequenceFileFactory.getReferenceSequenceFile(file));
    }

    public ReferenceSequence get(int n, String string, int n2) {
        this.get(n);
        if (!this.referenceSequence.getName().equals(string)) {
            throw new PicardException("Sequence name mismatch at sequence index (" + this.referenceSequence.getContigIndex() + ", " + this.referenceSequence.getName() + ") != " + string);
        }
        if (this.referenceSequence.getBases().length != n2) {
            throw new PicardException("Sequence length mismatch for (" + n + ", " + string + ").  expected " + n2 + " but found " + this.referenceSequence.getBases().length);
        }
        return this.referenceSequence;
    }

    public ReferenceSequence get(int n) {
        if (this.referenceSequence != null && this.referenceSequence.getContigIndex() == n) {
            return this.referenceSequence;
        }
        if (this.referenceSequence != null && this.referenceSequence.getContigIndex() > n) {
            throw new PicardException("Requesting earlier reference sequence: " + n + " < " + this.referenceSequence.getContigIndex());
        }
        this.referenceSequence = null;
        this.referenceSequence = this.referenceSequenceFile.nextSequence();
        while (this.referenceSequence != null && this.referenceSequence.getContigIndex() < n) {
            this.referenceSequence = this.referenceSequenceFile.nextSequence();
        }
        if (this.referenceSequence == null || this.referenceSequence.getContigIndex() != n) {
            throw new PicardException("Reference sequence (" + n + ") not found in " + this.referenceSequenceFile.toString());
        }
        return this.referenceSequence;
    }

    public SAMSequenceDictionary getSequenceDictionary() {
        return this.referenceSequenceFile.getSequenceDictionary();
    }
}

