/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.reference;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.MatchResult;
import net.sf.picard.PicardException;
import net.sf.picard.io.IoUtil;
import net.sf.picard.reference.FastaSequenceIndexEntry;
import net.sf.samtools.SAMSequenceRecord;

public class FastaSequenceIndex
implements Iterable<FastaSequenceIndexEntry> {
    private final Map<String, FastaSequenceIndexEntry> sequenceEntries = new LinkedHashMap<String, FastaSequenceIndexEntry>();

    public FastaSequenceIndex(File file) {
        IoUtil.assertFileIsReadable(file);
        this.parseIndexFile(file);
    }

    protected FastaSequenceIndex() {
    }

    protected void add(FastaSequenceIndexEntry fastaSequenceIndexEntry) {
        FastaSequenceIndexEntry fastaSequenceIndexEntry2 = this.sequenceEntries.put(fastaSequenceIndexEntry.getContig(), fastaSequenceIndexEntry);
        if (fastaSequenceIndexEntry2 != null) {
            throw new PicardException("Contig '" + fastaSequenceIndexEntry.getContig() + "' already exists in fasta index.");
        }
    }

    protected void rename(FastaSequenceIndexEntry fastaSequenceIndexEntry, String string) {
        this.sequenceEntries.remove(fastaSequenceIndexEntry.getContig());
        fastaSequenceIndexEntry.setContig(string);
        this.add(fastaSequenceIndexEntry);
    }

    public boolean equals(Object object) {
        if (!(object instanceof FastaSequenceIndex)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        FastaSequenceIndex fastaSequenceIndex = (FastaSequenceIndex)object;
        if (this.size() != fastaSequenceIndex.size()) {
            return false;
        }
        Iterator<FastaSequenceIndexEntry> iterator = this.iterator();
        Iterator<FastaSequenceIndexEntry> iterator2 = fastaSequenceIndex.iterator();
        while (iterator.hasNext()) {
            if (!iterator2.hasNext()) {
                return false;
            }
            if (iterator.next().equals(iterator2.next())) continue;
            return false;
        }
        return true;
    }

    private void parseIndexFile(File file) {
        try {
            Scanner scanner = new Scanner(file);
            int n = 0;
            while (scanner.hasNext()) {
                String string = scanner.findInLine("(.+)\\t+(\\d+)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)");
                if (string == null) {
                    throw new PicardException("Found invalid line in index file:" + scanner.nextLine());
                }
                MatchResult matchResult = scanner.match();
                if (matchResult.groupCount() != 5) {
                    throw new PicardException("Found invalid line in index file:" + scanner.nextLine());
                }
                scanner.nextLine();
                String string2 = matchResult.group(1);
                long l = Long.valueOf(matchResult.group(2));
                long l2 = Long.valueOf(matchResult.group(3));
                int n2 = Integer.valueOf(matchResult.group(4));
                int n3 = Integer.valueOf(matchResult.group(5));
                string2 = SAMSequenceRecord.truncateSequenceName(string2);
                this.add(new FastaSequenceIndexEntry(string2, l2, l, n2, n3, n++));
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new PicardException("Fasta index file should be found but is not: " + file, fileNotFoundException);
        }
    }

    public boolean hasIndexEntry(String string) {
        return this.sequenceEntries.containsKey(string);
    }

    public FastaSequenceIndexEntry getIndexEntry(String string) {
        if (!this.hasIndexEntry(string)) {
            throw new PicardException("Unable to find entry for contig: " + string);
        }
        return this.sequenceEntries.get(string);
    }

    @Override
    public Iterator<FastaSequenceIndexEntry> iterator() {
        return this.sequenceEntries.values().iterator();
    }

    public int size() {
        return this.sequenceEntries.size();
    }
}

