/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.pedigree;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.regex.Pattern;
import net.sf.picard.io.IoUtil;
import net.sf.picard.pedigree.PedTrio;
import net.sf.picard.pedigree.Sex;
import net.sf.picard.util.Log;
import net.sf.samtools.util.RuntimeIOException;

public class PedFile
extends TreeMap<String, PedTrio> {
    private static final Log log = Log.getInstance(PedFile.class);
    static final Pattern WHITESPACE = Pattern.compile("\\s+");

    public void add(PedTrio pedTrio) {
        this.put(pedTrio.getIndividualId(), pedTrio);
    }

    public void write(File file) {
        IoUtil.assertFileIsWritable(file);
        BufferedWriter bufferedWriter = IoUtil.openFileForBufferedWriting(file);
        try {
            for (PedTrio pedTrio : this.values()) {
                bufferedWriter.write(pedTrio.getFamilyId());
                bufferedWriter.write("\t");
                bufferedWriter.write(pedTrio.getIndividualId());
                bufferedWriter.write("\t");
                bufferedWriter.write(pedTrio.getPaternalId());
                bufferedWriter.write("\t");
                bufferedWriter.write(pedTrio.getMaternalId());
                bufferedWriter.write("\t");
                bufferedWriter.write(String.valueOf(pedTrio.getSex().toCode()));
                bufferedWriter.write("\t");
                bufferedWriter.write(pedTrio.getPhenotype().toString());
                bufferedWriter.newLine();
            }
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            throw new RuntimeIOException("IOException while writing to file " + file.getAbsolutePath(), iOException);
        }
    }

    public static PedFile fromFile(File file) {
        PedFile pedFile = new PedFile();
        IoUtil.assertFileIsReadable(file);
        for (String string : IoUtil.readLines(file)) {
            String[] stringArray = WHITESPACE.split(string);
            if (stringArray.length != 6) {
                log.error("Ped file line contained invalid number of fields, skipping: " + string);
                continue;
            }
            PedTrio pedTrio = new PedTrio(stringArray[0], stringArray[1], stringArray[2], stringArray[3], Sex.fromCode(Integer.parseInt(stringArray[4])), stringArray[5].contains(".") ? Double.parseDouble(stringArray[5]) : (double)Integer.parseInt(stringArray[5]));
            pedFile.add(pedTrio);
        }
        return pedFile;
    }

    public PedFile removeIncompleteTrios() {
        Iterator iterator = this.entrySet().iterator();
        while (iterator.hasNext()) {
            if (((PedTrio)iterator.next().getValue()).hasBothParents()) continue;
            iterator.remove();
        }
        return this;
    }
}

