/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.metrics;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import net.sf.picard.PicardException;
import net.sf.picard.metrics.Header;
import net.sf.picard.metrics.MetricBase;
import net.sf.picard.util.FormatUtil;
import net.sf.picard.util.Histogram;
import net.sf.samtools.util.StringUtil;

public class MetricsFile<BEAN extends MetricBase, HKEY extends Comparable> {
    public static final String MAJOR_HEADER_PREFIX = "## ";
    public static final String MINOR_HEADER_PREFIX = "# ";
    public static final String SEPARATOR = "\t";
    public static final String HISTO_HEADER = "## HISTOGRAM\t";
    public static final String METRIC_HEADER = "## METRICS CLASS\t";
    private final Set<String> columnLabels = new HashSet<String>();
    private final List<Header> headers = new ArrayList<Header>();
    private final List<BEAN> metrics = new ArrayList<BEAN>();
    private final List<Histogram<HKEY>> histograms = new ArrayList<Histogram<HKEY>>();

    public void addHeader(Header header) {
        this.headers.add(header);
    }

    public List<Header> getHeaders() {
        return Collections.unmodifiableList(this.headers);
    }

    public void addMetric(BEAN BEAN) {
        this.metrics.add(BEAN);
    }

    public List<BEAN> getMetrics() {
        return Collections.unmodifiableList(this.metrics);
    }

    public Set<String> getMetricsColumnLabels() {
        return Collections.unmodifiableSet(this.columnLabels);
    }

    public Histogram<HKEY> getHistogram() {
        if (this.histograms.size() > 0) {
            return this.histograms.get(0);
        }
        return null;
    }

    public void setHistogram(Histogram<HKEY> histogram) {
        if (this.histograms.isEmpty()) {
            if (histogram != null) {
                this.histograms.add(histogram);
            }
        } else {
            this.histograms.set(0, histogram);
        }
    }

    public void addHistogram(Histogram<HKEY> histogram) {
        this.histograms.add(histogram);
    }

    public List<Histogram<HKEY>> getAllHistograms() {
        return Collections.unmodifiableList(this.histograms);
    }

    public int getNumHistograms() {
        return this.histograms.size();
    }

    public List<Header> getHeaders(Class<? extends Header> clazz) {
        ArrayList<Header> arrayList = new ArrayList<Header>();
        for (Header header : this.headers) {
            if (!header.getClass().equals(clazz)) continue;
            arrayList.add(header);
        }
        return arrayList;
    }

    public void write(File file) {
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(file);
            this.write(fileWriter);
        }
        catch (IOException iOException) {
            throw new PicardException("Could not write metrics to file: " + file.getAbsolutePath(), iOException);
        }
        finally {
            if (fileWriter != null) {
                try {
                    fileWriter.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void write(Writer writer) {
        try {
            FormatUtil formatUtil = new FormatUtil();
            BufferedWriter bufferedWriter = new BufferedWriter(writer);
            this.printHeaders(bufferedWriter);
            bufferedWriter.newLine();
            this.printBeanMetrics(bufferedWriter, formatUtil);
            bufferedWriter.newLine();
            this.printHistogram(bufferedWriter, formatUtil);
            bufferedWriter.newLine();
            bufferedWriter.flush();
        }
        catch (IOException iOException) {
            throw new PicardException("Could not write metrics file.", iOException);
        }
    }

    private void printHeaders(BufferedWriter bufferedWriter) throws IOException {
        for (Header header : this.headers) {
            bufferedWriter.append(MAJOR_HEADER_PREFIX);
            bufferedWriter.append(header.getClass().getName());
            bufferedWriter.newLine();
            bufferedWriter.append(MINOR_HEADER_PREFIX);
            bufferedWriter.append(header.toString());
            bufferedWriter.newLine();
        }
    }

    private void printBeanMetrics(BufferedWriter bufferedWriter, FormatUtil formatUtil) throws IOException {
        if (this.metrics.isEmpty()) {
            return;
        }
        bufferedWriter.append(METRIC_HEADER + this.getBeanType().getName());
        bufferedWriter.newLine();
        Field[] fieldArray = this.getBeanType().getFields();
        int n = fieldArray.length;
        for (int i = 0; i < n; ++i) {
            bufferedWriter.append(fieldArray[i].getName());
            if (i < n - 1) {
                bufferedWriter.append(SEPARATOR);
                continue;
            }
            bufferedWriter.newLine();
        }
        for (MetricBase metricBase : this.metrics) {
            for (int i = 0; i < n; ++i) {
                try {
                    Object object = fieldArray[i].get(metricBase);
                    bufferedWriter.append(StringUtil.assertCharactersNotInString(formatUtil.format(object), '\t', '\n'));
                    if (i < n - 1) {
                        bufferedWriter.append(SEPARATOR);
                        continue;
                    }
                    bufferedWriter.newLine();
                    continue;
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new PicardException("Could not read property " + fieldArray[i].getName() + " from class of type " + metricBase.getClass());
                }
            }
        }
        bufferedWriter.flush();
    }

    private void printHistogram(BufferedWriter bufferedWriter, FormatUtil formatUtil) throws IOException {
        ArrayList<Histogram<HKEY>> arrayList = new ArrayList<Histogram<HKEY>>();
        for (Histogram<HKEY> object2 : this.histograms) {
            if (object2.isEmpty()) continue;
            arrayList.add(object2);
        }
        if (arrayList.isEmpty()) {
            return;
        }
        TreeSet treeSet = new TreeSet(((Histogram)arrayList.get(0)).comparator());
        for (Histogram histogram : arrayList) {
            if (histogram == null) continue;
            treeSet.addAll(histogram.keySet());
        }
        bufferedWriter.append(HISTO_HEADER + ((Comparable)((Histogram)arrayList.get(0)).keySet().iterator().next()).getClass().getName());
        bufferedWriter.newLine();
        bufferedWriter.append(StringUtil.assertCharactersNotInString(((Histogram)arrayList.get(0)).getBinLabel(), '\t', '\n'));
        for (Histogram histogram : arrayList) {
            bufferedWriter.append(SEPARATOR);
            bufferedWriter.append(StringUtil.assertCharactersNotInString(histogram.getValueLabel(), '\t', '\n'));
        }
        bufferedWriter.newLine();
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            Comparable comparable = (Comparable)iterator.next();
            bufferedWriter.append(comparable.toString());
            for (Histogram histogram : arrayList) {
                Histogram.Bin bin = (Histogram.Bin)histogram.get(comparable);
                double d = bin == null ? 0.0 : bin.getValue();
                bufferedWriter.append(SEPARATOR);
                bufferedWriter.append(formatUtil.format(d));
            }
            bufferedWriter.newLine();
        }
    }

    private Class<?> getBeanType() {
        if (this.metrics == null || this.metrics.isEmpty()) {
            return null;
        }
        return ((MetricBase)this.metrics.get(0)).getClass();
    }

    public void read(Reader reader) {
        block30: {
            BufferedReader bufferedReader = new BufferedReader(reader);
            FormatUtil formatUtil = new FormatUtil();
            String string = null;
            try {
                String[] stringArray;
                Class<?> clazz;
                String string2;
                Header header = null;
                boolean bl = true;
                while ((string = bufferedReader.readLine()) != null && bl) {
                    if ("".equals(string = string.trim())) {
                        bl = false;
                        continue;
                    }
                    if (string.startsWith(MAJOR_HEADER_PREFIX)) {
                        if (header != null) {
                            throw new IllegalStateException("Consecutive header class lines encountered.");
                        }
                        string2 = string.substring(MAJOR_HEADER_PREFIX.length()).trim();
                        try {
                            header = (Header)this.loadClass(string2, true).newInstance();
                            continue;
                        }
                        catch (Exception exception) {
                            throw new PicardException("Error load and/or instantiating an instance of " + string2, exception);
                        }
                    }
                    if (string.startsWith(MINOR_HEADER_PREFIX)) {
                        if (header == null) {
                            throw new IllegalStateException("Header class must precede header value:" + string);
                        }
                        header.parse(string.substring(MINOR_HEADER_PREFIX.length()));
                        this.headers.add(header);
                        header = null;
                        continue;
                    }
                    throw new PicardException("Illegal state. Found following string in metrics file header: " + string);
                }
                while (string != null && !string.startsWith(MAJOR_HEADER_PREFIX)) {
                    string = bufferedReader.readLine();
                }
                if (string != null && (string = string.trim()).startsWith(METRIC_HEADER)) {
                    string2 = string.split(SEPARATOR)[1];
                    clazz = null;
                    try {
                        clazz = this.loadClass(string2, true);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new PicardException("Could not locate class with name " + string2, classNotFoundException);
                    }
                    stringArray = bufferedReader.readLine().split(SEPARATOR);
                    Collections.addAll(this.columnLabels, stringArray);
                    Field[] fieldArray = new Field[stringArray.length];
                    for (int i = 0; i < stringArray.length; ++i) {
                        try {
                            fieldArray[i] = clazz.getField(stringArray[i]);
                            continue;
                        }
                        catch (Exception exception) {
                            throw new PicardException("Could not get field with name " + stringArray[i] + " from class " + clazz.getName());
                        }
                    }
                    while ((string = bufferedReader.readLine()) != null && !"".equals(string.trim())) {
                        String[] stringArray2 = string.split(SEPARATOR, -1);
                        MetricBase metricBase = null;
                        try {
                            metricBase = (MetricBase)clazz.newInstance();
                        }
                        catch (Exception exception) {
                            throw new PicardException("Error instantiating a " + clazz.getName(), exception);
                        }
                        for (int i = 0; i < fieldArray.length; ++i) {
                            Object object = null;
                            if (stringArray2[i] != null && stringArray2[i].length() > 0) {
                                object = formatUtil.parseObject(stringArray2[i], fieldArray[i].getType());
                            }
                            try {
                                fieldArray[i].set(metricBase, object);
                                continue;
                            }
                            catch (Exception exception) {
                                throw new PicardException("Error setting field " + fieldArray[i].getName() + " on class of type " + clazz.getName(), exception);
                            }
                        }
                        this.metrics.add(metricBase);
                    }
                }
                while (string != null && !string.startsWith(MAJOR_HEADER_PREFIX)) {
                    string = bufferedReader.readLine();
                }
                if (string == null || !string.startsWith(HISTO_HEADER)) break block30;
                string2 = string.split(SEPARATOR)[1].trim();
                clazz = null;
                try {
                    clazz = this.loadClass(string2, true);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new PicardException("Could not load class with name " + string2);
                }
                stringArray = bufferedReader.readLine().split(SEPARATOR);
                for (int i = 1; i < stringArray.length; ++i) {
                    this.histograms.add(new Histogram(stringArray[0], stringArray[i]));
                }
                while ((string = bufferedReader.readLine()) != null && !"".equals(string)) {
                    String[] stringArray3 = string.trim().split(SEPARATOR);
                    Comparable comparable = (Comparable)formatUtil.parseObject(stringArray3[0], clazz);
                    for (int i = 1; i < stringArray3.length; ++i) {
                        double d = formatUtil.parseDouble(stringArray3[i]);
                        this.histograms.get(i - 1).increment(comparable, d);
                    }
                }
            }
            catch (IOException iOException) {
                throw new PicardException("Could not read metrics from reader.", iOException);
            }
        }
    }

    private Class<?> loadClass(String string, boolean bl) throws ClassNotFoundException {
        String[] stringArray = new String[]{"edu.mit.broad.picard.genotype.concordance", "edu.mit.broad.picard.genotype.fingerprint", "edu.mit.broad.picard.ic", "edu.mit.broad.picard.illumina", "edu.mit.broad.picard.jumping", "edu.mit.broad.picard.quality", "edu.mit.broad.picard.samplevalidation", "net.sf.picard.analysis", "net.sf.picard.analysis.directed", "net.sf.picard.sam", "net.sf.picard.metrics"};
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (bl) {
                for (String string2 : stringArray) {
                    try {
                        return this.loadClass(string2 + string.substring(string.lastIndexOf(".")), false);
                    }
                    catch (ClassNotFoundException classNotFoundException2) {
                        if (string.indexOf("$") <= -1) continue;
                        try {
                            return this.loadClass(string2 + "." + string.substring(string.lastIndexOf("$") + 1), false);
                        }
                        catch (ClassNotFoundException classNotFoundException3) {
                            // empty catch block
                        }
                    }
                }
            }
            throw classNotFoundException;
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        MetricsFile metricsFile = (MetricsFile)object;
        if (!this.areHeadersEqual(metricsFile)) {
            return false;
        }
        if (!this.areMetricsEqual(metricsFile)) {
            return false;
        }
        return this.areHistogramsEqual(metricsFile);
    }

    public boolean areHeadersEqual(MetricsFile metricsFile) {
        return this.headers.equals(metricsFile.headers);
    }

    public boolean areMetricsEqual(MetricsFile metricsFile) {
        return this.metrics.equals(metricsFile.metrics);
    }

    public boolean areHistogramsEqual(MetricsFile metricsFile) {
        return this.histograms.equals(metricsFile.histograms);
    }

    public int hashCode() {
        int n = this.headers.hashCode();
        n = 31 * n + this.metrics.hashCode();
        return n;
    }

    public static List<? extends MetricBase> readBeans(File file) {
        try {
            MetricsFile metricsFile = new MetricsFile();
            metricsFile.read(new FileReader(file));
            return metricsFile.getMetrics();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new PicardException(fileNotFoundException.getMessage(), fileNotFoundException);
        }
    }
}

