/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina.parser.readers;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Iterator;
import net.sf.picard.PicardException;
import net.sf.picard.illumina.parser.readers.BinaryFileIterator;
import net.sf.picard.io.IoUtil;
import net.sf.samtools.util.CloserUtil;

public class MMapBackedIteratorFactory {
    private static int BYTE_SIZE = 1;
    private static int INT_SIZE = 4;
    private static int FLOAT_SIZE = 4;

    public static BinaryFileIterator<Integer> getIntegerIterator(int n, File file) {
        MMapBackedIteratorFactory.checkFactoryVars(n, file);
        ByteBuffer byteBuffer = MMapBackedIteratorFactory.getBuffer(file);
        byte[] byArray = MMapBackedIteratorFactory.getHeader(byteBuffer, n);
        return new IntegerMMapIterator(byArray, file, byteBuffer);
    }

    public static BinaryFileIterator<Byte> getByteIterator(int n, File file) {
        MMapBackedIteratorFactory.checkFactoryVars(n, file);
        ByteBuffer byteBuffer = MMapBackedIteratorFactory.getBuffer(file);
        byte[] byArray = MMapBackedIteratorFactory.getHeader(byteBuffer, n);
        return new ByteMMapIterator(byArray, file, byteBuffer);
    }

    public static BinaryFileIterator<Float> getFloatIterator(int n, File file) {
        MMapBackedIteratorFactory.checkFactoryVars(n, file);
        ByteBuffer byteBuffer = MMapBackedIteratorFactory.getBuffer(file);
        byte[] byArray = MMapBackedIteratorFactory.getHeader(byteBuffer, n);
        return new FloatMMapIterator(byArray, file, byteBuffer);
    }

    public static BinaryFileIterator<ByteBuffer> getByteBufferIterator(int n, int n2, File file) {
        MMapBackedIteratorFactory.checkFactoryVars(n, file);
        ByteBuffer byteBuffer = MMapBackedIteratorFactory.getBuffer(file);
        byte[] byArray = MMapBackedIteratorFactory.getHeader(byteBuffer, n);
        return new ByteBufferMMapIterator(byArray, file, n2, byteBuffer);
    }

    private static void checkFactoryVars(int n, File file) {
        IoUtil.assertFileIsReadable(file);
        if (n < 0) {
            throw new PicardException("Header size cannot be negative.  HeaderSize(" + n + ") for file " + file.getAbsolutePath());
        }
        if ((long)n > file.length()) {
            throw new PicardException("Header size(" + n + ") is greater than file size(" + file.length() + ") for file " + file.getAbsolutePath());
        }
    }

    private static ByteBuffer getBuffer(File file) {
        MappedByteBuffer mappedByteBuffer;
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            FileChannel fileChannel = fileInputStream.getChannel();
            long l = fileChannel.size();
            mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, l);
            mappedByteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            CloserUtil.close(fileChannel);
            CloserUtil.close(fileInputStream);
        }
        catch (IOException iOException) {
            throw new PicardException("IOException opening cluster binary file " + file, iOException);
        }
        return mappedByteBuffer;
    }

    private static byte[] getHeader(ByteBuffer byteBuffer, int n) {
        byte[] byArray = new byte[n];
        if (n > 0) {
            byteBuffer.get(byArray);
        }
        return byArray;
    }

    private static class ByteBufferMMapIterator
    extends MMapBackedIterator<ByteBuffer> {
        private byte[] localBacking;
        private ByteBuffer localBuffer;

        public ByteBufferMMapIterator(byte[] byArray, File file, int n, ByteBuffer byteBuffer) {
            super(byArray, file, n, byteBuffer);
            this.localBacking = new byte[n];
            this.localBuffer = ByteBuffer.wrap(this.localBacking);
            this.localBuffer.order(ByteOrder.LITTLE_ENDIAN);
        }

        @Override
        protected ByteBuffer getElement() {
            this.localBuffer.position(0);
            this.buffer.get(this.localBacking);
            this.localBuffer.position(0);
            return this.localBuffer;
        }
    }

    private static class FloatMMapIterator
    extends MMapBackedIterator<Float> {
        public FloatMMapIterator(byte[] byArray, File file, ByteBuffer byteBuffer) {
            super(byArray, file, FLOAT_SIZE, byteBuffer);
        }

        @Override
        protected Float getElement() {
            return Float.valueOf(this.buffer.getFloat());
        }
    }

    private static class ByteMMapIterator
    extends MMapBackedIterator<Byte> {
        public ByteMMapIterator(byte[] byArray, File file, ByteBuffer byteBuffer) {
            super(byArray, file, BYTE_SIZE, byteBuffer);
        }

        @Override
        protected Byte getElement() {
            return this.buffer.get();
        }
    }

    private static class IntegerMMapIterator
    extends MMapBackedIterator<Integer> {
        public IntegerMMapIterator(byte[] byArray, File file, ByteBuffer byteBuffer) {
            super(byArray, file, INT_SIZE, byteBuffer);
        }

        @Override
        protected Integer getElement() {
            return this.buffer.getInt();
        }
    }

    static abstract class MMapBackedIterator<TYPE>
    extends BinaryFileIterator<TYPE> {
        protected final ByteBuffer buffer;

        protected MMapBackedIterator(byte[] byArray, File file, int n, ByteBuffer byteBuffer) {
            super(byArray, file, n);
            this.buffer = byteBuffer;
        }

        @Override
        public boolean hasNext() {
            return this.buffer.limit() - this.buffer.position() >= this.elementSize;
        }

        @Override
        public void skipElements(int n) {
            this.buffer.position(this.buffer.position() + n * this.elementSize);
        }

        @Override
        protected abstract TYPE getElement();

        @Override
        public Iterator<TYPE> iterator() {
            return this;
        }
    }
}

