/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina.parser;

import net.sf.picard.PicardException;
import net.sf.picard.illumina.parser.ReadData;
import net.sf.picard.illumina.parser.ReadType;

public class ClusterData {
    private int lane = -1;
    private int tile = -1;
    private int x = -1;
    private int y = -1;
    private final ReadData[] reads;
    private Boolean pf;
    private String matchedBarcode;

    public ClusterData(ReadData ... readDataArray) {
        this.reads = readDataArray;
    }

    public ClusterData(ReadType[] readTypeArray) {
        this.reads = new ReadData[readTypeArray.length];
        for (int i = 0; i < readTypeArray.length; ++i) {
            this.reads[i] = new ReadData(readTypeArray[i]);
        }
    }

    public String toString() {
        return "ClusterData(lane: " + this.lane + "; tile: " + this.tile + "; x: " + this.x + "; y: " + this.y + "; pf: " + this.pf + "; matchedBarcode: " + this.matchedBarcode + ")";
    }

    public int getTile() {
        return this.tile;
    }

    public void setTile(int n) {
        this.tile = n;
    }

    public boolean tileIsSet() {
        return this.tile != -1;
    }

    public ReadData getRead(int n) {
        return this.reads[n];
    }

    public int getNumReads() {
        return this.reads.length;
    }

    public void setOrCheckTile(int n) {
        if (this.tileIsSet()) {
            if (this.tile != n) {
                throw new PicardException("Tile number mismatch for " + this + " : " + this.tile + " != " + n);
            }
        } else {
            this.tile = n;
        }
    }

    public int getLane() {
        return this.lane;
    }

    public void setLane(int n) {
        this.lane = n;
    }

    public boolean laneIsSet() {
        return this.lane != -1;
    }

    public void setOrCheckLane(int n) {
        if (this.laneIsSet()) {
            if (this.lane != n) {
                throw new PicardException("Lane number mismatch for " + this + " : " + this.lane + " != " + n);
            }
        } else {
            this.lane = n;
        }
    }

    public int getX() {
        return this.x;
    }

    public void setX(int n) {
        this.x = n;
    }

    public boolean xIsSet() {
        return this.x != -1;
    }

    public void setOrCheckX(int n) {
        if (this.xIsSet()) {
            if (this.x != n) {
                throw new PicardException("X value mismatch for " + this + " : " + this.x + " != " + n);
            }
        } else {
            this.x = n;
        }
    }

    public int getY() {
        return this.y;
    }

    public void setY(int n) {
        this.y = n;
    }

    public boolean yIsSet() {
        return this.y != -1;
    }

    public void setOrCheckY(int n) {
        if (this.yIsSet()) {
            if (this.y != n) {
                throw new PicardException("Y value mismatch for " + this + " : " + this.y + " != " + n);
            }
        } else {
            this.y = n;
        }
    }

    public Boolean isPf() {
        return this.pf;
    }

    public void setPf(boolean bl) {
        this.pf = bl;
    }

    public void setOrCheckPf(boolean bl) {
        if (this.pf == null) {
            this.pf = bl;
        } else if (this.pf != bl) {
            throw new PicardException("PF value mismatch for " + this + " : ");
        }
    }

    public String getMatchedBarcode() {
        return this.matchedBarcode;
    }

    public void setMatchedBarcode(String string) {
        this.matchedBarcode = string;
    }
}

