/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.filter;

import java.util.Iterator;
import java.util.List;
import net.sf.picard.filter.SamRecordFilter;
import net.sf.picard.util.Interval;
import net.sf.picard.util.IntervalUtil;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMRecord;

public class IntervalFilter
implements SamRecordFilter {
    private final Iterator<Interval> intervals;
    private final SAMFileHeader samHeader;
    private Interval currentInterval;
    private int currentSequenceIndex;

    public IntervalFilter(List<Interval> list, SAMFileHeader sAMFileHeader) {
        this.samHeader = sAMFileHeader;
        IntervalUtil.assertOrderedNonOverlapping(list.iterator(), sAMFileHeader.getSequenceDictionary());
        this.intervals = list.iterator();
        this.advanceInterval();
    }

    @Override
    public boolean filterOut(SAMRecord sAMRecord) {
        while (this.currentInterval != null && (this.currentSequenceIndex < sAMRecord.getReferenceIndex() || this.currentSequenceIndex == sAMRecord.getReferenceIndex() && this.currentInterval.getEnd() < sAMRecord.getAlignmentStart())) {
            this.advanceInterval();
        }
        return this.currentInterval == null || this.currentSequenceIndex != sAMRecord.getReferenceIndex() || this.currentInterval.getStart() > sAMRecord.getAlignmentEnd();
    }

    private void advanceInterval() {
        if (this.intervals.hasNext()) {
            this.currentInterval = this.intervals.next();
            this.currentSequenceIndex = this.samHeader.getSequenceIndex(this.currentInterval.getSequence());
        } else {
            this.currentInterval = null;
        }
    }

    @Override
    public boolean filterOut(SAMRecord sAMRecord, SAMRecord sAMRecord2) {
        throw new UnsupportedOperationException("Paired IntervalFilter filter not implemented!");
    }
}

