/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.fastq;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.picard.PicardException;
import net.sf.picard.filter.AggregateFilter;
import net.sf.picard.filter.FailsVendorReadQualityFilter;
import net.sf.picard.filter.FilteringIterator;
import net.sf.picard.filter.SamRecordFilter;
import net.sf.picard.filter.TagFilter;
import net.sf.picard.filter.WholeReadClippedFilter;
import net.sf.picard.io.IoUtil;
import net.sf.picard.util.Log;
import net.sf.picard.util.PeekableIterator;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMRecordIterator;
import net.sf.samtools.util.BinaryCodec;

public class BamToBfqWriter {
    private static final int SEED_REGION_LENGTH = 28;
    private static final int MAX_SEED_REGION_NOCALL_FIXES = 2;
    private final File bamFile;
    private final String outputPrefix;
    private final String namePrefix;
    private final int nameTrim;
    private boolean pairedReads = false;
    private int wrote = 0;
    private int increment = 1;
    private int chunk = 0;
    private BinaryCodec codec1;
    private BinaryCodec codec2;
    private final Log log = Log.getInstance(BamToBfqWriter.class);
    private final boolean includeNonPfReads;
    private final boolean clipAdapters;
    private final Integer basesToWrite;

    public BamToBfqWriter(File file, String string, Integer n, Integer n2, boolean bl, String string2, boolean bl2, boolean bl3, Integer n3) {
        IoUtil.assertFileIsReadable(file);
        this.bamFile = file;
        this.outputPrefix = string;
        this.pairedReads = bl;
        if (n != null) {
            double d = this.countWritableRecords();
            this.increment = (int)Math.floor(d / n.doubleValue());
            if (this.increment == 0) {
                this.increment = 1;
            }
        }
        if (n2 != null) {
            this.chunk = n2;
        }
        this.namePrefix = string2;
        this.nameTrim = string2 != null ? string2.length() : 0;
        this.includeNonPfReads = bl2;
        this.clipAdapters = bl3;
        this.basesToWrite = n3;
    }

    public BamToBfqWriter(File file, String string, boolean bl, String string2, boolean bl2) {
        this(file, string, null, null, bl, string2, bl2, true, null);
    }

    public void writeBfqFiles() {
        SAMRecordIterator sAMRecordIterator = new SAMFileReader(IoUtil.openFileForReading(this.bamFile)).iterator();
        TagFilter tagFilter = new TagFilter("XN", 1);
        FailsVendorReadQualityFilter failsVendorReadQualityFilter = new FailsVendorReadQualityFilter();
        WholeReadClippedFilter wholeReadClippedFilter = new WholeReadClippedFilter();
        if (!this.pairedReads) {
            ArrayList<SamRecordFilter> arrayList = new ArrayList<SamRecordFilter>();
            arrayList.add(tagFilter);
            arrayList.add(wholeReadClippedFilter);
            if (!this.includeNonPfReads) {
                arrayList.add(failsVendorReadQualityFilter);
            }
            this.writeSingleEndBfqs(sAMRecordIterator, arrayList);
            this.codec1.close();
        } else {
            this.writePairedEndBfqs(sAMRecordIterator, tagFilter, failsVendorReadQualityFilter, wholeReadClippedFilter);
            this.codec1.close();
            this.codec2.close();
        }
        this.log.info("Wrote " + this.wrote + " bfq records.");
    }

    private void writePairedEndBfqs(Iterator<SAMRecord> iterator, TagFilter tagFilter, FailsVendorReadQualityFilter failsVendorReadQualityFilter, SamRecordFilter ... samRecordFilterArray) {
        int n = 0;
        this.initializeNextBfqFiles(n++);
        int n2 = 0;
        block0: while (iterator.hasNext()) {
            SAMRecord sAMRecord = iterator.next();
            if (!iterator.hasNext()) {
                throw new PicardException("Mismatched number of records in " + this.bamFile.getAbsolutePath());
            }
            SAMRecord sAMRecord2 = iterator.next();
            if (!sAMRecord2.getReadName().equals(sAMRecord.getReadName()) || sAMRecord.getFirstOfPairFlag() == sAMRecord2.getFirstOfPairFlag()) {
                throw new PicardException("Unmatched read pairs in " + this.bamFile.getAbsolutePath() + ": " + sAMRecord.getReadName() + ", " + sAMRecord2.getReadName() + ".");
            }
            if (tagFilter.filterOut(sAMRecord) && tagFilter.filterOut(sAMRecord2) || !this.includeNonPfReads && (failsVendorReadQualityFilter.filterOut(sAMRecord) || failsVendorReadQualityFilter.filterOut(sAMRecord2))) continue;
            for (SamRecordFilter samRecordFilter : samRecordFilterArray) {
                if (samRecordFilter.filterOut(sAMRecord) || samRecordFilter.filterOut(sAMRecord2)) continue block0;
            }
            if (++n2 % this.increment != 0) continue;
            sAMRecord.setReadName(sAMRecord.getReadName() + "/1");
            this.writeFastqRecord(sAMRecord.getFirstOfPairFlag() ? this.codec1 : this.codec2, sAMRecord);
            sAMRecord2.setReadName(sAMRecord2.getReadName() + "/2");
            this.writeFastqRecord(sAMRecord2.getFirstOfPairFlag() ? this.codec1 : this.codec2, sAMRecord2);
            ++this.wrote;
            if (this.wrote % 1000000 == 0) {
                this.log.info(this.wrote + " records written.");
            }
            if (this.chunk <= 0 || this.wrote % this.chunk != 0) continue;
            this.initializeNextBfqFiles(n++);
        }
    }

    private void writeSingleEndBfqs(Iterator<SAMRecord> iterator, List<SamRecordFilter> list) {
        int n = 0;
        this.initializeNextBfqFiles(n++);
        int n2 = 0;
        FilteringIterator filteringIterator = new FilteringIterator(iterator, new AggregateFilter(list));
        while (filteringIterator.hasNext()) {
            SAMRecord sAMRecord = filteringIterator.next();
            if (++n2 % this.increment != 0) continue;
            sAMRecord.setReadName(sAMRecord.getReadName() + "/1");
            this.writeFastqRecord(this.codec1, sAMRecord);
            ++this.wrote;
            if (this.wrote % 1000000 == 0) {
                this.log.info(this.wrote + " records processed.");
            }
            if (this.chunk <= 0 || this.wrote % this.chunk != 0) continue;
            this.initializeNextBfqFiles(n++);
        }
    }

    private void initializeNextBfqFiles(int n) {
        if (this.codec1 != null) {
            this.codec1.close();
            if (this.pairedReads) {
                this.codec2.close();
            }
        }
        File file = this.getOutputFile(this.outputPrefix, 1, n);
        this.codec1 = new BinaryCodec(IoUtil.openFileForWriting(file));
        this.log.info("Now writing to file " + file.getAbsolutePath());
        if (this.pairedReads) {
            File file2 = this.getOutputFile(this.outputPrefix, 2, n);
            this.codec2 = new BinaryCodec(IoUtil.openFileForWriting(file2));
            this.log.info("Now writing to file " + file2.getAbsolutePath());
        }
    }

    private void writeFastqRecord(BinaryCodec binaryCodec, SAMRecord sAMRecord) {
        Object object;
        String string = sAMRecord.getReadName();
        if (this.namePrefix != null && string.startsWith(this.namePrefix)) {
            string = string.substring(this.nameTrim);
        }
        binaryCodec.writeString(string, true, true);
        char[] cArray = sAMRecord.getReadString().toCharArray();
        char[] cArray2 = sAMRecord.getBaseQualityString().toCharArray();
        int n = cArray.length;
        if (this.clipAdapters && (object = sAMRecord.getIntegerAttribute("XT")) != null) {
            assert (sAMRecord.getReadLength() == cArray.length);
            n = Math.min(cArray.length, Math.max(28, (Integer)object - 1));
        }
        binaryCodec.writeInt(this.basesToWrite != null ? this.basesToWrite : cArray.length);
        object = this.encodeSeqsAndQuals(cArray, cArray2, n);
        binaryCodec.writeBytes((byte[])object);
    }

    private byte[] encodeSeqsAndQuals(char[] cArray, char[] cArray2, int n) {
        int n2;
        byte[] byArray = new byte[this.basesToWrite == null ? cArray.length : this.basesToWrite];
        int n3 = 0;
        for (n2 = 0; n2 < n && n2 < byArray.length; ++n2) {
            int n4;
            int n5 = Math.min(cArray2[n2] - 33, 63);
            switch (cArray[n2]) {
                case 'A': 
                case 'a': {
                    n4 = 0;
                    break;
                }
                case 'C': 
                case 'c': {
                    n4 = 1;
                    break;
                }
                case 'G': 
                case 'g': {
                    n4 = 2;
                    break;
                }
                case 'T': 
                case 't': {
                    n4 = 3;
                    break;
                }
                case '.': 
                case 'N': 
                case 'n': {
                    n4 = 0;
                    if (n2 < 28) {
                        if (n3 < 2) {
                            n5 = 1;
                            ++n3;
                            break;
                        }
                        n5 = 0;
                        break;
                    }
                    n5 = 1;
                    break;
                }
                default: {
                    throw new PicardException("Unknown base when writing bfq file: " + cArray[n2]);
                }
            }
            byArray[n2] = this.encodeBaseAndQuality(n4, n5);
        }
        for (n2 = n; n2 < byArray.length; ++n2) {
            byArray[n2] = this.encodeBaseAndQuality(0, 1);
        }
        return byArray;
    }

    private byte encodeBaseAndQuality(int n, int n2) {
        return (byte)(n << 6 | n2);
    }

    private int countWritableRecords() {
        int n = 0;
        SAMFileReader sAMFileReader = new SAMFileReader(IoUtil.openFileForReading(this.bamFile));
        if (!sAMFileReader.getFileHeader().getSortOrder().equals((Object)SAMFileHeader.SortOrder.queryname)) {
            throw new PicardException("Input file (" + this.bamFile.getAbsolutePath() + ") needs to be sorted by queryname.");
        }
        PeekableIterator<SAMRecord> peekableIterator = new PeekableIterator<SAMRecord>(sAMFileReader.iterator());
        if (!this.pairedReads) {
            ArrayList<SamRecordFilter> arrayList = new ArrayList<SamRecordFilter>();
            arrayList.add(new TagFilter("XN", 1));
            if (!this.includeNonPfReads) {
                arrayList.add(new FailsVendorReadQualityFilter());
            }
            FilteringIterator filteringIterator = new FilteringIterator(peekableIterator, new AggregateFilter(arrayList));
            while (filteringIterator.hasNext()) {
                filteringIterator.next();
                ++n;
            }
        } else {
            while (peekableIterator.hasNext()) {
                SAMRecord sAMRecord = peekableIterator.next();
                SAMRecord sAMRecord2 = peekableIterator.next();
                if (sAMRecord.getAttribute("XN") != null && sAMRecord2.getAttribute("XN") != null || !this.includeNonPfReads && (sAMRecord.getReadFailsVendorQualityCheckFlag() || sAMRecord2.getReadFailsVendorQualityCheckFlag())) continue;
                ++n;
            }
        }
        peekableIterator.close();
        return n;
    }

    private File getOutputFile(String string, int n, int n2) {
        File file = new File(string + n2 + "." + n + ".bfq");
        IoUtil.assertFileIsWritable(file);
        return file;
    }
}

