/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.fastq;

import net.sf.picard.fastq.FastqRecord;
import net.sf.picard.fastq.FastqWriter;
import net.sf.samtools.util.AbstractAsyncWriter;

public class AsyncFastqWriter
extends AbstractAsyncWriter<FastqRecord>
implements FastqWriter {
    private final FastqWriter writer;

    public AsyncFastqWriter(FastqWriter fastqWriter, int n) {
        super(n);
        this.writer = fastqWriter;
    }

    @Override
    protected String getThreadNamePrefix() {
        return "FastqWriterThread-";
    }

    @Override
    protected void synchronouslyWrite(FastqRecord fastqRecord) {
        this.writer.write(fastqRecord);
    }

    @Override
    protected void synchronouslyClose() {
        this.writer.close();
    }
}

