/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.analysis;

import java.io.File;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.List;
import net.sf.picard.PicardException;
import net.sf.picard.analysis.GcBiasDetailMetrics;
import net.sf.picard.analysis.GcBiasSummaryMetrics;
import net.sf.picard.cmdline.CommandLineProgram;
import net.sf.picard.cmdline.Option;
import net.sf.picard.io.IoUtil;
import net.sf.picard.metrics.MetricsFile;
import net.sf.picard.reference.ReferenceSequence;
import net.sf.picard.reference.ReferenceSequenceFile;
import net.sf.picard.reference.ReferenceSequenceFileFactory;
import net.sf.picard.util.Log;
import net.sf.picard.util.PeekableIterator;
import net.sf.picard.util.ProgressLogger;
import net.sf.picard.util.QualityUtil;
import net.sf.picard.util.RExecutor;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMReadGroupRecord;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMSequenceDictionary;
import net.sf.samtools.util.SequenceUtil;
import net.sf.samtools.util.StringUtil;

public class CollectGcBiasMetrics
extends CommandLineProgram {
    private static final String R_SCRIPT = "net/sf/picard/analysis/gcBias.R";
    @Option(shortName="R", doc="The reference sequence fasta file.")
    public File REFERENCE_SEQUENCE;
    @Option(shortName="I", doc="The BAM or SAM file containing aligned reads.  Must be coordinate-sorted.")
    public File INPUT;
    @Option(shortName="O", doc="The text file to write the metrics table to.")
    public File OUTPUT;
    @Option(shortName="CHART", doc="The PDF file to render the chart to.")
    public File CHART_OUTPUT;
    @Option(shortName="S", doc="The text file to write summary metrics to.", optional=true)
    public File SUMMARY_OUTPUT;
    @Option(doc="The size of windows on the genome that are used to bin reads.")
    public int WINDOW_SIZE = 100;
    @Option(doc="For summary metrics, exclude GC windows that include less than this fraction of the genome.")
    public double MINIMUM_GENOME_FRACTION = 1.0E-5;
    @Option(doc="If true, assume that the input file is coordinate sorted, even if the header says otherwise.", shortName="AS")
    public boolean ASSUME_SORTED = false;
    @Option(shortName="BS", doc="Whether the SAM or BAM file consists of bisulfite sequenced reads.  ")
    public boolean IS_BISULFITE_SEQUENCED = false;
    private static final Log log = Log.getInstance(CollectGcBiasMetrics.class);
    private int totalClusters = 0;
    private int totalAlignedReads = 0;

    public static void main(String[] stringArray) {
        System.exit(new CollectGcBiasMetrics().instanceMain(stringArray));
    }

    @Override
    protected int doWork() {
        Object object;
        Object object2;
        IoUtil.assertFileIsReadable(this.REFERENCE_SEQUENCE);
        IoUtil.assertFileIsReadable(this.INPUT);
        IoUtil.assertFileIsWritable(this.OUTPUT);
        IoUtil.assertFileIsWritable(this.CHART_OUTPUT);
        if (this.SUMMARY_OUTPUT != null) {
            IoUtil.assertFileIsWritable(this.SUMMARY_OUTPUT);
        }
        int[] nArray = new int[101];
        int[] nArray2 = new int[101];
        long[] lArray = new long[101];
        long[] lArray2 = new long[101];
        SAMFileReader sAMFileReader = new SAMFileReader(this.INPUT);
        if (!this.ASSUME_SORTED && sAMFileReader.getFileHeader().getSortOrder() != SAMFileHeader.SortOrder.coordinate) {
            throw new PicardException("Header of input file " + this.INPUT.getAbsolutePath() + " indicates that it is not coordinate sorted.  " + "If you believe the records are in coordinate order, pass option ASSUME_SORTED=true.  If not, sort the file with SortSam.");
        }
        PeekableIterator<SAMRecord> peekableIterator = new PeekableIterator<SAMRecord>(sAMFileReader.iterator());
        ReferenceSequenceFile referenceSequenceFile = ReferenceSequenceFileFactory.getReferenceSequenceFile(this.REFERENCE_SEQUENCE);
        Object object3 = referenceSequenceFile.getSequenceDictionary();
        Object object4 = sAMFileReader.getFileHeader().getSequenceDictionary();
        if (object3 != null && object4 != null) {
            SequenceUtil.assertSequenceDictionariesEqual((SAMSequenceDictionary)object3, (SAMSequenceDictionary)object4);
        }
        object3 = null;
        object4 = new ProgressLogger(log);
        while ((object3 = referenceSequenceFile.nextSequence()) != null) {
            object2 = ((ReferenceSequence)object3).getBases();
            StringUtil.toUpperCase((byte[])object2);
            int n = ((byte[])object2).length;
            int n2 = n - this.WINDOW_SIZE;
            byte[] byArray = this.calculateAllGcs((byte[])object2, nArray, n2);
            while (peekableIterator.hasNext() && peekableIterator.peek().getReferenceIndex().intValue() == ((ReferenceSequence)object3).getContigIndex()) {
                SAMRecord sAMRecord = peekableIterator.next();
                if (!sAMRecord.getReadPairedFlag() || sAMRecord.getFirstOfPairFlag()) {
                    ++this.totalClusters;
                }
                if (!sAMRecord.getReadUnmappedFlag()) {
                    byte by;
                    int n3 = sAMRecord.getReadNegativeStrandFlag() ? sAMRecord.getAlignmentEnd() - this.WINDOW_SIZE : sAMRecord.getAlignmentStart();
                    ++this.totalAlignedReads;
                    if (n3 > 0 && (by = byArray[n3]) >= 0) {
                        byte by2 = by;
                        nArray2[by2] = nArray2[by2] + 1;
                        byte by3 = by;
                        lArray[by3] = lArray[by3] + (long)sAMRecord.getReadLength();
                        byte by4 = by;
                        lArray2[by4] = lArray2[by4] + (long)(SequenceUtil.countMismatches(sAMRecord, (byte[])object2, this.IS_BISULFITE_SEQUENCED) + SequenceUtil.countInsertedBases(sAMRecord) + SequenceUtil.countDeletedBases(sAMRecord));
                    }
                }
                ((ProgressLogger)object4).record(sAMRecord);
            }
            log.info("Processed reference sequence: " + ((ReferenceSequence)object3).getName());
        }
        while (peekableIterator.hasNext()) {
            object2 = peekableIterator.next();
            if (((SAMRecord)object2).getReadPairedFlag() && !((SAMRecord)object2).getFirstOfPairFlag()) continue;
            ++this.totalClusters;
        }
        object2 = this.getMetricsFile();
        double d = this.sum(nArray);
        double d2 = this.sum(nArray2);
        double d3 = d2 / d;
        double d4 = d * this.MINIMUM_GENOME_FRACTION;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == 0) continue;
            object = new GcBiasDetailMetrics();
            ((GcBiasDetailMetrics)object).GC = i;
            ((GcBiasDetailMetrics)object).WINDOWS = nArray[i];
            ((GcBiasDetailMetrics)object).READ_STARTS = nArray2[i];
            if (lArray2[i] > 0L) {
                ((GcBiasDetailMetrics)object).MEAN_BASE_QUALITY = QualityUtil.getPhredScoreFromObsAndErrors(lArray[i], lArray2[i]);
            }
            ((GcBiasDetailMetrics)object).NORMALIZED_COVERAGE = (double)((GcBiasDetailMetrics)object).READ_STARTS / (double)((GcBiasDetailMetrics)object).WINDOWS / d3;
            ((GcBiasDetailMetrics)object).ERROR_BAR_WIDTH = Math.sqrt(((GcBiasDetailMetrics)object).READ_STARTS) / (double)((GcBiasDetailMetrics)object).WINDOWS / d3;
            ((MetricsFile)object2).addMetric(object);
        }
        ((MetricsFile)object2).write(this.OUTPUT);
        if (this.SUMMARY_OUTPUT != null) {
            MetricsFile metricsFile = this.getMetricsFile();
            object = new GcBiasSummaryMetrics();
            ((GcBiasSummaryMetrics)object).WINDOW_SIZE = this.WINDOW_SIZE;
            ((GcBiasSummaryMetrics)object).TOTAL_CLUSTERS = this.totalClusters;
            ((GcBiasSummaryMetrics)object).ALIGNED_READS = this.totalAlignedReads;
            this.calculateDropoutMetrics(((MetricsFile)object2).getMetrics(), (GcBiasSummaryMetrics)object);
            metricsFile.addMetric(object);
            metricsFile.write(this.SUMMARY_OUTPUT);
        }
        NumberFormat numberFormat = NumberFormat.getIntegerInstance();
        numberFormat.setGroupingUsed(true);
        object = "Total clusters: " + numberFormat.format(this.totalClusters) + ", Aligned reads: " + numberFormat.format(this.totalAlignedReads);
        String string = this.INPUT.getName().replace(".duplicates_marked", "").replace(".aligned.bam", "");
        List<SAMReadGroupRecord> list = sAMFileReader.getFileHeader().getReadGroups();
        if (list.size() == 1) {
            string = string + "." + list.get(0).getLibrary();
        }
        RExecutor.executeFromClasspath(R_SCRIPT, new String[]{this.OUTPUT.getAbsolutePath(), this.CHART_OUTPUT.getAbsolutePath(), string, object, String.valueOf(this.WINDOW_SIZE)});
        return 0;
    }

    private double sum(int[] nArray) {
        int n = nArray.length;
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            d += (double)nArray[i];
        }
        return d;
    }

    private void calculateDropoutMetrics(Collection<GcBiasDetailMetrics> collection, GcBiasSummaryMetrics gcBiasSummaryMetrics) {
        double d = 0.0;
        double d2 = 0.0;
        for (GcBiasDetailMetrics gcBiasDetailMetrics : collection) {
            d += (double)gcBiasDetailMetrics.READ_STARTS;
            d2 += (double)gcBiasDetailMetrics.WINDOWS;
        }
        double d3 = 0.0;
        double d4 = 0.0;
        for (GcBiasDetailMetrics gcBiasDetailMetrics : collection) {
            double d5 = (double)gcBiasDetailMetrics.WINDOWS / d2;
            double d6 = (double)gcBiasDetailMetrics.READ_STARTS / d;
            double d7 = (d5 - d6) * 100.0;
            if (!(d7 > 0.0)) continue;
            if (gcBiasDetailMetrics.GC <= 50) {
                d3 += d7;
            }
            if (gcBiasDetailMetrics.GC < 50) continue;
            d4 += d7;
        }
        gcBiasSummaryMetrics.AT_DROPOUT = d3;
        gcBiasSummaryMetrics.GC_DROPOUT = d4;
    }

    private byte[] calculateAllGcs(byte[] byArray, int[] nArray, int n) {
        int n2 = byArray.length;
        byte[] byArray2 = new byte[n2 + 1];
        CalculateGcState calculateGcState = new CalculateGcState();
        for (int i = 1; i < n; ++i) {
            int n3 = i + this.WINDOW_SIZE;
            int n4 = this.calculateGc(byArray, i, n3, calculateGcState);
            byArray2[i] = (byte)n4;
            if (n4 == -1) continue;
            int n5 = n4;
            nArray[n5] = nArray[n5] + 1;
        }
        return byArray2;
    }

    private int calculateGc(byte[] byArray, int n, int n2, CalculateGcState calculateGcState) {
        if (calculateGcState.init) {
            calculateGcState.init = false;
            calculateGcState.gcCount = 0;
            calculateGcState.nCount = 0;
            for (int i = n; i < n2; ++i) {
                byte by = byArray[i];
                if (by == 71 || by == 67) {
                    ++calculateGcState.gcCount;
                    continue;
                }
                if (by != 78) continue;
                ++calculateGcState.nCount;
            }
        } else {
            byte by = byArray[n2 - 1];
            if (by == 71 || by == 67) {
                ++calculateGcState.gcCount;
            } else if (by == 78) {
                ++calculateGcState.nCount;
            }
            if (calculateGcState.priorBase == 71 || calculateGcState.priorBase == 67) {
                --calculateGcState.gcCount;
            } else if (calculateGcState.priorBase == 78) {
                --calculateGcState.nCount;
            }
        }
        calculateGcState.priorBase = byArray[n];
        if (calculateGcState.nCount > 4) {
            return -1;
        }
        return calculateGcState.gcCount * 100 / (n2 - n);
    }

    class CalculateGcState {
        boolean init = true;
        int nCount;
        int gcCount;
        byte priorBase;

        CalculateGcState() {
        }
    }
}

