SET WRITE_DELAY FALSE;
INSERT INTO MolgenisRole (__Type, id, name) values ('MolgenisGroup', 1, 'system');
INSERT INTO MolgenisRole (__Type, id, name) values ('MolgenisUser', 2, 'admin');
INSERT INTO MolgenisRole (__Type, id, name) values ('MolgenisUser', 3, 'anonymous');
INSERT INTO MolgenisRole (__Type, id, name) values ('MolgenisGroup', 4, 'AllUsers');

INSERT INTO MolgenisGroup (id) values (1);
INSERT INTO MolgenisGroup (id) values (4);

INSERT INTO Person (id, Email, FirstName, LastName) values (2, 'put_something_here@somewhere.com', 'admin', 'admin');
INSERT INTO Person (id, Email, FirstName, LastName) values (3, 'put_something_here@somewhere.com', 'anonymous','anonymous');
INSERT INTO MolgenisUser (id, password_, active, superuser) values (2, 'md5_21232f297a57a5a743894a0e4a801fc3', true, true);
INSERT INTO MolgenisUser (id, password_, active) values (3, 'md5_294de3557d9d00b3d2d8a1e6aab028cf', true);

INSERT INTO MolgenisRole (__Type, id, name) values ('MolgenisGroup', 5, 'biologist');
INSERT INTO MolgenisGroup (id) values (5);
INSERT INTO MolgenisRole (__Type, id, name) values ('MolgenisGroup', 6, 'bioinformatician');
INSERT INTO MolgenisGroup (id) values (6);

INSERT INTO MolgenisRoleGroupLink (group_, role_) values (1, 2);
INSERT INTO MolgenisRoleGroupLink (group_, role_) values (4, 2);
INSERT INTO MolgenisRoleGroupLink (group_, role_) values (1, 3);
INSERT INTO MolgenisRoleGroupLink (group_, role_) values (4, 3);

INSERT INTO MolgenisEntity(name, type_, classname) values ('MolgenisRole', 'ENTITY', 'org.molgenis.auth.MolgenisRole');
INSERT INTO MolgenisEntity(name, type_, classname) values ('MolgenisGroup', 'ENTITY', 'org.molgenis.auth.MolgenisGroup');
INSERT INTO MolgenisEntity(name, type_, classname) values ('MolgenisRoleGroupLink', 'ENTITY', 'org.molgenis.auth.MolgenisRoleGroupLink');
INSERT INTO MolgenisEntity(name, type_, classname) values ('Person', 'ENTITY', 'org.molgenis.auth.Person');
INSERT INTO MolgenisEntity(name, type_, classname) values ('PersonRole', 'ENTITY', 'org.molgenis.auth.PersonRole');
INSERT INTO MolgenisEntity(name, type_, classname) values ('Institute', 'ENTITY', 'org.molgenis.auth.Institute');
INSERT INTO MolgenisEntity(name, type_, classname) values ('MolgenisUser', 'ENTITY', 'org.molgenis.auth.MolgenisUser');
INSERT INTO MolgenisEntity(name, type_, classname) values ('MolgenisPermission', 'ENTITY', 'org.molgenis.auth.MolgenisPermission');
INSERT INTO MolgenisEntity(name, type_, classname) values ('OntologyTerm', 'ENTITY', 'org.molgenis.core.OntologyTerm');
INSERT INTO MolgenisEntity(name, type_, classname) values ('Ontology', 'ENTITY', 'org.molgenis.core.Ontology');
INSERT INTO MolgenisEntity(name, type_, classname) values ('MolgenisFile', 'ENTITY', 'org.molgenis.core.MolgenisFile');
INSERT INTO MolgenisEntity(name, type_, classname) values ('RuntimeProperty', 'ENTITY', 'org.molgenis.core.RuntimeProperty');
INSERT INTO MolgenisEntity(name, type_, classname) values ('Publication', 'ENTITY', 'org.molgenis.core.Publication');
INSERT INTO MolgenisEntity(name, type_, classname) values ('UseCase', 'ENTITY', 'org.molgenis.core.UseCase');
INSERT INTO MolgenisEntity(name, type_, classname) values ('MolgenisEntity', 'ENTITY', 'org.molgenis.core.MolgenisEntity');
INSERT INTO MolgenisEntity(name, type_, classname) values ('DataFile', 'ENTITY', 'org.molgenis.data.DataFile');
INSERT INTO MolgenisEntity(name, type_, classname) values ('Data', 'ENTITY', 'org.molgenis.data.Data');
INSERT INTO MolgenisEntity(name, type_, classname) values ('BinaryDataMatrix', 'ENTITY', 'org.molgenis.data.BinaryDataMatrix');
INSERT INTO MolgenisEntity(name, type_, classname) values ('CSVDataMatrix', 'ENTITY', 'org.molgenis.data.CSVDataMatrix');
INSERT INTO MolgenisEntity(name, type_, classname) values ('DecimalDataElement', 'ENTITY', 'org.molgenis.data.DecimalDataElement');
INSERT INTO MolgenisEntity(name, type_, classname) values ('TextDataElement', 'ENTITY', 'org.molgenis.data.TextDataElement');
INSERT INTO MolgenisEntity(name, type_, classname) values ('OriginalFile', 'ENTITY', 'org.molgenis.data.OriginalFile');
INSERT INTO MolgenisEntity(name, type_, classname) values ('Investigation', 'ENTITY', 'org.molgenis.organization.Investigation');
INSERT INTO MolgenisEntity(name, type_, classname) values ('Species', 'ENTITY', 'org.molgenis.pheno.Species');
INSERT INTO MolgenisEntity(name, type_, classname) values ('AlternateId', 'ENTITY', 'org.molgenis.pheno.AlternateId');
INSERT INTO MolgenisEntity(name, type_, classname) values ('ObservationElement', 'ENTITY', 'org.molgenis.pheno.ObservationElement');
INSERT INTO MolgenisEntity(name, type_, classname) values ('ObservationTarget', 'ENTITY', 'org.molgenis.pheno.ObservationTarget');
INSERT INTO MolgenisEntity(name, type_, classname) values ('ObservableFeature', 'ENTITY', 'org.molgenis.pheno.ObservableFeature');
INSERT INTO MolgenisEntity(name, type_, classname) values ('Measurement', 'ENTITY', 'org.molgenis.pheno.Measurement');
INSERT INTO MolgenisEntity(name, type_, classname) values ('Category', 'ENTITY', 'org.molgenis.pheno.Category');
INSERT INTO MolgenisEntity(name, type_, classname) values ('Individual', 'ENTITY', 'org.molgenis.pheno.Individual');
INSERT INTO MolgenisEntity(name, type_, classname) values ('Location', 'ENTITY', 'org.molgenis.pheno.Location');
INSERT INTO MolgenisEntity(name, type_, classname) values ('Panel', 'ENTITY', 'org.molgenis.pheno.Panel');
INSERT INTO MolgenisEntity(name, type_, classname) values ('ObservedValue', 'ENTITY', 'org.molgenis.pheno.ObservedValue');
INSERT INTO MolgenisEntity(name, type_, classname) values ('Protocol', 'ENTITY', 'org.molgenis.protocol.Protocol');
INSERT INTO MolgenisEntity(name, type_, classname) values ('ProtocolApplication', 'ENTITY', 'org.molgenis.protocol.ProtocolApplication');
INSERT INTO MolgenisEntity(name, type_, classname) values ('ProtocolDocument', 'ENTITY', 'org.molgenis.protocol.ProtocolDocument');
INSERT INTO MolgenisEntity(name, type_, classname) values ('Workflow', 'ENTITY', 'org.molgenis.protocol.Workflow');
INSERT INTO MolgenisEntity(name, type_, classname) values ('WorkflowElement', 'ENTITY', 'org.molgenis.protocol.WorkflowElement');
INSERT INTO MolgenisEntity(name, type_, classname) values ('WorkflowElementParameter', 'ENTITY', 'org.molgenis.protocol.WorkflowElementParameter');
INSERT INTO MolgenisEntity(name, type_, classname) values ('Chromosome', 'ENTITY', 'org.molgenis.xgap.Chromosome');
INSERT INTO MolgenisEntity(name, type_, classname) values ('NMRBin', 'ENTITY', 'org.molgenis.xgap.NMRBin');
INSERT INTO MolgenisEntity(name, type_, classname) values ('Clone', 'ENTITY', 'org.molgenis.xgap.Clone');
INSERT INTO MolgenisEntity(name, type_, classname) values ('DerivedTrait', 'ENTITY', 'org.molgenis.xgap.DerivedTrait');
INSERT INTO MolgenisEntity(name, type_, classname) values ('EnvironmentalFactor', 'ENTITY', 'org.molgenis.xgap.EnvironmentalFactor');
INSERT INTO MolgenisEntity(name, type_, classname) values ('Gene', 'ENTITY', 'org.molgenis.xgap.Gene');
INSERT INTO MolgenisEntity(name, type_, classname) values ('Transcript', 'ENTITY', 'org.molgenis.xgap.Transcript');
INSERT INTO MolgenisEntity(name, type_, classname) values ('Protein', 'ENTITY', 'org.molgenis.xgap.Protein');
INSERT INTO MolgenisEntity(name, type_, classname) values ('Metabolite', 'ENTITY', 'org.molgenis.xgap.Metabolite');
INSERT INTO MolgenisEntity(name, type_, classname) values ('Marker', 'ENTITY', 'org.molgenis.xgap.Marker');
INSERT INTO MolgenisEntity(name, type_, classname) values ('SNP', 'ENTITY', 'org.molgenis.xgap.SNP');
INSERT INTO MolgenisEntity(name, type_, classname) values ('Polymorphism', 'ENTITY', 'org.molgenis.xgap.Polymorphism');
INSERT INTO MolgenisEntity(name, type_, classname) values ('Probe', 'ENTITY', 'org.molgenis.xgap.Probe');
INSERT INTO MolgenisEntity(name, type_, classname) values ('Spot', 'ENTITY', 'org.molgenis.xgap.Spot');
INSERT INTO MolgenisEntity(name, type_, classname) values ('ProbeSet', 'ENTITY', 'org.molgenis.xgap.ProbeSet');
INSERT INTO MolgenisEntity(name, type_, classname) values ('MassPeak', 'ENTITY', 'org.molgenis.xgap.MassPeak');
INSERT INTO MolgenisEntity(name, type_, classname) values ('InvestigationFile', 'ENTITY', 'org.molgenis.xgap.InvestigationFile');
INSERT INTO MolgenisEntity(name, type_, classname) values ('Tissue', 'ENTITY', 'org.molgenis.xgap.Tissue');
INSERT INTO MolgenisEntity(name, type_, classname) values ('SampleLabel', 'ENTITY', 'org.molgenis.xgap.SampleLabel');
INSERT INTO MolgenisEntity(name, type_, classname) values ('Sample', 'ENTITY', 'org.molgenis.xgap.Sample');
INSERT INTO MolgenisEntity(name, type_, classname) values ('PairedSample', 'ENTITY', 'org.molgenis.xgap.PairedSample');
INSERT INTO MolgenisEntity(name, type_, classname) values ('Job', 'ENTITY', 'org.molgenis.cluster.Job');
INSERT INTO MolgenisEntity(name, type_, classname) values ('Subjob', 'ENTITY', 'org.molgenis.cluster.Subjob');
INSERT INTO MolgenisEntity(name, type_, classname) values ('Analysis', 'ENTITY', 'org.molgenis.cluster.Analysis');
INSERT INTO MolgenisEntity(name, type_, classname) values ('ParameterSet', 'ENTITY', 'org.molgenis.cluster.ParameterSet');
INSERT INTO MolgenisEntity(name, type_, classname) values ('ParameterName', 'ENTITY', 'org.molgenis.cluster.ParameterName');
INSERT INTO MolgenisEntity(name, type_, classname) values ('ParameterValue', 'ENTITY', 'org.molgenis.cluster.ParameterValue');
INSERT INTO MolgenisEntity(name, type_, classname) values ('DataSet', 'ENTITY', 'org.molgenis.cluster.DataSet');
INSERT INTO MolgenisEntity(name, type_, classname) values ('DataName', 'ENTITY', 'org.molgenis.cluster.DataName');
INSERT INTO MolgenisEntity(name, type_, classname) values ('DataValue', 'ENTITY', 'org.molgenis.cluster.DataValue');
INSERT INTO MolgenisEntity(name, type_, classname) values ('SelectedParameter', 'ENTITY', 'org.molgenis.cluster.SelectedParameter');
INSERT INTO MolgenisEntity(name, type_, classname) values ('SelectedData', 'ENTITY', 'org.molgenis.cluster.SelectedData');
INSERT INTO MolgenisEntity(name, type_, classname) values ('RScript', 'ENTITY', 'org.molgenis.cluster.RScript');
INSERT INTO MolgenisEntity(name, type_, classname) values ('Investigation_Contacts', 'ENTITY', 'org.molgenis.organization.Investigation_Contacts');
INSERT INTO MolgenisEntity(name, type_, classname) values ('ObservationElement_Ontolo12449', 'ENTITY', 'org.molgenis.pheno.ObservationElement_Ontolo12449');
INSERT INTO MolgenisEntity(name, type_, classname) values ('ObservationElement_AlternateId', 'ENTITY', 'org.molgenis.pheno.ObservationElement_AlternateId');
INSERT INTO MolgenisEntity(name, type_, classname) values ('Measurement_Categories', 'ENTITY', 'org.molgenis.pheno.Measurement_Categories');
INSERT INTO MolgenisEntity(name, type_, classname) values ('Panel_Individuals', 'ENTITY', 'org.molgenis.pheno.Panel_Individuals');
INSERT INTO MolgenisEntity(name, type_, classname) values ('Panel_FounderPanels', 'ENTITY', 'org.molgenis.pheno.Panel_FounderPanels');
INSERT INTO MolgenisEntity(name, type_, classname) values ('Protocol_OntologyReference', 'ENTITY', 'org.molgenis.protocol.Protocol_OntologyReference');
INSERT INTO MolgenisEntity(name, type_, classname) values ('Protocol_Features', 'ENTITY', 'org.molgenis.protocol.Protocol_Features');
INSERT INTO MolgenisEntity(name, type_, classname) values ('Protocol_Subprotocols', 'ENTITY', 'org.molgenis.protocol.Protocol_Subprotocols');
INSERT INTO MolgenisEntity(name, type_, classname) values ('ProtocolApplication_Ontol11768', 'ENTITY', 'org.molgenis.protocol.ProtocolApplication_Ontol11768');
INSERT INTO MolgenisEntity(name, type_, classname) values ('ProtocolApplication_Performer', 'ENTITY', 'org.molgenis.protocol.ProtocolApplication_Performer');
INSERT INTO MolgenisEntity(name, type_, classname) values ('WorkflowElement_PreviousSteps', 'ENTITY', 'org.molgenis.protocol.WorkflowElement_PreviousSteps');
INSERT INTO MolgenisEntity(name, type_, classname) values ('Marker_ReportsFor', 'ENTITY', 'org.molgenis.xgap.Marker_ReportsFor');
INSERT INTO MolgenisEntity(name, type_, classname) values ('SNP_Polymorphism', 'ENTITY', 'org.molgenis.xgap.SNP_Polymorphism');

INSERT INTO MolgenisEntity(name, type_, classname) values ('MolgenisHeaderPlugin', 'PLUGIN', 'app.ui.MolgenisHeaderPlugin');
INSERT INTO MolgenisEntity(name, type_, classname) values ('FeedbackFormPlugin', 'PLUGIN', 'app.ui.FeedbackFormPlugin');
INSERT INTO MolgenisEntity(name, type_, classname) values ('mainMenu', 'MENU', 'app.ui.mainMenu');
INSERT INTO MolgenisEntity(name, type_, classname) values ('ClusterDemoPlugin', 'PLUGIN', 'app.ui.ClusterDemoPlugin');
INSERT INTO MolgenisEntity(name, type_, classname) values ('UserLoginPlugin', 'PLUGIN', 'app.ui.UserLoginPlugin');
INSERT INTO MolgenisEntity(name, type_, classname) values ('InvestigationsFormController', 'FORM', 'app.ui.InvestigationsFormController');
INSERT INTO MolgenisEntity(name, type_, classname) values ('InvestigationMenuMenu', 'MENU', 'app.ui.InvestigationMenuMenu');
INSERT INTO MolgenisEntity(name, type_, classname) values ('OverviewPlugin', 'PLUGIN', 'app.ui.OverviewPlugin');
INSERT INTO MolgenisEntity(name, type_, classname) values ('DatasFormController', 'FORM', 'app.ui.DatasFormController');
INSERT INTO MolgenisEntity(name, type_, classname) values ('SelectMenu', 'MENU', 'app.ui.SelectMenu');
INSERT INTO MolgenisEntity(name, type_, classname) values ('ManagerPlugin', 'PLUGIN', 'app.ui.ManagerPlugin');
INSERT INTO MolgenisEntity(name, type_, classname) values ('InspectorPlugin', 'PLUGIN', 'app.ui.InspectorPlugin');
INSERT INTO MolgenisEntity(name, type_, classname) values ('MatrixAdminPlugin', 'PLUGIN', 'app.ui.MatrixAdminPlugin');
INSERT INTO MolgenisEntity(name, type_, classname) values ('BasicAnnotationsMenu', 'MENU', 'app.ui.BasicAnnotationsMenu');
INSERT INTO MolgenisEntity(name, type_, classname) values ('IndividualsFormController', 'FORM', 'app.ui.IndividualsFormController');
INSERT INTO MolgenisEntity(name, type_, classname) values ('PanelsFormController', 'FORM', 'app.ui.PanelsFormController');
INSERT INTO MolgenisEntity(name, type_, classname) values ('ChromosomesFormController', 'FORM', 'app.ui.ChromosomesFormController');
INSERT INTO MolgenisEntity(name, type_, classname) values ('MarkersFormController', 'FORM', 'app.ui.MarkersFormController');
INSERT INTO MolgenisEntity(name, type_, classname) values ('GenesFormController', 'FORM', 'app.ui.GenesFormController');
INSERT INTO MolgenisEntity(name, type_, classname) values ('TranscriptsFormController', 'FORM', 'app.ui.TranscriptsFormController');
INSERT INTO MolgenisEntity(name, type_, classname) values ('MeasurementsFormController', 'FORM', 'app.ui.MeasurementsFormController');
INSERT INTO MolgenisEntity(name, type_, classname) values ('AdvancedAnnotationsMenu', 'MENU', 'app.ui.AdvancedAnnotationsMenu');
INSERT INTO MolgenisEntity(name, type_, classname) values ('DerivedTraitsFormController', 'FORM', 'app.ui.DerivedTraitsFormController');
INSERT INTO MolgenisEntity(name, type_, classname) values ('EnvironmentalFactorsFormController', 'FORM', 'app.ui.EnvironmentalFactorsFormController');
INSERT INTO MolgenisEntity(name, type_, classname) values ('MassPeaksFormController', 'FORM', 'app.ui.MassPeaksFormController');
INSERT INTO MolgenisEntity(name, type_, classname) values ('MetabolitesFormController', 'FORM', 'app.ui.MetabolitesFormController');
INSERT INTO MolgenisEntity(name, type_, classname) values ('ProbesFormController', 'FORM', 'app.ui.ProbesFormController');
INSERT INTO MolgenisEntity(name, type_, classname) values ('ProbeSetsFormController', 'FORM', 'app.ui.ProbeSetsFormController');
INSERT INTO MolgenisEntity(name, type_, classname) values ('SNPsFormController', 'FORM', 'app.ui.SNPsFormController');
INSERT INTO MolgenisEntity(name, type_, classname) values ('PolymorphismsFormController', 'FORM', 'app.ui.PolymorphismsFormController');
INSERT INTO MolgenisEntity(name, type_, classname) values ('SamplesFormController', 'FORM', 'app.ui.SamplesFormController');
INSERT INTO MolgenisEntity(name, type_, classname) values ('SpotsFormController', 'FORM', 'app.ui.SpotsFormController');
INSERT INTO MolgenisEntity(name, type_, classname) values ('ImportDataMenuMenu', 'MENU', 'app.ui.ImportDataMenuMenu');
INSERT INTO MolgenisEntity(name, type_, classname) values ('QTLWizardPlugin', 'PLUGIN', 'app.ui.QTLWizardPlugin');
INSERT INTO MolgenisEntity(name, type_, classname) values ('PlinkFileManagerPlugin', 'PLUGIN', 'app.ui.PlinkFileManagerPlugin');
INSERT INTO MolgenisEntity(name, type_, classname) values ('ExcelWizardPlugin', 'PLUGIN', 'app.ui.ExcelWizardPlugin');
INSERT INTO MolgenisEntity(name, type_, classname) values ('SimpleArchiverPlugin', 'PLUGIN', 'app.ui.SimpleArchiverPlugin');
INSERT INTO MolgenisEntity(name, type_, classname) values ('FilesFormController', 'FORM', 'app.ui.FilesFormController');
INSERT INTO MolgenisEntity(name, type_, classname) values ('ViewerPlugin', 'PLUGIN', 'app.ui.ViewerPlugin');
INSERT INTO MolgenisEntity(name, type_, classname) values ('ClusterPlugin', 'PLUGIN', 'app.ui.ClusterPlugin');
INSERT INTO MolgenisEntity(name, type_, classname) values ('AnalysisSettingsMenu', 'MENU', 'app.ui.AnalysisSettingsMenu');
INSERT INTO MolgenisEntity(name, type_, classname) values ('AnalysisFormController', 'FORM', 'app.ui.AnalysisFormController');
INSERT INTO MolgenisEntity(name, type_, classname) values ('ParameterSetsFormController', 'FORM', 'app.ui.ParameterSetsFormController');
INSERT INTO MolgenisEntity(name, type_, classname) values ('ParameterNamesFormController', 'FORM', 'app.ui.ParameterNamesFormController');
INSERT INTO MolgenisEntity(name, type_, classname) values ('ParameterValuesFormController', 'FORM', 'app.ui.ParameterValuesFormController');
INSERT INTO MolgenisEntity(name, type_, classname) values ('DataSetsFormController', 'FORM', 'app.ui.DataSetsFormController');
INSERT INTO MolgenisEntity(name, type_, classname) values ('DataNamesFormController', 'FORM', 'app.ui.DataNamesFormController');
INSERT INTO MolgenisEntity(name, type_, classname) values ('DataValuesFormController', 'FORM', 'app.ui.DataValuesFormController');
INSERT INTO MolgenisEntity(name, type_, classname) values ('RScriptsFormController', 'FORM', 'app.ui.RScriptsFormController');
INSERT INTO MolgenisEntity(name, type_, classname) values ('RViewerPlugin', 'PLUGIN', 'app.ui.RViewerPlugin');
INSERT INTO MolgenisEntity(name, type_, classname) values ('MatrixWizardPlugin', 'PLUGIN', 'app.ui.MatrixWizardPlugin');
INSERT INTO MolgenisEntity(name, type_, classname) values ('SearchMenuMenu', 'MENU', 'app.ui.SearchMenuMenu');
INSERT INTO MolgenisEntity(name, type_, classname) values ('SimpleDbSearchPlugin', 'PLUGIN', 'app.ui.SimpleDbSearchPlugin');
INSERT INTO MolgenisEntity(name, type_, classname) values ('QtlFinderPublic2Plugin', 'PLUGIN', 'app.ui.QtlFinderPublic2Plugin');
INSERT INTO MolgenisEntity(name, type_, classname) values ('GenomeBrowserPlugin', 'PLUGIN', 'app.ui.GenomeBrowserPlugin');
INSERT INTO MolgenisEntity(name, type_, classname) values ('UtilitiesMenu', 'MENU', 'app.ui.UtilitiesMenu');
INSERT INTO MolgenisEntity(name, type_, classname) values ('OntologiesMenu', 'MENU', 'app.ui.OntologiesMenu');
INSERT INTO MolgenisEntity(name, type_, classname) values ('ProtocolsFormController', 'FORM', 'app.ui.ProtocolsFormController');
INSERT INTO MolgenisEntity(name, type_, classname) values ('PersonsFormController', 'FORM', 'app.ui.PersonsFormController');
INSERT INTO MolgenisEntity(name, type_, classname) values ('InstitutesFormController', 'FORM', 'app.ui.InstitutesFormController');
INSERT INTO MolgenisEntity(name, type_, classname) values ('SpeciesFormController', 'FORM', 'app.ui.SpeciesFormController');
INSERT INTO MolgenisEntity(name, type_, classname) values ('TissuesFormController', 'FORM', 'app.ui.TissuesFormController');
INSERT INTO MolgenisEntity(name, type_, classname) values ('AlternateIdsFormController', 'FORM', 'app.ui.AlternateIdsFormController');
INSERT INTO MolgenisEntity(name, type_, classname) values ('PublicationsFormController', 'FORM', 'app.ui.PublicationsFormController');
INSERT INTO MolgenisEntity(name, type_, classname) values ('OntologyTermsFormController', 'FORM', 'app.ui.OntologyTermsFormController');
INSERT INTO MolgenisEntity(name, type_, classname) values ('ToolsMenu', 'MENU', 'app.ui.ToolsMenu');
INSERT INTO MolgenisEntity(name, type_, classname) values ('NamingPolicyPlugin', 'PLUGIN', 'app.ui.NamingPolicyPlugin');
INSERT INTO MolgenisEntity(name, type_, classname) values ('DuplicateRenamingPlugin', 'PLUGIN', 'app.ui.DuplicateRenamingPlugin');
INSERT INTO MolgenisEntity(name, type_, classname) values ('AdminMenu', 'MENU', 'app.ui.AdminMenu');
INSERT INTO MolgenisEntity(name, type_, classname) values ('AuthMenu', 'MENU', 'app.ui.AuthMenu');
INSERT INTO MolgenisEntity(name, type_, classname) values ('ManagementMenu', 'MENU', 'app.ui.ManagementMenu');
INSERT INTO MolgenisEntity(name, type_, classname) values ('MolgenisUserFormController', 'FORM', 'app.ui.MolgenisUserFormController');
INSERT INTO MolgenisEntity(name, type_, classname) values ('MolgenisGroupFormController', 'FORM', 'app.ui.MolgenisGroupFormController');
INSERT INTO MolgenisEntity(name, type_, classname) values ('MolgenisRoleGroupLinkFormController', 'FORM', 'app.ui.MolgenisRoleGroupLinkFormController');
INSERT INTO MolgenisEntity(name, type_, classname) values ('MolgenisEntityFormController', 'FORM', 'app.ui.MolgenisEntityFormController');
INSERT INTO MolgenisEntity(name, type_, classname) values ('MolgenisPermissionFormController', 'FORM', 'app.ui.MolgenisPermissionFormController');
INSERT INTO MolgenisEntity(name, type_, classname) values ('PermissionManagementPluginPlugin', 'PLUGIN', 'app.ui.PermissionManagementPluginPlugin');
INSERT INTO MolgenisEntity(name, type_, classname) values ('UserToPersonPluginPlugin', 'PLUGIN', 'app.ui.UserToPersonPluginPlugin');
INSERT INTO MolgenisEntity(name, type_, classname) values ('TokenManagerPluginPlugin', 'PLUGIN', 'app.ui.TokenManagerPluginPlugin');
INSERT INTO MolgenisEntity(name, type_, classname) values ('DatabaseSettingsPlugin', 'PLUGIN', 'app.ui.DatabaseSettingsPlugin');
INSERT INTO MolgenisEntity(name, type_, classname) values ('AppCustomizerPlugin', 'PLUGIN', 'app.ui.AppCustomizerPlugin');
INSERT INTO MolgenisEntity(name, type_, classname) values ('FileStoragePlugin', 'PLUGIN', 'app.ui.FileStoragePlugin');
INSERT INTO MolgenisEntity(name, type_, classname) values ('DependencyManagerPlugin', 'PLUGIN', 'app.ui.DependencyManagerPlugin');
INSERT INTO MolgenisEntity(name, type_, classname) values ('OtherAdminMenu', 'MENU', 'app.ui.OtherAdminMenu');
INSERT INTO MolgenisEntity(name, type_, classname) values ('JobsFormController', 'FORM', 'app.ui.JobsFormController');
INSERT INTO MolgenisEntity(name, type_, classname) values ('SubjobsFormController', 'FORM', 'app.ui.SubjobsFormController');
INSERT INTO MolgenisEntity(name, type_, classname) values ('ROnlinePlugin', 'PLUGIN', 'app.ui.ROnlinePlugin');

INSERT INTO MolgenisPermission (role_, entity, permission) SELECT 3, id, 'read' FROM MolgenisEntity WHERE MolgenisEntity.name = 'UserLoginPlugin';
INSERT INTO MolgenisPermission (role_, entity, permission) SELECT (SELECT id FROM MolgenisRole WHERE name = 'biologist'), id, 'write' FROM MolgenisEntity WHERE MolgenisEntity.name = 'InvestigationsFormController';
INSERT INTO MolgenisPermission (role_, entity, permission) SELECT (SELECT id FROM MolgenisRole WHERE name = 'biologist'), id, 'write' FROM MolgenisEntity WHERE MolgenisEntity.id = (SELECT id FROM MolgenisEntity WHERE className = 'org.molgenis.organization.Investigation');
INSERT INTO MolgenisPermission (role_, entity, permission) SELECT (SELECT id FROM MolgenisRole WHERE name = 'biologist'), id, 'write' FROM MolgenisEntity WHERE MolgenisEntity.name = 'OverviewPlugin';
INSERT INTO MolgenisPermission (role_, entity, permission) SELECT (SELECT id FROM MolgenisRole WHERE name = 'biologist'), id, 'write' FROM MolgenisEntity WHERE MolgenisEntity.name = 'DatasFormController';
INSERT INTO MolgenisPermission (role_, entity, permission) SELECT (SELECT id FROM MolgenisRole WHERE name = 'biologist'), id, 'write' FROM MolgenisEntity WHERE MolgenisEntity.id = (SELECT id FROM MolgenisEntity WHERE className = 'org.molgenis.data.Data');
INSERT INTO MolgenisPermission (role_, entity, permission) SELECT (SELECT id FROM MolgenisRole WHERE name = 'biologist'), id, 'write' FROM MolgenisEntity WHERE MolgenisEntity.name = 'SelectMenu';
INSERT INTO MolgenisPermission (role_, entity, permission) SELECT (SELECT id FROM MolgenisRole WHERE name = 'biologist'), id, 'write' FROM MolgenisEntity WHERE MolgenisEntity.name = 'ManagerPlugin';
INSERT INTO MolgenisPermission (role_, entity, permission) SELECT (SELECT id FROM MolgenisRole WHERE name = 'biologist'), id, 'write' FROM MolgenisEntity WHERE MolgenisEntity.name = 'InspectorPlugin';
INSERT INTO MolgenisPermission (role_, entity, permission) SELECT (SELECT id FROM MolgenisRole WHERE name = 'biologist'), id, 'write' FROM MolgenisEntity WHERE MolgenisEntity.name = 'MatrixAdminPlugin';
INSERT INTO MolgenisPermission (role_, entity, permission) SELECT (SELECT id FROM MolgenisRole WHERE name = 'biologist'), id, 'write' FROM MolgenisEntity WHERE MolgenisEntity.name = 'IndividualsFormController';
INSERT INTO MolgenisPermission (role_, entity, permission) SELECT (SELECT id FROM MolgenisRole WHERE name = 'biologist'), id, 'write' FROM MolgenisEntity WHERE MolgenisEntity.id = (SELECT id FROM MolgenisEntity WHERE className = 'org.molgenis.pheno.Individual');
INSERT INTO MolgenisPermission (role_, entity, permission) SELECT (SELECT id FROM MolgenisRole WHERE name = 'biologist'), id, 'write' FROM MolgenisEntity WHERE MolgenisEntity.name = 'PanelsFormController';
INSERT INTO MolgenisPermission (role_, entity, permission) SELECT (SELECT id FROM MolgenisRole WHERE name = 'biologist'), id, 'write' FROM MolgenisEntity WHERE MolgenisEntity.id = (SELECT id FROM MolgenisEntity WHERE className = 'org.molgenis.pheno.Panel');
INSERT INTO MolgenisPermission (role_, entity, permission) SELECT (SELECT id FROM MolgenisRole WHERE name = 'biologist'), id, 'write' FROM MolgenisEntity WHERE MolgenisEntity.name = 'ChromosomesFormController';
INSERT INTO MolgenisPermission (role_, entity, permission) SELECT (SELECT id FROM MolgenisRole WHERE name = 'biologist'), id, 'write' FROM MolgenisEntity WHERE MolgenisEntity.id = (SELECT id FROM MolgenisEntity WHERE className = 'org.molgenis.xgap.Chromosome');
INSERT INTO MolgenisPermission (role_, entity, permission) SELECT (SELECT id FROM MolgenisRole WHERE name = 'biologist'), id, 'write' FROM MolgenisEntity WHERE MolgenisEntity.name = 'MarkersFormController';
INSERT INTO MolgenisPermission (role_, entity, permission) SELECT (SELECT id FROM MolgenisRole WHERE name = 'biologist'), id, 'write' FROM MolgenisEntity WHERE MolgenisEntity.id = (SELECT id FROM MolgenisEntity WHERE className = 'org.molgenis.xgap.Marker');
INSERT INTO MolgenisPermission (role_, entity, permission) SELECT (SELECT id FROM MolgenisRole WHERE name = 'biologist'), id, 'write' FROM MolgenisEntity WHERE MolgenisEntity.name = 'GenesFormController';
INSERT INTO MolgenisPermission (role_, entity, permission) SELECT (SELECT id FROM MolgenisRole WHERE name = 'biologist'), id, 'write' FROM MolgenisEntity WHERE MolgenisEntity.id = (SELECT id FROM MolgenisEntity WHERE className = 'org.molgenis.xgap.Gene');
INSERT INTO MolgenisPermission (role_, entity, permission) SELECT (SELECT id FROM MolgenisRole WHERE name = 'biologist'), id, 'write' FROM MolgenisEntity WHERE MolgenisEntity.name = 'TranscriptsFormController';
INSERT INTO MolgenisPermission (role_, entity, permission) SELECT (SELECT id FROM MolgenisRole WHERE name = 'biologist'), id, 'write' FROM MolgenisEntity WHERE MolgenisEntity.id = (SELECT id FROM MolgenisEntity WHERE className = 'org.molgenis.xgap.Transcript');
INSERT INTO MolgenisPermission (role_, entity, permission) SELECT (SELECT id FROM MolgenisRole WHERE name = 'biologist'), id, 'write' FROM MolgenisEntity WHERE MolgenisEntity.name = 'MeasurementsFormController';
INSERT INTO MolgenisPermission (role_, entity, permission) SELECT (SELECT id FROM MolgenisRole WHERE name = 'biologist'), id, 'write' FROM MolgenisEntity WHERE MolgenisEntity.id = (SELECT id FROM MolgenisEntity WHERE className = 'org.molgenis.pheno.Measurement');
INSERT INTO MolgenisPermission (role_, entity, permission) SELECT (SELECT id FROM MolgenisRole WHERE name = 'biologist'), id, 'write' FROM MolgenisEntity WHERE MolgenisEntity.name = 'AdvancedAnnotationsMenu';
INSERT INTO MolgenisPermission (role_, entity, permission) SELECT (SELECT id FROM MolgenisRole WHERE name = 'biologist'), id, 'write' FROM MolgenisEntity WHERE MolgenisEntity.name = 'DerivedTraitsFormController';
INSERT INTO MolgenisPermission (role_, entity, permission) SELECT (SELECT id FROM MolgenisRole WHERE name = 'biologist'), id, 'write' FROM MolgenisEntity WHERE MolgenisEntity.id = (SELECT id FROM MolgenisEntity WHERE className = 'org.molgenis.xgap.DerivedTrait');
INSERT INTO MolgenisPermission (role_, entity, permission) SELECT (SELECT id FROM MolgenisRole WHERE name = 'biologist'), id, 'write' FROM MolgenisEntity WHERE MolgenisEntity.name = 'EnvironmentalFactorsFormController';
INSERT INTO MolgenisPermission (role_, entity, permission) SELECT (SELECT id FROM MolgenisRole WHERE name = 'biologist'), id, 'write' FROM MolgenisEntity WHERE MolgenisEntity.id = (SELECT id FROM MolgenisEntity WHERE className = 'org.molgenis.xgap.EnvironmentalFactor');
INSERT INTO MolgenisPermission (role_, entity, permission) SELECT (SELECT id FROM MolgenisRole WHERE name = 'biologist'), id, 'write' FROM MolgenisEntity WHERE MolgenisEntity.name = 'MassPeaksFormController';
INSERT INTO MolgenisPermission (role_, entity, permission) SELECT (SELECT id FROM MolgenisRole WHERE name = 'biologist'), id, 'write' FROM MolgenisEntity WHERE MolgenisEntity.id = (SELECT id FROM MolgenisEntity WHERE className = 'org.molgenis.xgap.MassPeak');
INSERT INTO MolgenisPermission (role_, entity, permission) SELECT (SELECT id FROM MolgenisRole WHERE name = 'biologist'), id, 'write' FROM MolgenisEntity WHERE MolgenisEntity.name = 'MetabolitesFormController';
INSERT INTO MolgenisPermission (role_, entity, permission) SELECT (SELECT id FROM MolgenisRole WHERE name = 'biologist'), id, 'write' FROM MolgenisEntity WHERE MolgenisEntity.id = (SELECT id FROM MolgenisEntity WHERE className = 'org.molgenis.xgap.Metabolite');
INSERT INTO MolgenisPermission (role_, entity, permission) SELECT (SELECT id FROM MolgenisRole WHERE name = 'biologist'), id, 'write' FROM MolgenisEntity WHERE MolgenisEntity.name = 'ProbesFormController';
INSERT INTO MolgenisPermission (role_, entity, permission) SELECT (SELECT id FROM MolgenisRole WHERE name = 'biologist'), id, 'write' FROM MolgenisEntity WHERE MolgenisEntity.id = (SELECT id FROM MolgenisEntity WHERE className = 'org.molgenis.xgap.Probe');
INSERT INTO MolgenisPermission (role_, entity, permission) SELECT (SELECT id FROM MolgenisRole WHERE name = 'biologist'), id, 'write' FROM MolgenisEntity WHERE MolgenisEntity.name = 'ProbeSetsFormController';
INSERT INTO MolgenisPermission (role_, entity, permission) SELECT (SELECT id FROM MolgenisRole WHERE name = 'biologist'), id, 'write' FROM MolgenisEntity WHERE MolgenisEntity.id = (SELECT id FROM MolgenisEntity WHERE className = 'org.molgenis.xgap.ProbeSet');
INSERT INTO MolgenisPermission (role_, entity, permission) SELECT (SELECT id FROM MolgenisRole WHERE name = 'biologist'), id, 'write' FROM MolgenisEntity WHERE MolgenisEntity.name = 'SNPsFormController';
INSERT INTO MolgenisPermission (role_, entity, permission) SELECT (SELECT id FROM MolgenisRole WHERE name = 'biologist'), id, 'write' FROM MolgenisEntity WHERE MolgenisEntity.id = (SELECT id FROM MolgenisEntity WHERE className = 'org.molgenis.xgap.SNP');
INSERT INTO MolgenisPermission (role_, entity, permission) SELECT (SELECT id FROM MolgenisRole WHERE name = 'biologist'), id, 'write' FROM MolgenisEntity WHERE MolgenisEntity.name = 'PolymorphismsFormController';
INSERT INTO MolgenisPermission (role_, entity, permission) SELECT (SELECT id FROM MolgenisRole WHERE name = 'biologist'), id, 'write' FROM MolgenisEntity WHERE MolgenisEntity.id = (SELECT id FROM MolgenisEntity WHERE className = 'org.molgenis.xgap.Polymorphism');
INSERT INTO MolgenisPermission (role_, entity, permission) SELECT (SELECT id FROM MolgenisRole WHERE name = 'biologist'), id, 'write' FROM MolgenisEntity WHERE MolgenisEntity.name = 'SamplesFormController';
INSERT INTO MolgenisPermission (role_, entity, permission) SELECT (SELECT id FROM MolgenisRole WHERE name = 'biologist'), id, 'write' FROM MolgenisEntity WHERE MolgenisEntity.id = (SELECT id FROM MolgenisEntity WHERE className = 'org.molgenis.xgap.Sample');
INSERT INTO MolgenisPermission (role_, entity, permission) SELECT (SELECT id FROM MolgenisRole WHERE name = 'biologist'), id, 'write' FROM MolgenisEntity WHERE MolgenisEntity.name = 'SpotsFormController';
INSERT INTO MolgenisPermission (role_, entity, permission) SELECT (SELECT id FROM MolgenisRole WHERE name = 'biologist'), id, 'write' FROM MolgenisEntity WHERE MolgenisEntity.id = (SELECT id FROM MolgenisEntity WHERE className = 'org.molgenis.xgap.Spot');
INSERT INTO MolgenisPermission (role_, entity, permission) SELECT (SELECT id FROM MolgenisRole WHERE name = 'biologist'), id, 'write' FROM MolgenisEntity WHERE MolgenisEntity.name = 'ImportDataMenuMenu';
INSERT INTO MolgenisPermission (role_, entity, permission) SELECT (SELECT id FROM MolgenisRole WHERE name = 'biologist'), id, 'write' FROM MolgenisEntity WHERE MolgenisEntity.name = 'QTLWizardPlugin';
INSERT INTO MolgenisPermission (role_, entity, permission) SELECT (SELECT id FROM MolgenisRole WHERE name = 'biologist'), id, 'write' FROM MolgenisEntity WHERE MolgenisEntity.name = 'PlinkFileManagerPlugin';
INSERT INTO MolgenisPermission (role_, entity, permission) SELECT (SELECT id FROM MolgenisRole WHERE name = 'biologist'), id, 'write' FROM MolgenisEntity WHERE MolgenisEntity.name = 'ExcelWizardPlugin';
INSERT INTO MolgenisPermission (role_, entity, permission) SELECT (SELECT id FROM MolgenisRole WHERE name = 'biologist'), id, 'write' FROM MolgenisEntity WHERE MolgenisEntity.name = 'FilesFormController';
INSERT INTO MolgenisPermission (role_, entity, permission) SELECT (SELECT id FROM MolgenisRole WHERE name = 'biologist'), id, 'write' FROM MolgenisEntity WHERE MolgenisEntity.id = (SELECT id FROM MolgenisEntity WHERE className = 'org.molgenis.xgap.InvestigationFile');
INSERT INTO MolgenisPermission (role_, entity, permission) SELECT (SELECT id FROM MolgenisRole WHERE name = 'biologist'), id, 'write' FROM MolgenisEntity WHERE MolgenisEntity.name = 'ViewerPlugin';
INSERT INTO MolgenisPermission (role_, entity, permission) SELECT (SELECT id FROM MolgenisRole WHERE name = 'biologist'), id, 'write' FROM MolgenisEntity WHERE MolgenisEntity.name = 'ClusterPlugin';
INSERT INTO MolgenisPermission (role_, entity, permission) SELECT (SELECT id FROM MolgenisRole WHERE name = 'bioinformatician'), id, 'write' FROM MolgenisEntity WHERE MolgenisEntity.name = 'AnalysisSettingsMenu';
INSERT INTO MolgenisPermission (role_, entity, permission) SELECT (SELECT id FROM MolgenisRole WHERE name = 'bioinformatician'), id, 'write' FROM MolgenisEntity WHERE MolgenisEntity.name = 'AnalysisFormController';
INSERT INTO MolgenisPermission (role_, entity, permission) SELECT (SELECT id FROM MolgenisRole WHERE name = 'bioinformatician'), id, 'write' FROM MolgenisEntity WHERE MolgenisEntity.id = (SELECT id FROM MolgenisEntity WHERE className = 'org.molgenis.cluster.Analysis');
INSERT INTO MolgenisPermission (role_, entity, permission) SELECT (SELECT id FROM MolgenisRole WHERE name = 'bioinformatician'), id, 'write' FROM MolgenisEntity WHERE MolgenisEntity.name = 'ParameterSetsFormController';
INSERT INTO MolgenisPermission (role_, entity, permission) SELECT (SELECT id FROM MolgenisRole WHERE name = 'bioinformatician'), id, 'write' FROM MolgenisEntity WHERE MolgenisEntity.id = (SELECT id FROM MolgenisEntity WHERE className = 'org.molgenis.cluster.ParameterSet');
INSERT INTO MolgenisPermission (role_, entity, permission) SELECT (SELECT id FROM MolgenisRole WHERE name = 'bioinformatician'), id, 'write' FROM MolgenisEntity WHERE MolgenisEntity.name = 'ParameterNamesFormController';
INSERT INTO MolgenisPermission (role_, entity, permission) SELECT (SELECT id FROM MolgenisRole WHERE name = 'bioinformatician'), id, 'write' FROM MolgenisEntity WHERE MolgenisEntity.id = (SELECT id FROM MolgenisEntity WHERE className = 'org.molgenis.cluster.ParameterName');
INSERT INTO MolgenisPermission (role_, entity, permission) SELECT (SELECT id FROM MolgenisRole WHERE name = 'bioinformatician'), id, 'write' FROM MolgenisEntity WHERE MolgenisEntity.name = 'ParameterValuesFormController';
INSERT INTO MolgenisPermission (role_, entity, permission) SELECT (SELECT id FROM MolgenisRole WHERE name = 'bioinformatician'), id, 'write' FROM MolgenisEntity WHERE MolgenisEntity.id = (SELECT id FROM MolgenisEntity WHERE className = 'org.molgenis.cluster.ParameterValue');
INSERT INTO MolgenisPermission (role_, entity, permission) SELECT (SELECT id FROM MolgenisRole WHERE name = 'bioinformatician'), id, 'write' FROM MolgenisEntity WHERE MolgenisEntity.name = 'DataSetsFormController';
INSERT INTO MolgenisPermission (role_, entity, permission) SELECT (SELECT id FROM MolgenisRole WHERE name = 'bioinformatician'), id, 'write' FROM MolgenisEntity WHERE MolgenisEntity.id = (SELECT id FROM MolgenisEntity WHERE className = 'org.molgenis.cluster.DataSet');
INSERT INTO MolgenisPermission (role_, entity, permission) SELECT (SELECT id FROM MolgenisRole WHERE name = 'bioinformatician'), id, 'write' FROM MolgenisEntity WHERE MolgenisEntity.name = 'DataNamesFormController';
INSERT INTO MolgenisPermission (role_, entity, permission) SELECT (SELECT id FROM MolgenisRole WHERE name = 'bioinformatician'), id, 'write' FROM MolgenisEntity WHERE MolgenisEntity.id = (SELECT id FROM MolgenisEntity WHERE className = 'org.molgenis.cluster.DataName');
INSERT INTO MolgenisPermission (role_, entity, permission) SELECT (SELECT id FROM MolgenisRole WHERE name = 'bioinformatician'), id, 'write' FROM MolgenisEntity WHERE MolgenisEntity.name = 'DataValuesFormController';
INSERT INTO MolgenisPermission (role_, entity, permission) SELECT (SELECT id FROM MolgenisRole WHERE name = 'bioinformatician'), id, 'write' FROM MolgenisEntity WHERE MolgenisEntity.id = (SELECT id FROM MolgenisEntity WHERE className = 'org.molgenis.cluster.DataValue');
INSERT INTO MolgenisPermission (role_, entity, permission) SELECT (SELECT id FROM MolgenisRole WHERE name = 'bioinformatician'), id, 'write' FROM MolgenisEntity WHERE MolgenisEntity.name = 'RScriptsFormController';
INSERT INTO MolgenisPermission (role_, entity, permission) SELECT (SELECT id FROM MolgenisRole WHERE name = 'bioinformatician'), id, 'write' FROM MolgenisEntity WHERE MolgenisEntity.id = (SELECT id FROM MolgenisEntity WHERE className = 'org.molgenis.cluster.RScript');
INSERT INTO MolgenisPermission (role_, entity, permission) SELECT (SELECT id FROM MolgenisRole WHERE name = 'bioinformatician'), id, 'write' FROM MolgenisEntity WHERE MolgenisEntity.name = 'RViewerPlugin';
INSERT INTO MolgenisPermission (role_, entity, permission) SELECT (SELECT id FROM MolgenisRole WHERE name = 'bioinformatician'), id, 'write' FROM MolgenisEntity WHERE MolgenisEntity.name = 'MatrixWizardPlugin';
INSERT INTO MolgenisPermission (role_, entity, permission) SELECT (SELECT id FROM MolgenisRole WHERE name = 'biologist'), id, 'write' FROM MolgenisEntity WHERE MolgenisEntity.name = 'SearchMenuMenu';
INSERT INTO MolgenisPermission (role_, entity, permission) SELECT (SELECT id FROM MolgenisRole WHERE name = 'biologist'), id, 'write' FROM MolgenisEntity WHERE MolgenisEntity.name = 'SimpleDbSearchPlugin';
INSERT INTO MolgenisPermission (role_, entity, permission) SELECT (SELECT id FROM MolgenisRole WHERE name = 'biologist'), id, 'write' FROM MolgenisEntity WHERE MolgenisEntity.name = 'QtlFinderPublic2Plugin';
INSERT INTO MolgenisPermission (role_, entity, permission) SELECT (SELECT id FROM MolgenisRole WHERE name = 'biologist'), id, 'write' FROM MolgenisEntity WHERE MolgenisEntity.name = 'GenomeBrowserPlugin';
INSERT INTO MolgenisPermission (role_, entity, permission) SELECT (SELECT id FROM MolgenisRole WHERE name = 'biologist'), id, 'write' FROM MolgenisEntity WHERE MolgenisEntity.name = 'OntologiesMenu';
INSERT INTO MolgenisPermission (role_, entity, permission) SELECT (SELECT id FROM MolgenisRole WHERE name = 'biologist'), id, 'write' FROM MolgenisEntity WHERE MolgenisEntity.name = 'ProtocolsFormController';
INSERT INTO MolgenisPermission (role_, entity, permission) SELECT (SELECT id FROM MolgenisRole WHERE name = 'biologist'), id, 'write' FROM MolgenisEntity WHERE MolgenisEntity.id = (SELECT id FROM MolgenisEntity WHERE className = 'org.molgenis.protocol.Protocol');
INSERT INTO MolgenisPermission (role_, entity, permission) SELECT (SELECT id FROM MolgenisRole WHERE name = 'biologist'), id, 'write' FROM MolgenisEntity WHERE MolgenisEntity.name = 'PersonsFormController';
INSERT INTO MolgenisPermission (role_, entity, permission) SELECT (SELECT id FROM MolgenisRole WHERE name = 'biologist'), id, 'write' FROM MolgenisEntity WHERE MolgenisEntity.id = (SELECT id FROM MolgenisEntity WHERE className = 'org.molgenis.auth.Person');
INSERT INTO MolgenisPermission (role_, entity, permission) SELECT (SELECT id FROM MolgenisRole WHERE name = 'biologist'), id, 'write' FROM MolgenisEntity WHERE MolgenisEntity.name = 'InstitutesFormController';
INSERT INTO MolgenisPermission (role_, entity, permission) SELECT (SELECT id FROM MolgenisRole WHERE name = 'biologist'), id, 'write' FROM MolgenisEntity WHERE MolgenisEntity.id = (SELECT id FROM MolgenisEntity WHERE className = 'org.molgenis.auth.Institute');
INSERT INTO MolgenisPermission (role_, entity, permission) SELECT (SELECT id FROM MolgenisRole WHERE name = 'biologist'), id, 'write' FROM MolgenisEntity WHERE MolgenisEntity.name = 'SpeciesFormController';
INSERT INTO MolgenisPermission (role_, entity, permission) SELECT (SELECT id FROM MolgenisRole WHERE name = 'biologist'), id, 'write' FROM MolgenisEntity WHERE MolgenisEntity.id = (SELECT id FROM MolgenisEntity WHERE className = 'org.molgenis.pheno.Species');
INSERT INTO MolgenisPermission (role_, entity, permission) SELECT (SELECT id FROM MolgenisRole WHERE name = 'biologist'), id, 'write' FROM MolgenisEntity WHERE MolgenisEntity.name = 'TissuesFormController';
INSERT INTO MolgenisPermission (role_, entity, permission) SELECT (SELECT id FROM MolgenisRole WHERE name = 'biologist'), id, 'write' FROM MolgenisEntity WHERE MolgenisEntity.id = (SELECT id FROM MolgenisEntity WHERE className = 'org.molgenis.xgap.Tissue');
INSERT INTO MolgenisPermission (role_, entity, permission) SELECT (SELECT id FROM MolgenisRole WHERE name = 'biologist'), id, 'write' FROM MolgenisEntity WHERE MolgenisEntity.name = 'AlternateIdsFormController';
INSERT INTO MolgenisPermission (role_, entity, permission) SELECT (SELECT id FROM MolgenisRole WHERE name = 'biologist'), id, 'write' FROM MolgenisEntity WHERE MolgenisEntity.id = (SELECT id FROM MolgenisEntity WHERE className = 'org.molgenis.pheno.AlternateId');
INSERT INTO MolgenisPermission (role_, entity, permission) SELECT (SELECT id FROM MolgenisRole WHERE name = 'biologist'), id, 'write' FROM MolgenisEntity WHERE MolgenisEntity.name = 'PublicationsFormController';
INSERT INTO MolgenisPermission (role_, entity, permission) SELECT (SELECT id FROM MolgenisRole WHERE name = 'biologist'), id, 'write' FROM MolgenisEntity WHERE MolgenisEntity.id = (SELECT id FROM MolgenisEntity WHERE className = 'org.molgenis.core.Publication');
INSERT INTO MolgenisPermission (role_, entity, permission) SELECT (SELECT id FROM MolgenisRole WHERE name = 'biologist'), id, 'write' FROM MolgenisEntity WHERE MolgenisEntity.name = 'OntologyTermsFormController';
INSERT INTO MolgenisPermission (role_, entity, permission) SELECT (SELECT id FROM MolgenisRole WHERE name = 'biologist'), id, 'write' FROM MolgenisEntity WHERE MolgenisEntity.id = (SELECT id FROM MolgenisEntity WHERE className = 'org.molgenis.core.OntologyTerm');
INSERT INTO MolgenisPermission (role_, entity, permission) SELECT (SELECT id FROM MolgenisRole WHERE name = 'biologist'), id, 'write' FROM MolgenisEntity WHERE MolgenisEntity.name = 'NamingPolicyPlugin';
INSERT INTO MolgenisPermission (role_, entity, permission) SELECT (SELECT id FROM MolgenisRole WHERE name = 'biologist'), id, 'write' FROM MolgenisEntity WHERE MolgenisEntity.name = 'DuplicateRenamingPlugin';
