/*
 * Decompiled with CFR 0.152.
 */
package jfig.utils;

import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import jfig.utils.ExceptionTracer;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SetupManager {
    static SetupManager _setupManager = null;
    static Properties properties;
    static Properties globals;
    static Properties userprops;
    static Properties locals;
    static boolean debug;
    private static final String lo = "abcdefghijklmnopqrstuvwxyz";
    private static final String up = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final String ll = "abcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyz";
    private static final String uu = "ABCDEFGHIJKLMNOPQRSTUVWXYZABCDEFGHIJKLMNOPQRSTUVWXYZ";
    static /* synthetic */ Class class$jfig$utils$SetupManager;

    public static SetupManager getSetupManager() {
        if (_setupManager == null) {
            _setupManager = new SetupManager();
        }
        return _setupManager;
    }

    public static Properties getProperties() {
        return properties;
    }

    public static String getProperty(String string, String string2) {
        return properties.getProperty(string, string2);
    }

    public static String getProperty(String string) {
        return properties.getProperty(string);
    }

    public static int getInteger(String string, int n) {
        String string2 = SetupManager.getProperty(string);
        if (string2 == null) {
            return n;
        }
        try {
            int n2 = Integer.parseInt(string2.trim());
            return n2;
        }
        catch (NumberFormatException numberFormatException) {
            if (debug) {
                numberFormatException.printStackTrace();
            }
            return n;
        }
    }

    public static boolean getBoolean(String string, boolean bl) {
        String string2 = SetupManager.getProperty(string);
        if (string2 == null) {
            return bl;
        }
        if (string2.trim().toLowerCase().equals("true")) {
            return true;
        }
        if (string2.trim().toLowerCase().equals("false")) {
            return false;
        }
        return bl;
    }

    public static double getDouble(String string, double d) {
        String string2 = SetupManager.getProperty(string);
        try {
            return Double.valueOf(string2.trim());
        }
        catch (Exception exception) {
            return d;
        }
    }

    public static Color getColor(String string, Color color) {
        String string2 = SetupManager.getProperty(string);
        if (string2 == null) {
            return color;
        }
        try {
            Color color2 = new Color(Integer.decode(string2));
            return color2;
        }
        catch (Exception exception) {
            SetupManager.message("-E- Illegal Color String '" + string2 + "' for key: " + string);
            return color;
        }
    }

    public static Object getRawProperty(String string) {
        return properties.get(string);
    }

    public static void setProperty(String string, String string2) {
        if (string != null && string2 != null) {
            properties.put(string, string2);
        }
    }

    public static void setBoolean(String string, boolean bl) {
        SetupManager.setProperty(string, bl ? "true" : "false");
    }

    public static void setRawProperty(String string, Object object) {
        properties.put(string, object);
    }

    public static void loadAllProperties(String string) {
        SetupManager.loadGlobalProperties(string);
        SetupManager.loadUserProperties(string);
        SetupManager.loadLocalProperties(string);
    }

    public static void loadGlobalProperties(String string) {
        if (debug) {
            SetupManager.message("-I- loading global props: " + string);
        }
        SetupManager.getSetupManager();
        globals = new Properties();
        InputStream inputStream = null;
        try {
            Class clazz;
            if (!string.startsWith("/")) {
                string = "/" + string;
            }
            if ((clazz = class$jfig$utils$SetupManager) == null) {
                clazz = class$jfig$utils$SetupManager = SetupManager.class("[Ljfig.utils.SetupManager;", false);
            }
            inputStream = clazz.getResourceAsStream(string);
            globals.load(inputStream);
        }
        catch (Exception exception) {
            ExceptionTracer.message("-W- Couldn't load global properties from '" + string + '\'');
        }
        SetupManager.merge(properties, globals);
    }

    public static void loadUserProperties(String string) {
        SetupManager.getSetupManager();
        userprops = new Properties();
        FileInputStream fileInputStream = null;
        String string2 = null;
        try {
            string2 = properties.getProperty("user.home") + properties.getProperty("file.separator") + string;
            if (debug) {
                SetupManager.message("-I- loading user props: " + string2);
            }
            fileInputStream = new FileInputStream(string2);
            userprops.load(fileInputStream);
            fileInputStream.close();
        }
        catch (Exception exception) {
            ExceptionTracer.message("-W- Couldn't load user properties from '" + string2 + '\'');
        }
        SetupManager.merge(properties, userprops);
    }

    public static void loadLocalProperties(String string) {
        SetupManager.getSetupManager();
        FileInputStream fileInputStream = null;
        String string2 = null;
        try {
            string2 = properties.getProperty("user.dir") + properties.getProperty("file.separator") + string;
            if (debug) {
                SetupManager.message("-I- loading local props: " + string2);
            }
            fileInputStream = new FileInputStream(string2);
            SetupManager.loadProperties(fileInputStream);
        }
        catch (Exception exception) {
            ExceptionTracer.message("-W- Couldn't load local properties from stream '" + string2 + '\'');
        }
    }

    public static void loadExtensionDirProperties(String string) {
        String string2 = null;
        try {
            string2 = System.getProperty("java.ext.dirs") + File.separator + string;
            if (new File(string2).exists()) {
                FileInputStream fileInputStream = new FileInputStream(string2);
                SetupManager.loadProperties(fileInputStream);
            }
        }
        catch (Exception exception) {
            ExceptionTracer.message("-W- Couldn't load local properties from stream '" + string2 + '\'');
        }
    }

    public static void loadProperties(File file) {
        if (file == null) {
            return;
        }
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            return;
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            SetupManager.loadProperties(fileInputStream);
        }
        catch (Exception exception) {
            ExceptionTracer.message("-W- Couldn't load local properties from File '" + file + '\'');
        }
    }

    public static void loadProperties(InputStream inputStream) {
        locals = new Properties();
        try {
            locals.load(inputStream);
            inputStream.close();
        }
        catch (Exception exception) {
            ExceptionTracer.message("-W- Couldn't load local properties from stream '" + inputStream + '\'');
        }
        SetupManager.merge(properties, locals);
    }

    public static void loadURLProperties(String string) {
        SetupManager.getSetupManager();
        locals = new Properties();
        try {
            URL uRL = new URL(string);
            uRL.openConnection();
            InputStream inputStream = uRL.openStream();
            locals.load(inputStream);
            inputStream.close();
        }
        catch (Exception exception) {
            ExceptionTracer.message("-W- got: " + exception);
            ExceptionTracer.message("-W- Couldn't load properties from '" + string + '\'');
        }
        SetupManager.merge(properties, locals);
    }

    public static void save(OutputStream outputStream, String string) {
        try {
            properties.store(outputStream, string);
        }
        catch (Exception exception) {
            SetupManager.message("-E- Failed to save the properties: " + exception);
            exception.printStackTrace();
        }
    }

    public static void saveUserProperties(String string, String string2) {
        block2: {
            FileOutputStream fileOutputStream = null;
            String string3 = null;
            try {
                string3 = string2;
                fileOutputStream = new FileOutputStream(string3);
                Properties properties = new Properties();
                SetupManager.merge(properties, userprops);
                SetupManager.merge(properties, locals);
                properties.store(fileOutputStream, string);
                fileOutputStream.flush();
                ((OutputStream)fileOutputStream).close();
                SetupManager.message("-I- Saved setup to file '" + string3 + '\'');
            }
            catch (Exception exception) {
                if (!debug) break block2;
                SetupManager.message("-W- Couldn't load local properties from '" + string3 + '\'');
                SetupManager.message("-W- loadLocalProperites: " + exception);
            }
        }
    }

    public static void saveLocalProperties(String string, String string2) {
        FileOutputStream fileOutputStream = null;
        String string3 = null;
        try {
            string3 = SetupManager.getProperty("user.dir") + SetupManager.getProperty("file.separator") + string2;
            fileOutputStream = new FileOutputStream(string3);
            Properties properties = new Properties();
            SetupManager.merge(properties, userprops);
            SetupManager.merge(properties, locals);
            properties.store(fileOutputStream, string);
            fileOutputStream.flush();
            ((OutputStream)fileOutputStream).close();
            SetupManager.message("-I- Saved setup to file '" + string3 + '\'');
        }
        catch (Exception exception) {
            SetupManager.message("-E- Couldn't load local properties from '" + string3 + '\'');
            SetupManager.message("-E- loadLocalProperites: " + exception);
        }
    }

    public static void merge(Properties properties, Properties properties2) {
        String string = null;
        Enumeration<?> enumeration = properties2.propertyNames();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            properties.put(string, properties2.getProperty(string));
        }
    }

    public static void list(PrintStream printStream) {
        printStream.println(SetupManager.getSetupManager().toString() + '[');
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            printStream.println(string + ' ' + SetupManager.getProperty(string));
        }
        printStream.println("]");
    }

    public static void message(String string) {
        System.out.println(string);
    }

    public static String rot13(String string) {
        return SetupManager.rotx(string, 13);
    }

    public static String rotx(String string, int n) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if ((n %= 26) < 0) {
            n += 26;
        }
        int n2 = string.length();
        int n3 = 0;
        while (n3 < n2) {
            char c = string.charAt(n3);
            if (c >= 'A' && c <= 'Z') {
                stringBuffer.append(ll.charAt(c - 65 + n));
            } else if (c >= 'a' && c <= 'z') {
                stringBuffer.append(uu.charAt(c - 97 + n));
            } else {
                stringBuffer.append(c);
            }
            ++n3;
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return "jfig.gui.SetupManager";
    }

    public static void main(String[] stringArray) {
        SetupManager.message("SetupManager selftest...");
        SetupManager setupManager = SetupManager.getSetupManager();
        SetupManager.loadAllProperties("jfig.cnf");
        SetupManager.list(System.out);
        SetupManager.message("Saving user Properties...");
        SetupManager.saveUserProperties("jfig setup variables", "hugo.conf");
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    /*
     * Unable to fully structure code
     */
    private SetupManager() {
        block9: {
            super();
            try {
                var1_1 = System.getSecurityManager();
                if (var1_1 != null) {
                    var1_1.checkPropertiesAccess();
                }
                SetupManager.properties = System.getProperties();
                if (SetupManager.debug) {
                    SetupManager.message("-I- loaded system properties.");
                }
            }
            catch (SecurityException var1_2) {
                SetupManager.properties = new Properties();
                var2_4 = new String[]{"java.version", "java.vendor", "java.vendor.url", "java.class.version", "os.name", "os.arch", "or.version", "file.separator", "path.separator", "line.separator"};
                var3_5 = 0;
                ** while (var3_5 < var2_4.length)
            }
lbl-1000:
            // 1 sources

            {
                try {
                    SetupManager.properties.put(var2_4[var3_5], System.getProperty(var2_4[var3_5]));
                }
                catch (SecurityException v0) {}
                ++var3_5;
                continue;
            }
lbl22:
            // 1 sources

            if (SetupManager.debug) {
                SetupManager.message("-I- created empty system properties.");
            }
            break block9;
            catch (Throwable var1_3) {
                SetupManager.properties = new Properties();
                if (!SetupManager.debug) break block9;
                SetupManager.message("-I- created empty system properties.");
            }
        }
    }

    static {
        debug = false;
        SetupManager.getSetupManager();
    }
}

