/*
 * Decompiled with CFR 0.152.
 */
package jfig.utils;

import jfig.objects.Point;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class GeometryManager {
    public static final int UNCONSTRAINED = 0;
    public static final int LATEX_LINE = 1;
    public static final int LATEX_VECTOR = 2;
    public static final int MANHATTAN = 3;
    public static final int MOUNTAIN = 4;
    public static final int MOUNTHATTAN = 5;
    public static final String[] names = new String[]{"Unconstrained", "Latex Line", "Latex Vector", "Manhattan", "Mountain", "Mount-hattan"};
    private static final double[] latex_line_angles;
    private static final double[] latex_vector_angles;
    private static final double[] manhattan_angles;
    private static final double[] mountain_angles;
    private static final double[] mounthattan_angles;
    private int mode;

    public void setMode(int n) throws IllegalArgumentException {
        if (n < 0 || n > 5) {
            throw new IllegalArgumentException("Unknown geometry mode: " + n);
        }
        this.mode = n;
    }

    public int getMode() {
        return this.mode;
    }

    public Point getNearestAllowedPoint(Point point, Point point2) {
        switch (this.mode) {
            case 0: {
                return point2;
            }
            case 1: {
                return this._get(point, point2, latex_line_angles);
            }
            case 2: {
                return this._get(point, point2, latex_vector_angles);
            }
            case 3: {
                return this.getNearestManhattanPoint(point, point2);
            }
            case 4: {
                return this._get(point, point2, mountain_angles);
            }
            case 5: {
                return this._get(point, point2, mounthattan_angles);
            }
        }
        System.out.println("-E- GeometryManager: unsupported mode: " + this.mode);
        return point2;
    }

    public Point getNearestManhattanPoint(Point point, Point point2) {
        double d = point2.x - point.x;
        double d2 = point2.y - point.y;
        if (Math.abs(d) > Math.abs(d2)) {
            return new Point(point2.x, point.y);
        }
        return new Point(point.x, point2.y);
    }

    private final Point _get(Point point, Point point2, double[] dArray) {
        double d = point2.x - point.x;
        double d2 = point2.y - point.y;
        double d3 = 0.0;
        d3 = Math.abs(d) > Math.abs(d2) ? Math.abs(d2 / d) : Math.abs(d / d2);
        double d4 = 13.0;
        double d5 = 42.0;
        int n = 0;
        int n2 = 0;
        while (n2 < dArray.length) {
            d4 = Math.abs(d3 - dArray[n2]);
            if (d4 < d5) {
                d5 = d4;
                n = n2;
            }
            ++n2;
        }
        if (Math.abs(d) > Math.abs(d2)) {
            double d6 = Math.abs(d) * dArray[n] + 0.5;
            if (d2 < 0.0) {
                d6 = -d6;
            }
            return new Point(point2.x, point.y + (double)((int)d6));
        }
        double d7 = Math.abs(d2) * dArray[n] + 0.5;
        if (d < 0.0) {
            d7 = -d7;
        }
        return new Point(point.x + (double)((int)d7), point2.y);
    }

    public void convertToRadians(double[] dArray) {
        if (dArray == null) {
            return;
        }
        double d = Math.PI / 180;
        int n = 0;
        while (n < dArray.length) {
            dArray[n] = d * dArray[n];
            ++n;
        }
    }

    public void convertToDegrees(double[] dArray) {
        if (dArray == null) {
            return;
        }
        double d = 57.29577951308232;
        int n = 0;
        while (n < dArray.length) {
            dArray[n] = d * dArray[n];
            ++n;
        }
    }

    private final /* synthetic */ void this() {
        this.mode = 0;
    }

    public GeometryManager() {
        this.this();
    }

    static {
        double[] dArray = new double[13];
        dArray[1] = 0.16666666666666666;
        dArray[2] = 0.2;
        dArray[3] = 0.25;
        dArray[4] = 0.3333333333333333;
        dArray[5] = 0.4;
        dArray[6] = 0.5;
        dArray[7] = 0.6;
        dArray[8] = 0.6666666666666666;
        dArray[9] = 0.75;
        dArray[10] = 0.8;
        dArray[11] = 0.8333333333333334;
        dArray[12] = 1.0;
        latex_line_angles = dArray;
        double[] dArray2 = new double[7];
        dArray2[1] = 0.25;
        dArray2[2] = 0.3333333333333333;
        dArray2[3] = 0.5;
        dArray2[4] = 0.6666666666666666;
        dArray2[5] = 0.75;
        dArray2[6] = 1.0;
        latex_vector_angles = dArray2;
        manhattan_angles = new double[1];
        mountain_angles = new double[]{1.0};
        double[] dArray3 = new double[2];
        dArray3[1] = 1.0;
        mounthattan_angles = dArray3;
    }
}

