/*
 * Decompiled with CFR 0.152.
 */
package jfig.objects;

import jfig.objects.FigAttribs;
import jfig.objects.FigObject;
import jfig.objects.FigObjectFactory;
import jfig.objects.FigObjectVisitor;
import jfig.objects.FigPolyline;
import jfig.objects.Point;
import jfig.utils.SetupManager;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class FigXSpline
extends FigPolyline {
    protected double[] sfactors;
    protected Point[] wcp_spline;
    private int _npoints;
    private double[] _x;
    private double[] _y;
    final double LOW_PRECISION = 1.0;
    final double HIGH_PRECISION = 0.5;
    final double MAX_SPLINE_STEP = 0.2;
    private double precision;
    private double spline_step;

    public void createRenderer() {
        this.buildSpline();
        this.renderer = FigObjectFactory.getDefaultObjectFactory().createXSplineRenderer(this);
        this.update_bbox();
        this.needsRebuild = false;
    }

    public void createSfactors() {
        this.sfactors = new double[this.wcp.length];
        int n = 0;
        while (n < this.sfactors.length) {
            this.sfactors[n] = 1.0;
            ++n;
        }
        if (!this.is_closed) {
            this.sfactors[0] = 0.0;
            this.sfactors[this.sfactors.length - 1] = 0.0;
        }
        this.needsRebuild = true;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("FigXSpline with " + this.wcp.length + " control points: ");
        int n = 0;
        while (n < this.wcp.length) {
            stringBuffer.append("( " + this.wcp[n].x + ", " + this.wcp[n].y + "), ");
            ++n;
        }
        return stringBuffer.toString();
    }

    public void buildSpline() {
        this.wcp_spline = new Point[0];
        this._npoints = 0;
        if (this.sfactors == null || this.wcp.length != this.sfactors.length) {
            this.createSfactors();
        }
        if (this.wcp.length > 2) {
            this.precision = SetupManager.getDouble("jfig.objects.FigXSpline.precision", 0.5);
            this.spline_step = SetupManager.getDouble("jfig.objecs.FigXSpline.stepsize", 0.2);
            if (this.is_closed) {
                this.compute_closed_spline();
            } else {
                this.compute_open_spline();
            }
            this.wcp_spline = this.getComputedPointArray();
        } else {
            this.wcp_spline = this.wcp.length == 2 ? new Point[]{this.wcp[0], this.wcp[1]} : new Point[]{this.wcp[0]};
        }
    }

    public void setPoints(Point[] pointArray) {
        Point[] pointArray2 = new Point[pointArray.length];
        int n = 0;
        while (n < pointArray.length) {
            pointArray2[n] = new Point(pointArray[n].x, pointArray[n].y);
            ++n;
        }
        this.wcp = pointArray2;
        this.createSfactors();
        this.update_bbox();
        this.needsRebuild = true;
    }

    public double[] getSFactors() {
        return this.sfactors;
    }

    public void setSFactors(double[] dArray) {
        if (dArray.length != this.wcp.length) {
            System.err.println("-E- FigXSpline.setSFactors: length mismatch! " + dArray.length + " vs " + this.wcp.length);
            this.createSfactors();
            return;
        }
        this.sfactors = dArray;
        this.needsRebuild = true;
    }

    public Point[] getSplinePoints() {
        return this.wcp_spline;
    }

    public void dumpXsplinePoints() {
        if (this.wcp_spline == null) {
            System.out.println("xspline interpolated points still null.");
            return;
        }
        int n = this.wcp_spline.length;
        System.out.println("-#- dXPoints: " + n);
        int n2 = 0;
        while (n2 < n) {
            System.out.println("   " + this.wcp_spline[n2]);
            ++n2;
        }
    }

    public void dumpSfactors() {
        if (this.sfactors == null) {
            System.out.println("-#- dXSfactors: NULL");
            return;
        }
        System.out.println("-#- dXSfactors: " + this.getClass().getName());
        int n = 0;
        while (n < this.sfactors.length) {
            System.out.println("   " + this.sfactors[n]);
            ++n;
        }
    }

    public void appendPoint(Point point) {
        super.appendPoint(point);
        this.createSfactors();
    }

    public Point deletePoint(Point point) {
        Point point2 = super.deletePoint(point);
        this.createSfactors();
        return point2;
    }

    public FigObject copy() {
        if (this.debug) {
            this.message("FigXSpline.copy()...");
        }
        FigXSpline figXSpline = new FigXSpline(this.wcp[0].x, this.wcp[0].y, this.is_closed, this.attribs.getClone());
        figXSpline.setPoints(this.getPoints());
        return figXSpline;
    }

    public Point[] getComputedPointArray() {
        Point[] pointArray = new Point[this._npoints];
        int n = 0;
        while (n < this._npoints) {
            pointArray[n] = new Point(this._x[n], this._y[n]);
            ++n;
        }
        return pointArray;
    }

    public void compute_open_spline() {
        Point[] pointArray = this.wcp;
        if (pointArray.length > 3) {
            Point point = pointArray[0];
            double d = this.sfactors[0];
            Point point2 = pointArray[0];
            double d2 = this.sfactors[0];
            Point point3 = pointArray[1];
            double d3 = this.sfactors[1];
            Point point4 = pointArray[2];
            double d4 = this.sfactors[2];
            int n = 0;
            int n2 = pointArray.length - 3;
            n = 0;
            while (true) {
                this.spline_segment_loop(n, point, point2, point3, point4, d2, d3, this.precision);
                if (n >= n2) break;
                point = point2;
                d = d2;
                point2 = point3;
                d2 = d3;
                point3 = point4;
                d3 = d4;
                point4 = pointArray[n + 3];
                d4 = this.sfactors[n + 3];
                ++n;
            }
            point = point2;
            d = d2;
            point2 = point3;
            d2 = d3;
            point3 = point4;
            d3 = d4;
            this.spline_segment_loop(n + 1, point, point2, point3, point4, d2, d3, this.precision);
            this.addPoint(pointArray[pointArray.length - 1].x, pointArray[pointArray.length - 1].y);
        } else if (pointArray.length == 3) {
            Point point = pointArray[0];
            Point point5 = pointArray[0];
            Point point6 = pointArray[1];
            Point point7 = pointArray[2];
            double d = this.sfactors[0];
            double d5 = this.sfactors[1];
            this.spline_segment_loop(0, point, point5, point6, point7, d, d5, this.precision);
            point = pointArray[0];
            point5 = pointArray[1];
            point6 = pointArray[2];
            point7 = pointArray[2];
            d = this.sfactors[1];
            d5 = this.sfactors[2];
            this.spline_segment_loop(1, point, point5, point6, point7, d, d5, this.precision);
            this.addPoint(pointArray[pointArray.length - 1].x, pointArray[pointArray.length - 1].y);
        }
    }

    public void compute_closed_spline() {
        double d;
        Point point;
        Point[] pointArray = this.wcp;
        Point point2 = pointArray[0];
        double d2 = this.sfactors[0];
        Point point3 = pointArray[1];
        double d3 = this.sfactors[1];
        Point point4 = pointArray[2];
        double d4 = this.sfactors[2];
        if (pointArray.length == 3) {
            point = pointArray[0];
            d = this.sfactors[0];
        } else {
            point = pointArray[3];
            d = this.sfactors[3];
        }
        int n = 0;
        int n2 = pointArray.length - 4;
        if (pointArray.length > 3) {
            n = 0;
            while (true) {
                this.spline_segment_loop(n, point2, point3, point4, point, d3, d4, this.precision);
                if (n >= n2) break;
                point2 = point3;
                d2 = d3;
                point3 = point4;
                d3 = d4;
                point4 = point;
                d4 = d;
                point = pointArray[n + 4];
                d = this.sfactors[n + 4];
                ++n;
            }
            point2 = point3;
            d2 = d3;
            point3 = point4;
            d3 = d4;
            point4 = point;
            d4 = d;
            point = pointArray[0];
            d = this.sfactors[0];
            this.spline_segment_loop(n, point2, point3, point4, point, d3, d4, this.precision);
            point2 = point3;
            d2 = d3;
            point3 = point4;
            d3 = d4;
            point4 = point;
            d4 = d;
            point = pointArray[1];
            d = this.sfactors[1];
            this.spline_segment_loop(n, point2, point3, point4, point, d3, d4, this.precision);
            point2 = point3;
            d2 = d3;
            point3 = point4;
            d3 = d4;
            point4 = point;
            d4 = d;
            point = pointArray[2];
            d = this.sfactors[2];
            this.spline_segment_loop(n, point2, point3, point4, point, d3, d4, this.precision);
        } else {
            point2 = pointArray[0];
            d2 = this.sfactors[0];
            point3 = pointArray[1];
            d3 = this.sfactors[1];
            point4 = pointArray[2];
            d4 = this.sfactors[2];
            this.spline_segment_loop(0, point2, point3, point4, point2, d3, d4, this.precision);
            this.spline_segment_loop(0, point3, point4, point2, point3, d4, d2, this.precision);
            this.spline_segment_loop(0, point4, point2, point3, point4, d2, d3, this.precision);
        }
        this.addPoint(this._x[0], this._y[0]);
    }

    private final void spline_segment_loop(int n, Point point, Point point2, Point point3, Point point4, double d, double d2, double d3) {
        double d4 = this.step_computing(n, point, point2, point3, point4, d, d2, d3);
        this.spline_segment_computing(d4, n, point, point2, point3, point4, d, d2);
    }

    private final double step_computing(int n, Point point, Point point2, Point point3, Point point4, double d, double d2, double d3) {
        double d4;
        double d5;
        double d6;
        double d7;
        if (d == 0.0 && d2 == 0.0) {
            return 1.0;
        }
        Point point5 = new Point(0.0, 0.0);
        Point point6 = new Point(0.0, 0.0);
        Point point7 = new Point(0.0, 0.0);
        double d8 = 0.0;
        if (d > 0.0) {
            if (d2 < 0.0) {
                d7 = this.positive_s1_influence_a0(n, 0.0, d);
                d6 = this.positive_s1_influence_a2(n, 0.0, d);
                d5 = this.g_blend(1.0, this.Q(d2));
                d4 = this.h_blend(-1.0, this.Q(d2));
            } else {
                d7 = this.positive_s1_influence_a0(n, 0.0, d);
                d6 = this.positive_s1_influence_a2(n, 0.0, d);
                d5 = this.positive_s2_influence_a1(n, 0.0, d2);
                d4 = this.positive_s2_influence_a3(n, 0.0, d2);
            }
            this.point_computing(d7, d5, d6, d4, point, point2, point3, point4, point5);
        } else {
            point5.x = point2.x;
            point5.y = point2.y;
        }
        if (d2 > 0.0) {
            if (d < 0.0) {
                d7 = this.h_blend(-1.0, this.Q(d));
                d6 = this.g_blend(1.0, this.Q(d));
                d5 = this.positive_s2_influence_a1(n, 1.0, d2);
                d4 = this.positive_s2_influence_a3(n, 1.0, d2);
            } else {
                d7 = this.positive_s1_influence_a0(n, 1.0, d);
                d6 = this.positive_s1_influence_a2(n, 1.0, d);
                d5 = this.positive_s2_influence_a1(n, 1.0, d2);
                d4 = this.positive_s2_influence_a3(n, 1.0, d2);
            }
            this.point_computing(d7, d5, d6, d4, point, point2, point3, point4, point6);
        } else {
            point6.x = point3.x;
            point6.y = point3.y;
        }
        if (d2 > 0.0) {
            if (d < 0.0) {
                d7 = this.h_blend(-0.5, this.Q(d));
                d6 = this.g_blend(0.5, this.Q(d));
                d5 = this.positive_s2_influence_a1(n, 0.5, d2);
                d4 = this.positive_s2_influence_a3(n, 0.5, d2);
            } else {
                d7 = this.positive_s1_influence_a0(n, 0.5, d);
                d6 = this.positive_s1_influence_a2(n, 0.5, d);
                d5 = this.positive_s2_influence_a1(n, 0.5, d2);
                d4 = this.positive_s2_influence_a3(n, 0.5, d2);
            }
        } else if (d < 0.0) {
            d7 = this.h_blend(-0.5, this.Q(d));
            d6 = this.g_blend(0.5, this.Q(d));
            d5 = this.g_blend(0.5, this.Q(d2));
            d4 = this.h_blend(-0.5, this.Q(d2));
        } else {
            d7 = this.positive_s1_influence_a0(n, 0.5, d);
            d6 = this.positive_s1_influence_a2(n, 0.5, d);
            d5 = this.g_blend(0.5, this.Q(d2));
            d4 = this.h_blend(-0.5, this.Q(d2));
        }
        this.point_computing(d7, d5, d6, d4, point, point2, point3, point4, point7);
        double d9 = point5.x - point7.x;
        double d10 = point5.y - point7.y;
        double d11 = point6.x - point7.x;
        double d12 = point6.y - point7.y;
        double d13 = d9 * d11 + d10 * d12;
        double d14 = Math.sqrt((d9 * d9 + d10 * d10) * (d11 * d11 + d12 * d12));
        double d15 = d14 == 0.0 ? 0.0 : d13 / d14;
        double d16 = point6.x - point5.x;
        double d17 = point6.y - point5.y;
        double d18 = Math.sqrt(d16 * d16 + d17 * d17);
        double d19 = Math.sqrt(d18) / (double)2;
        d8 = (d19 += (double)((int)((1.0 + d15) * 10.0))) == 0.0 ? 1.0 : d3 / d19;
        if (d8 > this.spline_step || d8 == 0.0) {
            d8 = this.spline_step;
        }
        return d8;
    }

    private final void spline_segment_computing(double d, int n, Point point, Point point2, Point point3, Point point4, double d2, double d3) {
        if (d2 < 0.0) {
            if (d3 < 0.0) {
                double d4 = 0.0;
                while (d4 < 1.0) {
                    double d5 = this.h_blend(-d4, this.Q(d2));
                    double d6 = this.g_blend(d4, this.Q(d2));
                    double d7 = this.g_blend(1.0 - d4, this.Q(d3));
                    double d8 = this.h_blend(d4 - 1.0, this.Q(d3));
                    this.point_adding(d5, d7, d6, d8, point, point2, point3, point4);
                    d4 += d;
                }
            } else {
                double d9 = 0.0;
                while (d9 < 1.0) {
                    double d10 = this.h_blend(-d9, this.Q(d2));
                    double d11 = this.g_blend(d9, this.Q(d2));
                    double d12 = this.positive_s2_influence_a1(n, d9, d3);
                    double d13 = this.positive_s2_influence_a3(n, d9, d3);
                    this.point_adding(d10, d12, d11, d13, point, point2, point3, point4);
                    d9 += d;
                }
            }
        } else if (d3 < 0.0) {
            double d14 = 0.0;
            while (d14 < 1.0) {
                double d15 = this.positive_s1_influence_a0(n, d14, d2);
                double d16 = this.positive_s1_influence_a2(n, d14, d2);
                double d17 = this.g_blend(1.0 - d14, this.Q(d3));
                double d18 = this.h_blend(d14 - 1.0, this.Q(d3));
                this.point_adding(d15, d17, d16, d18, point, point2, point3, point4);
                d14 += d;
            }
        } else {
            double d19 = 0.0;
            while (d19 < 1.0) {
                double d20 = this.positive_s1_influence_a0(n, d19, d2);
                double d21 = this.positive_s1_influence_a2(n, d19, d2);
                double d22 = this.positive_s2_influence_a1(n, d19, d3);
                double d23 = this.positive_s2_influence_a3(n, d19, d3);
                this.point_adding(d20, d22, d21, d23, point, point2, point3, point4);
                d19 += d;
            }
        }
    }

    private final double Q(double d) {
        return -d;
    }

    private final double f_blend(double d, double d2) {
        double d3 = (double)2 * d2 * d2;
        double d4 = d / d2;
        double d5 = d4 * d4;
        return d4 * d5 * (10.0 - d3 + ((double)2 * d3 - 15.0) * d4 + (6.0 - d3) * d5);
    }

    private final double g_blend(double d, double d2) {
        return d * (d2 + d * ((double)2 * d2 + d * (8.0 - 12.0 * d2 + d * (14.0 * d2 - 11.0 + d * ((double)4 - (double)5 * d2)))));
    }

    private final double h_blend(double d, double d2) {
        double d3 = d * d;
        return d * (d2 + d * ((double)2 * d2 + d3 * (-2.0 * d2 - d * d2)));
    }

    private final double positive_s1_influence_a0(int n, double d, double d2) {
        double d3 = (double)(n + 1) + d2;
        return d + (double)n + 1.0 < d3 ? this.f_blend(d + (double)n + 1.0 - d3, (double)n - d3) : 0.0;
    }

    private final double positive_s1_influence_a2(int n, double d, double d2) {
        double d3 = (double)(n + 1) - d2;
        return this.f_blend(d + (double)n + 1.0 - d3, (double)(n + 2) - d3);
    }

    private final double positive_s2_influence_a1(int n, double d, double d2) {
        double d3 = (double)(n + 2) + d2;
        return this.f_blend(d + (double)n + 1.0 - d3, (double)(n + 1) - d3);
    }

    private final double positive_s2_influence_a3(int n, double d, double d2) {
        double d3 = (double)(n + 2) - d2;
        return d + (double)n + 1.0 > d3 ? this.f_blend(d + (double)n + 1.0 - d3, (double)(n + 3) - d3) : 0.0;
    }

    private final void point_adding(double d, double d2, double d3, double d4, Point point, Point point2, Point point3, Point point4) {
        double d5 = d + d2 + d3 + d4;
        double d6 = d * point.x + d2 * point2.x + d3 * point3.x + d4 * point4.x;
        double d7 = d * point.y + d2 * point2.y + d3 * point3.y + d4 * point4.y;
        this.addPoint(Math.round(d6 / d5), Math.round(d7 / d5));
    }

    private final void point_computing(double d, double d2, double d3, double d4, Point point, Point point2, Point point3, Point point4, Point point5) {
        double d5 = d + d2 + d3 + d4;
        double d6 = d * point.x + d2 * point2.x + d3 * point3.x + d4 * point4.x;
        double d7 = d * point.y + d2 * point2.y + d3 * point3.y + d4 * point4.y;
        point5.x = Math.round(d6 / d5);
        point5.y = Math.round(d7 / d5);
    }

    private final void addPoint(double d, double d2) {
        if (this._npoints == 0) {
            this._x = new double[300];
            this._y = new double[300];
        } else if (this._npoints >= this._x.length) {
            double[] dArray = new double[2 * this._x.length];
            double[] dArray2 = new double[2 * this._y.length];
            int n = 0;
            while (n < this._x.length) {
                dArray[n] = this._x[n];
                dArray2[n] = this._y[n];
                ++n;
            }
            this._x = dArray;
            this._y = dArray2;
        }
        if (this._npoints > 0 && d == this._x[this._npoints - 1] && d2 == this._y[this._npoints - 1]) {
            return;
        }
        this._x[this._npoints] = d;
        this._y[this._npoints] = d2;
        ++this._npoints;
    }

    public void accept(FigObjectVisitor figObjectVisitor) {
        figObjectVisitor.visit(this);
    }

    private final /* synthetic */ void this() {
        this.precision = 0.5;
        this.spline_step = 0.2;
    }

    public FigXSpline() {
        this(0.0, 0.0, false, new FigAttribs());
    }

    public FigXSpline(double d, double d2, FigAttribs figAttribs) {
        this(d, d2, false, figAttribs);
    }

    public FigXSpline(double d, double d2, boolean bl, FigAttribs figAttribs) {
        super(d, d2, bl, figAttribs);
        this.this();
        this.min_num_points = bl ? 3 : 2;
        this.createSfactors();
    }
}

