/*
 * Decompiled with CFR 0.152.
 */
package jfig.objects;

import java.awt.Color;
import java.io.DataOutputStream;
import java.io.PrintWriter;
import java.util.StringTokenizer;
import jfig.gui.ColorCache;
import jfig.objects.FigArc;
import jfig.objects.FigAttribs;
import jfig.objects.FigBbox;
import jfig.objects.FigBezier;
import jfig.objects.FigBezierXSpline;
import jfig.objects.FigCompound;
import jfig.objects.FigEllipse;
import jfig.objects.FigGeneralXSpline;
import jfig.objects.FigImage;
import jfig.objects.FigNormalXSpline;
import jfig.objects.FigObject;
import jfig.objects.FigObjectList;
import jfig.objects.FigPolyline;
import jfig.objects.FigPrintWriter;
import jfig.objects.FigRectangle;
import jfig.objects.FigSpline;
import jfig.objects.FigText;
import jfig.objects.FigXSpline;
import jfig.objects.ListNode;
import jfig.objects.Point;
import jfig.utils.ExceptionTracer;
import jfig.utils.Format;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class FigWriter {
    final int FORWARD = 1;
    final int BACKWARD = 2;
    boolean debug;
    int line_number;
    int n_errors;
    ColorCache colorCache;
    double resolution;
    double scale_factor;
    protected FigObject currentObject;
    private Format _Format2;
    private Format _Format4;
    Format styleValFormat;
    static /* synthetic */ Class class$jfig$objects$FigPolyline;

    public void set_debug() {
        this.debug = true;
    }

    public void reset_debug() {
        this.debug = false;
    }

    public void setResolution(int n) {
        this.resolution = n;
        this.scale_factor = this.resolution / 2400.0;
    }

    public int getLineStyle(FigAttribs figAttribs) {
        return figAttribs.lineStyle;
    }

    public int getLineThickness(int n) {
        if (n < 0) {
            return 0;
        }
        if (n == 0) {
            return 0;
        }
        if (n < 30) {
            return 1;
        }
        return n / 30;
    }

    public int getLineThickness(double d) {
        if (d < 0.0) {
            return 0;
        }
        if (d == 0.0) {
            return 0;
        }
        if (d < 30.0) {
            return 1;
        }
        return (int)(d / 30.0);
    }

    public int getLineColorIndex(FigAttribs figAttribs) {
        return figAttribs.fig_line_color;
    }

    public int getFillColorIndex(FigAttribs figAttribs) {
        if (figAttribs.fig_fill_color == -1) {
            ExceptionTracer.message("FigWriter.getFillColorIndex(): fig_fill_color=-1");
        }
        return figAttribs.fig_fill_color;
    }

    public int getDepth(FigAttribs figAttribs) {
        if (figAttribs.currentLayer <= 0) {
            return 0;
        }
        if (figAttribs.currentLayer > 999) {
            return 999;
        }
        return figAttribs.currentLayer;
    }

    public int getPenStyle(FigAttribs figAttribs) {
        return figAttribs.fig_pen_style;
    }

    public int getAreaFill(FigAttribs figAttribs) {
        if (figAttribs.fillStyle == 2) {
            return figAttribs.fig_area_fill;
        }
        if (figAttribs.fillStyle == 3) {
            return figAttribs.fig_area_fill;
        }
        return -1;
    }

    public String getStyleVal(FigAttribs figAttribs) {
        if (figAttribs.dashLength == 0.0) {
            return " 0 ";
        }
        return this.styleValFormat.form(figAttribs.dashLength / 30.0);
    }

    public int getJoinStyle(FigAttribs figAttribs) {
        return figAttribs.fig_join_style;
    }

    public int getCapStyle(FigAttribs figAttribs) {
        return figAttribs.fig_cap_style;
    }

    public int getRadius(FigAttribs figAttribs) {
        if (figAttribs.cornerRadius <= 0.0) {
            return 0;
        }
        if (figAttribs.cornerRadius < 30.0) {
            return 1;
        }
        return (int)(figAttribs.cornerRadius / 30.0);
    }

    public int getForwardArrowFlag(FigAttribs figAttribs) {
        if ((figAttribs.arrowMode & 1) > 0) {
            return 1;
        }
        return 0;
    }

    public int getBackwardArrowFlag(FigAttribs figAttribs) {
        if ((figAttribs.arrowMode & 2) > 0) {
            return 1;
        }
        return 0;
    }

    public int getEllipseDirection(FigAttribs figAttribs) {
        return 1;
    }

    public double getEllipseAngle(FigAttribs figAttribs) {
        return figAttribs.fig_angle;
    }

    public int getFont(FigAttribs figAttribs) {
        return figAttribs.fig_font;
    }

    public double getFontSize(FigAttribs figAttribs) {
        return figAttribs.fontSize;
    }

    public double getFontAngle(FigAttribs figAttribs) {
        return figAttribs.fig_angle;
    }

    public int getFontFlags(FigAttribs figAttribs) {
        return figAttribs.fig_font_flags;
    }

    public double getTextHeight(FigText figText) {
        return this.fig_scale(figText.getBbox().getYb() - figText.getBbox().getYt());
    }

    public double getTextLength(FigText figText) {
        return this.fig_scale(figText.getBbox().getXr() - figText.getBbox().getXl());
    }

    public int getArcDirection(FigArc figArc) {
        int n = 0;
        if (figArc.getDirection() == 0) {
            n = 1;
        }
        return 1 - n;
    }

    public int fig_scale(double d) {
        return (int)(d * this.scale_factor);
    }

    private final String _format2(double d) {
        return this._Format2.form(d);
    }

    private final String _format4(double d) {
        return this._Format4.form(d);
    }

    public void write_arrow_line(FigPrintWriter figPrintWriter, int n, FigObject figObject) {
        FigAttribs figAttribs = figObject.getAttributes();
        boolean bl = false;
        boolean bl2 = false;
        if ((figAttribs.arrowMode & 1) > 0) {
            bl = true;
        }
        if ((figAttribs.arrowMode & 2) > 0) {
            bl2 = true;
        }
        try {
            if (n == 1) {
                if (bl) {
                    double d = this.fig_scale(figAttribs.arrow_f_Length);
                    double d2 = this.fig_scale(figAttribs.arrow_f_Width);
                    double d3 = this.getLineThickness(figAttribs.arrow_f_Thickness);
                    int n2 = figAttribs.arrow_f_Style % 2;
                    int n3 = (figAttribs.arrow_f_Style - 2) / 2;
                    figPrintWriter.print("  " + n3 + ' ' + n2 + ' ' + d3 + ' ' + this._format2(d2) + ' ' + this._format2(d) + '\n');
                    return;
                }
                return;
            }
            if (bl2) {
                double d = this.fig_scale(figAttribs.arrow_b_Length);
                double d4 = this.fig_scale(figAttribs.arrow_b_Width);
                double d5 = this.getLineThickness(figAttribs.arrow_b_Thickness);
                int n4 = figAttribs.arrow_b_Style % 2;
                int n5 = (figAttribs.arrow_b_Style - 2) / 2;
                figPrintWriter.print("  " + n5 + ' ' + n4 + ' ' + d5 + ' ' + this._format2(d4) + ' ' + this._format2(d) + '\n');
                return;
            }
            return;
        }
        catch (Exception exception) {
            System.err.println("-E- Cannot write FIG 3.1 file (arrow)");
            ++this.n_errors;
            return;
        }
    }

    public void write_fig31_pseudocolors(FigPrintWriter figPrintWriter) {
        ColorCache colorCache = ColorCache.getColorCache();
        if (!colorCache.hasUserColors()) {
            return;
        }
        int n = 32;
        while (n < 543) {
            Color color = colorCache.get(n);
            if (color != null) {
                int n2 = color.getRGB() & 0xFFFFFF;
                figPrintWriter.println("0 " + n + " #" + this.getHexString(n2, 6));
            }
            ++n;
        }
    }

    public String getHexString(int n, int n2) {
        String string = Integer.toHexString(n);
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = n2 - string.length();
        int n4 = 0;
        while (n4 < n3) {
            stringBuffer.append('0');
            ++n4;
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public void write_fig31_ellipse(FigPrintWriter figPrintWriter, FigEllipse figEllipse) {
        String string = null;
        if (this.debug) {
            System.out.println("write_fig31_ellipse()...");
        }
        try {
            FigAttribs figAttribs = figEllipse.getAttributes();
            int n = 1;
            int n2 = this.fig_scale(figEllipse.getCenterPoint().x);
            int n3 = this.fig_scale(figEllipse.getCenterPoint().y);
            int n4 = this.fig_scale(figEllipse.getRadiusPoint().x);
            int n5 = this.fig_scale(figEllipse.getRadiusPoint().y);
            int n6 = n2 - n4;
            int n7 = n3 - n5;
            int n8 = n2 + n4;
            int n9 = n3 + n5;
            string = "1 " + n + ' ' + this.getLineStyle(figAttribs) + ' ' + this.getLineThickness(figAttribs.lineWidth) + ' ' + this.getLineColorIndex(figAttribs) + ' ' + this.getFillColorIndex(figAttribs) + ' ' + this.getDepth(figAttribs) + ' ' + this.getPenStyle(figAttribs) + ' ' + this.getAreaFill(figAttribs) + ' ';
            string = string + this.getStyleVal(figAttribs) + ' ' + this.getEllipseDirection(figAttribs) + ' ' + this.getEllipseAngle(figAttribs) + ' ' + n2 + ' ' + n3 + ' ' + n4 + ' ' + n5 + ' ' + n6 + ' ' + n7 + ' ' + n8 + ' ' + n9 + '\n';
            figPrintWriter.print(string);
        }
        catch (Exception exception) {
            System.err.println("-E- Cannot write FIG 3.1 file (ellipse)");
            ++this.n_errors;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void write_fig31_spline(FigPrintWriter figPrintWriter, FigObject figObject) {
        String string = null;
        if (this.debug) {
            System.out.println("write_fig31_spline()...");
        }
        try {
            void var6_11;
            FigAttribs figAttribs = figObject.getAttributes();
            int n = figObject.numPoints();
            if (figAttribs.getDefaultFigVersion() == 31 && figObject.isClosed()) {
                ++n;
            }
            boolean n2 = figObject.isClosed();
            if (!(figObject instanceof FigSpline) && !(figObject instanceof FigNormalXSpline)) {
                if (figObject instanceof FigBezier) {
                    var6_8 += 2;
                } else if (figObject instanceof FigBezierXSpline) {
                    var6_9 += 2;
                } else if (figObject instanceof FigGeneralXSpline) {
                    var6_10 += 4;
                } else {
                    System.err.println("-E- write_spline Internal error: object isn't a spline...\n");
                    return;
                }
            }
            string = "3 " + (int)var6_11 + ' ' + this.getLineStyle(figAttribs) + ' ' + this.getLineThickness(figAttribs.lineWidth) + ' ' + this.getLineColorIndex(figAttribs) + ' ' + this.getFillColorIndex(figAttribs) + ' ' + this.getDepth(figAttribs) + ' ' + this.getPenStyle(figAttribs) + ' ' + this.getAreaFill(figAttribs) + ' ';
            string = string + this.getStyleVal(figAttribs) + ' ' + this.getCapStyle(figAttribs) + ' ' + this.getForwardArrowFlag(figAttribs) + ' ' + this.getBackwardArrowFlag(figAttribs) + ' ' + n + '\n';
            figPrintWriter.print(string);
            this.write_arrow_line(figPrintWriter, 1, figObject);
            this.write_arrow_line(figPrintWriter, 2, figObject);
            this.write_fig31_pointline(figPrintWriter, figObject);
            if (figAttribs.getDefaultFigVersion() == 31) {
                if (var6_11 >= 2) {
                    this.write_fig31_cpointline(figPrintWriter, figObject);
                }
            } else if (figAttribs.getDefaultFigVersion() == 32) {
                this.fake_fig32_controlpoints(figPrintWriter, figObject);
            }
        }
        catch (Exception exception) {
            System.err.println("-E- Cannot write FIG 3.1/3.2 file (spline)");
            ++this.n_errors;
        }
    }

    String buildCharacterEscape(char c) {
        char c2 = c;
        if (c2 > '\u03ff') {
            return "\\u" + Integer.toHexString(c2);
        }
        if (c2 > '\u00ff') {
            return "\\u0" + Integer.toHexString(c2);
        }
        if (c2 > '?') {
            return "\\" + Integer.toOctalString(c2);
        }
        return "\\0" + Integer.toOctalString(c2);
    }

    String buildTextString(FigText figText) {
        String string = figText.getText();
        String string2 = "";
        char c = '\u0000';
        int n = 0;
        while (n < string.length()) {
            c = string.charAt(n);
            if (c >= '\u0080') {
                if (this.debug) {
                    System.out.println("#buildTextString: s contains char '" + c + "' with value " + c);
                }
                string2 = string2 + this.buildCharacterEscape(c);
            } else {
                string2 = c == '\\' ? string2 + "\\\\" : string2 + c;
            }
            ++n;
        }
        string2 = string2 + "\\001";
        return string2;
    }

    public void write_fig31_text(FigPrintWriter figPrintWriter, FigText figText) {
        String string = null;
        String string2 = null;
        if (this.debug) {
            System.out.println("write_fig31_text()...");
        }
        if (figText.getText() == null || figText.getText().length() < 1) {
            return;
        }
        try {
            FigAttribs figAttribs = figText.getAttributes();
            int n = 0;
            n = figAttribs.textAlign == 1 ? 0 : (figAttribs.textAlign == 2 ? 1 : (figAttribs.textAlign == 3 ? 2 : 0));
            int n2 = (int)figText.x;
            int n3 = (int)figText.y;
            string = "4 " + n + ' ' + this.getLineColorIndex(figAttribs) + ' ' + this.getDepth(figAttribs) + ' ' + this.getPenStyle(figAttribs) + ' ' + this.getFont(figAttribs) + ' ' + this.getFontSize(figAttribs) + ' ' + this.getFontAngle(figAttribs) + ' ' + this.getFontFlags(figAttribs) + ' ' + this.getTextHeight(figText) + ' ' + this.getTextLength(figText) + ' ' + this.fig_scale(n2) + ' ' + this.fig_scale(n3) + ' ';
            string2 = this.buildTextString(figText);
            figPrintWriter.print(string + string2 + '\n');
        }
        catch (Exception exception) {
            System.err.println("-E- Cannot write FIG 3.1 file (text)");
            ++this.n_errors;
        }
    }

    public void write_fig31_arc(FigPrintWriter figPrintWriter, FigArc figArc) {
        String string = null;
        if (this.debug) {
            System.out.println("write_fig31_arc()...");
        }
        try {
            FigAttribs figAttribs = figArc.getAttributes();
            int n = figArc.numPoints();
            int n2 = 1 - figArc.isClosed();
            double d = this.fig_scale(figArc.getCenter().x);
            double d2 = this.fig_scale(figArc.getCenter().y);
            Point[] pointArray = figArc.getPoints();
            int n3 = this.fig_scale(pointArray[0].x);
            int n4 = this.fig_scale(pointArray[0].y);
            int n5 = this.fig_scale(pointArray[1].x);
            int n6 = this.fig_scale(pointArray[1].y);
            int n7 = this.fig_scale(pointArray[2].x);
            int n8 = this.fig_scale(pointArray[2].y);
            string = "5 " + n2 + ' ' + this.getLineStyle(figAttribs) + ' ' + this.getLineThickness(figAttribs.lineWidth) + ' ' + this.getLineColorIndex(figAttribs) + ' ' + this.getFillColorIndex(figAttribs) + ' ' + this.getDepth(figAttribs) + ' ' + this.getPenStyle(figAttribs) + ' ' + this.getAreaFill(figAttribs) + ' ';
            string = string + this.getStyleVal(figAttribs) + ' ' + this.getCapStyle(figAttribs) + ' ' + this.getArcDirection(figArc) + ' ' + this.getForwardArrowFlag(figAttribs) + ' ' + this.getBackwardArrowFlag(figAttribs) + ' ' + d + ' ' + d2 + ' ' + n3 + ' ' + n4 + ' ' + n5 + ' ' + n6 + ' ' + n7 + ' ' + n8;
            figPrintWriter.print(string + '\n');
            this.write_arrow_line(figPrintWriter, 1, figArc);
            this.write_arrow_line(figPrintWriter, 2, figArc);
        }
        catch (Exception exception) {
            System.err.println("-E- Cannot write FIG 3.1 file (arc)");
            ++this.n_errors;
        }
    }

    public void write_fig31_cpointline(FigPrintWriter figPrintWriter, FigObject figObject) {
        int n;
        Point[] pointArray;
        Object object;
        if (figObject instanceof FigBezierXSpline) {
            object = figObject.getAttributes();
            pointArray = figObject.getPoints();
            n = figObject.isClosed();
            FigBezier figBezier = new FigBezier(0.0, 0.0, n != 0, (FigAttribs)object);
            figBezier.setPoints(pointArray);
            figBezier.buildSpline();
            figObject = figBezier;
        } else if (!(figObject instanceof FigBezier)) {
            return;
        }
        object = null;
        try {
            pointArray = (Point[])((FigBezier)figObject).getControlPoints();
            if (pointArray == null) {
                throw new Exception();
            }
            object = "";
            n = 0;
            while (n < pointArray.length) {
                object = (String)object + ' ' + this._format4(this.fig_scale((double)pointArray[n]));
                if (n % 8 == 7) {
                    figPrintWriter.print("      " + (String)object + '\n');
                    object = "";
                }
                ++n;
            }
            if (((String)object).length() > 0) {
                figPrintWriter.print("      " + (String)object + '\n');
            }
        }
        catch (Exception exception) {
            System.err.println("-E-: Could not write FIG3.1 file (cpointline)");
            ++this.n_errors;
        }
    }

    public void fake_fig32_controlpoints(FigPrintWriter figPrintWriter, FigObject figObject) {
        String string = null;
        try {
            int n = figObject.getPoints().length;
            double[] dArray = new double[n];
            boolean bl = figObject instanceof FigXSpline;
            boolean bl2 = figObject instanceof FigBezier;
            boolean bl3 = ((FigPolyline)figObject).isClosed();
            if (bl) {
                double[] dArray2 = ((FigXSpline)figObject).getSFactors();
                int n2 = 0;
                while (n2 < n) {
                    dArray[n2] = dArray2[n2];
                    ++n2;
                }
            } else {
                int n3 = 0;
                while (n3 < n) {
                    dArray[n3] = bl2 ? -1.0 : 1.0;
                    ++n3;
                }
            }
            if (!bl3) {
                dArray[0] = 0.0;
                dArray[n - 1] = 0.0;
            }
            string = "";
            int n4 = 0;
            while (n4 < dArray.length) {
                string = string + ' ' + this._format4(dArray[n4]);
                if (n4 % 8 == 7) {
                    figPrintWriter.print("      " + string + '\n');
                    string = "";
                }
                ++n4;
            }
            if (string.length() > 0) {
                figPrintWriter.print("      " + string + '\n');
            }
        }
        catch (Exception exception) {
            System.err.println("-E-: Could not write FIG3.2 file (cpointline)");
            ++this.n_errors;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void write_fig31_pointline(FigPrintWriter var1_1, FigObject var2_2) {
        var3_3 = null;
        try {
            var4_4 = var2_2.getPoints();
            if (var4_4 == null) {
                throw new Exception();
            }
            var5_6 = 0;
            var6_7 = null;
            if (FigAttribs.defaultFigVersion != 32) ** GOTO lbl-1000
            v0 = var2_2.getClass();
            v1 = FigWriter.class$jfig$objects$FigPolyline;
            if (v1 == null) {
                v1 = FigWriter.class$jfig$objects$FigPolyline = FigWriter.class("[Ljfig.objects.FigPolyline;", false);
            }
            if (v0 == v1 && var2_2.isClosed()) {
                var5_6 = var4_4.length + 1;
                var6_7 = new Point[var5_6];
                var7_8 = 0;
                while (var7_8 < var4_4.length) {
                    var6_7[var7_8] = var4_4[var7_8];
                    ++var7_8;
                }
                var6_7[var5_6 - 1] = var4_4[0];
            } else if (FigAttribs.defaultFigVersion == 31 && var2_2.isClosed()) {
                var5_6 = var4_4.length + 1;
                var6_7 = new Point[var5_6];
                var7_8 = 0;
                while (var7_8 < var4_4.length) {
                    var6_7[var7_8] = var4_4[var7_8];
                    ++var7_8;
                }
                var6_7[var5_6 - 1] = var4_4[0];
            } else {
                var5_6 = var4_4.length;
                var6_7 = new Point[var5_6];
                var7_8 = 0;
                while (var7_8 < var4_4.length) {
                    var6_7[var7_8] = var4_4[var7_8];
                    ++var7_8;
                }
            }
            var3_3 = "";
            var7_8 = 0;
            while (var7_8 < var6_7.length) {
                var3_3 = var3_3 + ' ' + this.fig_scale(var6_7[var7_8].x) + ' ' + this.fig_scale(var6_7[var7_8].y);
                if (var7_8 % 4 == 3) {
                    var1_1.print("      " + var3_3 + '\n');
                    var3_3 = "";
                }
                ++var7_8;
            }
            if (var3_3.length() > 0) {
                var1_1.print("      " + var3_3 + '\n');
            }
        }
        catch (Exception var4_5) {
            System.err.println("-E-: Could not write FIG3.1 file (pointline)");
            ++this.n_errors;
        }
    }

    public void write_fig31_rectangle(FigPrintWriter figPrintWriter, FigRectangle figRectangle) {
        String string = null;
        int n = 0;
        if (this.debug) {
            System.out.println("write_fig31_rectangle()...");
        }
        try {
            FigAttribs figAttribs = figRectangle.getAttributes();
            n = figRectangle instanceof FigImage ? 5 : (figAttribs.cornerRadius > 0.0 ? 4 : 2);
            string = "2 " + n + ' ' + this.getLineStyle(figAttribs) + ' ' + this.getLineThickness(figAttribs.lineWidth) + ' ' + this.getLineColorIndex(figAttribs) + ' ' + this.getFillColorIndex(figAttribs) + ' ' + this.getDepth(figAttribs) + ' ' + this.getPenStyle(figAttribs) + ' ' + this.getAreaFill(figAttribs) + ' ';
            string = string + this.getStyleVal(figAttribs) + ' ' + this.getJoinStyle(figAttribs) + ' ' + this.getCapStyle(figAttribs) + ' ' + this.getRadius(figAttribs) + " 0 0 5";
            figPrintWriter.print(string + '\n');
            if (n == 5) {
                figPrintWriter.print(" 0 " + ((FigImage)figRectangle).getImageName() + '\n');
            }
            FigBbox figBbox = figRectangle.getBbox();
            string = "      ";
            string = string + this.fig_scale(figBbox.getXl()) + ' ' + this.fig_scale(figBbox.getYt()) + ' ' + this.fig_scale(figBbox.getXr()) + ' ' + this.fig_scale(figBbox.getYt()) + ' ' + this.fig_scale(figBbox.getXr()) + ' ' + this.fig_scale(figBbox.getYb()) + ' ' + this.fig_scale(figBbox.getXl()) + ' ' + this.fig_scale(figBbox.getYb()) + ' ' + this.fig_scale(figBbox.getXl()) + ' ' + this.fig_scale(figBbox.getYt());
            figPrintWriter.print(string + '\n');
        }
        catch (Exception exception) {
            System.err.println("-E- Cannot write FIG 3.1 file (rectangle)");
            ++this.n_errors;
        }
    }

    public void write_fig31_polyline(FigPrintWriter figPrintWriter, FigObject figObject) {
        String string = null;
        if (this.debug) {
            System.out.println("write_fig31_polyline()...");
        }
        try {
            FigAttribs figAttribs = figObject.getAttributes();
            int n = figObject.numPoints();
            if (figObject.isClosed()) {
                ++n;
            }
            int n2 = figObject.isClosed() ? 3 : 1;
            string = "2 " + n2 + ' ' + this.getLineStyle(figAttribs) + ' ' + this.getLineThickness(figAttribs.lineWidth) + ' ' + this.getLineColorIndex(figAttribs) + ' ' + this.getFillColorIndex(figAttribs) + ' ' + this.getDepth(figAttribs) + ' ' + this.getPenStyle(figAttribs) + ' ' + this.getAreaFill(figAttribs) + ' ';
            string = string + this.getStyleVal(figAttribs) + ' ' + this.getJoinStyle(figAttribs) + ' ' + this.getCapStyle(figAttribs) + ' ' + this.getRadius(figAttribs) + ' ' + this.getForwardArrowFlag(figAttribs) + ' ' + this.getBackwardArrowFlag(figAttribs) + ' ' + n;
            figPrintWriter.print(string + '\n');
            this.write_arrow_line(figPrintWriter, 1, figObject);
            this.write_arrow_line(figPrintWriter, 2, figObject);
            this.write_fig31_pointline(figPrintWriter, figObject);
        }
        catch (Exception exception) {
            System.err.println("-E- Cannot write FIG 3.1 file (polyline)");
            ++this.n_errors;
        }
    }

    public void write_fig31_object_comment(FigPrintWriter figPrintWriter, FigObject figObject) {
        String string = figObject.getComment();
        if (string == null) {
            return;
        }
        figPrintWriter.print("# ");
        int n = string.length();
        char c = ' ';
        int n2 = 0;
        while (n2 < n) {
            c = string.charAt(n2);
            if (c == '\n') {
                figPrintWriter.println();
                if (n2 < n - 1) {
                    figPrintWriter.print("# ");
                }
            } else {
                figPrintWriter.print(c);
            }
            ++n2;
        }
        if (c != '\n') {
            figPrintWriter.println();
        }
    }

    public void write_fig32_header(FigPrintWriter figPrintWriter, FigObjectList figObjectList) {
        try {
            FigAttribs figAttribs = null;
            try {
                figAttribs = figObjectList.get_first().obj.getAttributes();
            }
            catch (Exception exception) {
                figAttribs = new FigAttribs();
            }
            figPrintWriter.println("#FIG 3.2");
            figPrintWriter.println(figAttribs.getPageOrientation());
            figPrintWriter.println(figAttribs.getPageJustification());
            if ("Inches".equals(figAttribs.getPageUnits())) {
                figPrintWriter.println("Inches");
            } else {
                figPrintWriter.println("Metric");
            }
            figPrintWriter.println(figAttribs.getPaperSize() + ' ');
            figPrintWriter.println(figAttribs.getExportMagnification());
            figPrintWriter.println(figAttribs.getSingleOrMultipleSheets());
            figPrintWriter.println(figAttribs.getTransparentColorIndex());
            this.check_write_fig32_file_comment(figPrintWriter, figObjectList.getFileComment());
            figPrintWriter.println("1200 2");
        }
        catch (Exception exception) {
            System.err.println("-E- Could not write FIG 3.2 file (header).");
            exception.printStackTrace();
            ++this.n_errors;
        }
    }

    private final void check_write_fig32_file_comment(FigPrintWriter figPrintWriter, String string) {
        if (string == null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.length() == 0) {
                figPrintWriter.println("#");
                continue;
            }
            if (string2.charAt(0) == '#') {
                figPrintWriter.println(string2);
                continue;
            }
            figPrintWriter.println("#" + string2);
        }
    }

    public void write_fig31_header(FigPrintWriter figPrintWriter, FigObjectList figObjectList) {
        try {
            FigAttribs figAttribs = figObjectList.get_first().obj.getAttributes();
            figPrintWriter.print("#FIG 3.1\n");
            figPrintWriter.print(figAttribs.getFigOrientation() == 0 ? "Landscape\n" : "Portrait\n");
            figPrintWriter.print(figAttribs.getFigJustification() == 0 ? "Center\n" : "Flush Left\n");
            figPrintWriter.print(figAttribs.getFigUnits() == 0 ? "Metric\n" : "Inches\n");
            figPrintWriter.print("1200 2\n");
        }
        catch (Exception exception) {
            System.err.println("-E- Could not write FIG 3.1 file (header).");
            ++this.n_errors;
        }
    }

    public int write_fig_file(DataOutputStream dataOutputStream, boolean bl, FigObjectList figObjectList) {
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(dataOutputStream);
        }
        catch (Throwable throwable) {
            System.err.println("write_fig_file: " + throwable);
            throwable.printStackTrace();
        }
        int n = this.write_fig_file(printWriter, bl, figObjectList);
        printWriter.flush();
        return n;
    }

    public int write_fig_file(PrintWriter printWriter, boolean bl, FigObjectList figObjectList) {
        FigObject figObject = null;
        FigPrintWriter figPrintWriter = new FigPrintWriter(printWriter);
        try {
            if (bl) {
                this.n_errors = 0;
                if (FigAttribs.defaultFigVersion == 31) {
                    this.write_fig31_header(figPrintWriter, figObjectList);
                } else if (FigAttribs.defaultFigVersion == 32) {
                    this.write_fig32_header(figPrintWriter, figObjectList);
                } else {
                    throw new Exception("FigWriter: unsupported FIG version: " + FigAttribs.defaultFigVersion);
                }
                this.write_fig31_pseudocolors(figPrintWriter);
            }
            ListNode listNode = figObjectList.get_first();
            while (listNode != null) {
                this.currentObject = figObject = listNode.obj;
                this.write_fig31_object_comment(figPrintWriter, figObject);
                if (figObject instanceof FigCompound) {
                    FigBbox figBbox = figObject.getBbox();
                    String string = null;
                    string = "6 " + this.fig_scale(figBbox.getXr()) + ' ' + this.fig_scale(figBbox.getYt()) + ' ' + this.fig_scale(figBbox.getXl()) + ' ' + this.fig_scale(figBbox.getYb());
                    figPrintWriter.print(string + '\n');
                    this.write_fig_file(figPrintWriter, false, ((FigCompound)figObject).getMembers());
                    figPrintWriter.print("-6\n");
                } else if (figObject instanceof FigText) {
                    this.write_fig31_text(figPrintWriter, (FigText)figObject);
                } else if (figObject instanceof FigEllipse) {
                    this.write_fig31_ellipse(figPrintWriter, (FigEllipse)figObject);
                } else if (figObject instanceof FigArc) {
                    this.write_fig31_arc(figPrintWriter, (FigArc)figObject);
                } else if (figObject instanceof FigBezier) {
                    this.write_fig31_spline(figPrintWriter, figObject);
                } else if (figObject instanceof FigSpline) {
                    this.write_fig31_spline(figPrintWriter, figObject);
                } else if (figObject instanceof FigBezierXSpline) {
                    this.write_fig31_spline(figPrintWriter, figObject);
                } else if (figObject instanceof FigNormalXSpline) {
                    this.write_fig31_spline(figPrintWriter, figObject);
                } else if (figObject instanceof FigGeneralXSpline) {
                    this.write_fig31_spline(figPrintWriter, figObject);
                } else if (figObject instanceof FigPolyline) {
                    this.write_fig31_polyline(figPrintWriter, figObject);
                } else if (figObject instanceof FigImage) {
                    this.write_fig31_rectangle(figPrintWriter, (FigRectangle)figObject);
                } else if (figObject instanceof FigRectangle) {
                    this.write_fig31_rectangle(figPrintWriter, (FigRectangle)figObject);
                } else {
                    System.err.println("write_fig_file: unknown object " + figObject.toString());
                    ++this.n_errors;
                }
                listNode = figObjectList.get_next(listNode);
            }
            if (this.debug) {
                System.out.println("Write FIG3.1 file ok, " + this.n_errors + " possible error(s)");
            }
            return this.n_errors;
        }
        catch (Exception exception) {
            System.err.println("-E-: Could not write FIG3.1 file (main)");
            ++this.n_errors;
            return this.n_errors;
        }
    }

    public void writeAsResource(PrintWriter printWriter, FigObject figObject) {
        FigPrintWriter figPrintWriter = new FigPrintWriter(printWriter);
        figPrintWriter.print(figObject.getClass().getName());
        figPrintWriter.print(" ");
        this.setResolution(2400);
        try {
            if (figObject instanceof FigCompound) {
                FigBbox figBbox = figObject.getBbox();
                String string = null;
                string = "6 " + this.fig_scale(figBbox.getXr()) + ' ' + this.fig_scale(figBbox.getYt()) + ' ' + this.fig_scale(figBbox.getXl()) + ' ' + this.fig_scale(figBbox.getYb());
                figPrintWriter.print(string + '\n');
                this.write_fig_file(figPrintWriter, false, ((FigCompound)figObject).getMembers());
                figPrintWriter.print("-6\n");
            } else if (figObject instanceof FigText) {
                this.write_fig31_text(figPrintWriter, (FigText)figObject);
            } else if (figObject instanceof FigEllipse) {
                this.write_fig31_ellipse(figPrintWriter, (FigEllipse)figObject);
            } else if (figObject instanceof FigArc) {
                this.write_fig31_arc(figPrintWriter, (FigArc)figObject);
            } else if (figObject instanceof FigBezier) {
                this.write_fig31_spline(figPrintWriter, figObject);
            } else if (figObject instanceof FigSpline) {
                this.write_fig31_spline(figPrintWriter, figObject);
            } else if (figObject instanceof FigXSpline) {
                this.write_fig31_spline(figPrintWriter, figObject);
            } else if (figObject instanceof FigPolyline) {
                this.write_fig31_polyline(figPrintWriter, figObject);
            } else if (figObject instanceof FigImage) {
                this.write_fig31_rectangle(figPrintWriter, (FigRectangle)figObject);
            } else if (figObject instanceof FigRectangle) {
                this.write_fig31_rectangle(figPrintWriter, (FigRectangle)figObject);
            } else {
                System.err.println("write_fig_file: unknown object " + figObject.toString());
            }
        }
        catch (Exception exception) {
            System.err.println("FigBaseobject.writeAsResource(): " + exception);
            exception.printStackTrace();
        }
        figPrintWriter.flush();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.debug = false;
        this.currentObject = null;
        this._Format2 = new Format("%.2f");
        this._Format4 = new Format("%.4f");
        this.styleValFormat = new Format("%5.2f");
    }

    public FigWriter(Object object) {
        this();
    }

    public FigWriter() {
        this.this();
        this.n_errors = 0;
        this.line_number = 0;
        this.colorCache = ColorCache.getColorCache();
        this.setResolution(1200);
    }
}

