/*
 * Decompiled with CFR 0.152.
 */
package jfig.java2d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import jfig.canvas.FigTrafo2D;
import jfig.java2d.FigTools2D;
import jfig.objects.FigBbox;
import jfig.objects.FigRectangle;
import jfig.objects.FigRenderer;

public class FigRectangleRenderer
implements FigRenderer {
    FigRectangle rectangle;
    Shape rect2D;
    BasicStroke stroke;
    Color color;
    Paint paint;

    public void paint(Graphics graphics, FigTrafo2D figTrafo2D) {
        if (!this.rectangle.isVisible()) {
            return;
        }
        try {
            Graphics2D graphics2D = (Graphics2D)graphics;
            AffineTransform affineTransform = graphics2D.getTransform();
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setTransform(FigTools2D.createCompoundTransform(affineTransform, figTrafo2D));
            if (this.paint != null) {
                graphics2D.setPaint(this.paint);
                graphics2D.fill(this.rect2D);
            }
            if ((double)this.stroke.getLineWidth() > 0.0) {
                graphics2D.setColor(this.color);
                graphics2D.setStroke(this.stroke);
                graphics2D.draw(this.rect2D);
            }
            graphics2D.setTransform(affineTransform);
            graphics2D.setStroke(stroke);
            FigBbox figBbox = this.rectangle.getBbox();
            if (this.rectangle.isShowPoints()) {
                FigTools2D.showPoints(graphics, figTrafo2D, figBbox);
            }
            if (this.rectangle.isSelected()) {
                FigTools2D.showSelected(graphics, figTrafo2D, figBbox);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public FigRectangleRenderer(FigRectangle figRectangle) {
        this.rectangle = figRectangle;
        this.color = figRectangle.getAttributes().lineColor;
        this.paint = FigTools2D.createPaint(figRectangle.getAttributes());
        FigBbox figBbox = figRectangle.getBbox();
        double d = figBbox.getXl();
        double d2 = figBbox.getYt();
        double d3 = figBbox.getXr() - d;
        double d4 = figBbox.getYb() - d2;
        double d5 = (double)2 * figRectangle.getAttributes().cornerRadius;
        if (figRectangle.isRounded() && d5 > 0.0) {
            this.rect2D = new RoundRectangle2D.Double(d, d2, d3, d4, d5, d5);
            this.stroke = FigTools2D.createStroke(figRectangle.getAttributes(), 1, 1);
        } else {
            this.rect2D = new Rectangle2D.Double(d, d2, d3, d4);
            this.stroke = FigTools2D.createStroke(figRectangle.getAttributes(), 0, 2);
        }
    }
}

