/*
 * Decompiled with CFR 0.152.
 */
package jfig.java2d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import jfig.canvas.FigTrafo2D;
import jfig.java2d.FigArrow2D;
import jfig.java2d.FigTools2D;
import jfig.objects.FigAttribs;
import jfig.objects.FigPolyline;
import jfig.objects.FigRenderer;

public class FigPolylineRenderer
implements FigRenderer {
    FigPolyline polyline;
    GeneralPath path2D;
    GeneralPath fill2D;
    BasicStroke stroke;
    Color color;
    Paint paint;
    FigArrow2D frontArrow;
    FigArrow2D backArrow;

    public void paint(Graphics graphics, FigTrafo2D figTrafo2D) {
        if (!this.polyline.isVisible()) {
            return;
        }
        try {
            Graphics2D graphics2D = (Graphics2D)graphics;
            AffineTransform affineTransform = graphics2D.getTransform();
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setTransform(FigTools2D.createCompoundTransform(affineTransform, figTrafo2D));
            if (this.paint != null) {
                graphics2D.setPaint(this.paint);
                graphics2D.fill(this.fill2D);
            }
            if ((double)this.stroke.getLineWidth() > 0.0) {
                graphics2D.setColor(this.color);
                graphics2D.setStroke(this.stroke);
                graphics2D.draw(this.path2D);
            }
            if (this.frontArrow != null) {
                this.frontArrow.paint(graphics2D);
            }
            if (this.backArrow != null) {
                this.backArrow.paint(graphics2D);
            }
            graphics2D.setTransform(affineTransform);
            graphics2D.setStroke(stroke);
            if (this.polyline.isShowPoints()) {
                FigTools2D.showPoints((Graphics)graphics2D, figTrafo2D, this.polyline.getPoints());
            }
            if (this.polyline.isSelected()) {
                FigTools2D.showSelected((Graphics)graphics2D, figTrafo2D, this.polyline.getPoints());
            }
        }
        catch (Throwable throwable) {
            System.err.println("-E- FigPolylineRenderer(2D).paint: " + throwable);
            throwable.printStackTrace();
        }
    }

    public FigPolylineRenderer(FigPolyline figPolyline) {
        FigAttribs figAttribs = figPolyline.getAttributes();
        this.polyline = figPolyline;
        this.color = this.polyline.getAttributes().lineColor;
        this.stroke = FigTools2D.createStroke(figAttribs);
        this.paint = FigTools2D.createPaint(figAttribs);
        if (this.polyline.isClosed()) {
            this.fill2D = this.path2D = FigTools2D.createPath(figPolyline.getPoints(), figPolyline.isClosed());
            this.frontArrow = null;
            this.backArrow = null;
        } else if (figAttribs.arrowMode == 0) {
            this.fill2D = this.path2D = FigTools2D.createPath(figPolyline.getPoints(), figPolyline.isClosed());
            this.frontArrow = null;
            this.backArrow = null;
        } else {
            this.frontArrow = FigTools2D.createFrontArrow(figPolyline, figPolyline.getPoints());
            this.backArrow = FigTools2D.createBackArrow(figPolyline, figPolyline.getPoints());
            this.path2D = FigTools2D.createArrowCorrectedLine(figPolyline.getPoints(), figAttribs);
            this.fill2D = FigTools2D.createPath(figPolyline.getPoints(), figPolyline.isClosed());
        }
    }
}

