/*
 * Decompiled with CFR 0.152.
 */
package jfig.java2d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import jfig.java2d.FigTools2D;
import jfig.objects.FigAttribs;
import jfig.objects.Point;
import jfig.utils.SetupManager;

public class FigArrow2D {
    private static float MAX_LINE_WIDTH = 50.0f;
    private static float SIMPLE_ARROW_MITER_LIMIT = 30.0f;
    private Shape shape;
    private BasicStroke stroke;
    private Color lineColor;
    private Color fillColor;

    private final void createArrow(FigAttribs figAttribs, Point point, Point point2, boolean bl) {
        double d;
        double d2;
        int n = bl ? figAttribs.arrow_f_Style : figAttribs.arrow_b_Style;
        this.lineColor = figAttribs.lineColor;
        float f = FigTools2D.getLineWidth(figAttribs.lineWidth);
        if (n == 2) {
            int n2 = 0;
            if (f > SIMPLE_ARROW_MITER_LIMIT) {
                n2 = 1;
            }
            int n3 = 1 - n2;
            this.stroke = new BasicStroke(f, 0, n3, 5);
        } else {
            if (f > MAX_LINE_WIDTH) {
                f = MAX_LINE_WIDTH;
            }
            this.stroke = new BasicStroke(f, 1, 1, 2.0f);
        }
        double d3 = point2.x - point.x;
        double d4 = point2.y - point.y;
        double d5 = Math.sqrt(d3 * d3 + d4 * d4);
        if (d5 == 0.0) {
            d5 = 1.0;
        }
        double d6 = d3 / d5;
        double d7 = d4 / d5;
        double d8 = -d4 / d5;
        double d9 = d3 / d5;
        if (bl) {
            d2 = figAttribs.arrow_f_Length;
            d = figAttribs.arrow_f_Width;
        } else {
            d2 = figAttribs.arrow_b_Length;
            d = figAttribs.arrow_b_Width;
        }
        Point point3 = new Point(point2.x, point2.y);
        Point point4 = new Point(point2.x - d2 * d6 + 0.5, point2.y - d2 * d7 + 0.5);
        Point point5 = new Point(point2.x - d2 * d6 + 0.5 * d * d8 + 0.5, point2.y - d2 * d7 + 0.5 * d * d9 + 0.5);
        Point point6 = new Point(point2.x - d2 * d6 - 0.5 * d * d8 + 0.5, point2.y - d2 * d7 - 0.5 * d * d9 + 0.5);
        Point point7 = new Point(0.0, 0.0);
        Point point8 = new Point(0.0, 0.0);
        if (n == 8 || n == 9) {
            point4 = new Point(point2.x - 1.2 * d2 * d6 + 0.5, point2.y - 1.2 * d2 * d7 + 0.5);
            point7 = new Point(point2.x - 1.14 * d2 * d6 + 0.28 * d * d8 + 0.5, point2.y - 1.14 * d2 * d7 + 0.28 * d * d9 + 0.5);
            point8 = new Point(point2.x - 1.14 * d2 * d6 - 0.28 * d * d8 + 0.5, point2.y - 1.14 * d2 * d7 - 0.28 * d * d9 + 0.5);
        }
        if (n == 6 || n == 7) {
            point4 = new Point(point2.x - 0.8 * d2 * d6 + 0.5, point2.y - 0.8 * d2 * d7 + 0.5);
        }
        GeneralPath generalPath = null;
        switch (n) {
            default: {
                System.out.println("-E- FigArrow2D: unknown type" + n);
            }
            case 2: {
                generalPath = new GeneralPath();
                generalPath.moveTo((float)point5.x, (float)point5.y);
                generalPath.lineTo((float)point3.x, (float)point3.y);
                generalPath.lineTo((float)point6.x, (float)point6.y);
                this.shape = generalPath;
                this.fillColor = null;
                break;
            }
            case 4: {
                generalPath = new GeneralPath();
                generalPath.moveTo((float)point3.x, (float)point3.y);
                generalPath.lineTo((float)point5.x, (float)point5.y);
                generalPath.lineTo((float)point6.x, (float)point6.y);
                generalPath.closePath();
                this.shape = generalPath;
                this.fillColor = Color.white;
                break;
            }
            case 5: {
                generalPath = new GeneralPath();
                generalPath.moveTo((float)point3.x, (float)point3.y);
                generalPath.lineTo((float)point5.x, (float)point5.y);
                generalPath.lineTo((float)point6.x, (float)point6.y);
                generalPath.closePath();
                this.shape = generalPath;
                this.fillColor = figAttribs.lineColor;
                break;
            }
            case 6: {
                generalPath = new GeneralPath();
                generalPath.moveTo((float)point3.x, (float)point3.y);
                generalPath.lineTo((float)point5.x, (float)point5.y);
                generalPath.lineTo((float)point4.x, (float)point4.y);
                generalPath.lineTo((float)point6.x, (float)point6.y);
                generalPath.closePath();
                this.shape = generalPath;
                this.fillColor = Color.white;
                break;
            }
            case 7: {
                generalPath = new GeneralPath();
                generalPath.moveTo((float)point3.x, (float)point3.y);
                generalPath.lineTo((float)point5.x, (float)point5.y);
                generalPath.lineTo((float)point4.x, (float)point4.y);
                generalPath.lineTo((float)point6.x, (float)point6.y);
                generalPath.closePath();
                this.shape = generalPath;
                this.fillColor = figAttribs.lineColor;
                break;
            }
            case 8: {
                generalPath = new GeneralPath();
                generalPath.moveTo((float)point3.x, (float)point3.y);
                generalPath.lineTo((float)point5.x, (float)point5.y);
                generalPath.lineTo((float)point7.x, (float)point7.y);
                generalPath.lineTo((float)point4.x, (float)point4.y);
                generalPath.lineTo((float)point8.x, (float)point8.y);
                generalPath.lineTo((float)point6.x, (float)point6.y);
                generalPath.closePath();
                this.shape = generalPath;
                this.fillColor = Color.white;
                break;
            }
            case 9: {
                generalPath = new GeneralPath();
                generalPath.moveTo((float)point3.x, (float)point3.y);
                generalPath.lineTo((float)point5.x, (float)point5.y);
                generalPath.lineTo((float)point7.x, (float)point7.y);
                generalPath.lineTo((float)point4.x, (float)point4.y);
                generalPath.lineTo((float)point8.x, (float)point8.y);
                generalPath.lineTo((float)point6.x, (float)point6.y);
                generalPath.closePath();
                this.shape = generalPath;
                this.fillColor = figAttribs.lineColor;
                break;
            }
            case 11: {
                this.shape = new Ellipse2D.Double(point3.x - d, point3.y - d, (double)2 * d, (double)2 * d);
                this.fillColor = figAttribs.lineColor;
            }
        }
    }

    public static double getLengthFactor(int n) {
        switch (n) {
            case 2: {
                return 0.0;
            }
            case 4: 
            case 5: {
                return 1.0;
            }
            case 6: 
            case 7: {
                return 0.8;
            }
            case 8: 
            case 9: {
                return 1.2;
            }
            case 11: {
                return 0.0;
            }
        }
        throw new RuntimeException("-W- FigArrow2D.getLengthFactor: unknown arrow type: " + n);
    }

    public void paint(Graphics2D graphics2D) {
        if (this.fillColor != null) {
            graphics2D.setColor(this.fillColor);
            graphics2D.fill(this.shape);
        }
        graphics2D.setColor(this.lineColor);
        graphics2D.setStroke(this.stroke);
        graphics2D.draw(this.shape);
    }

    public FigArrow2D(FigAttribs figAttribs, Point point, Point point2, boolean bl) {
        this.createArrow(figAttribs, point, point2, bl);
    }

    static {
        MAX_LINE_WIDTH = (float)SetupManager.getDouble("jfig.java2d.FigArrow2D.maxLineWidth", 50.0);
        SIMPLE_ARROW_MITER_LIMIT = (float)SetupManager.getDouble("jfig.java2d.FigArrow2D.simpleArrowMiterLimit", 30.0);
    }
}

