/*
 * Decompiled with CFR 0.152.
 */
package jfig.java2d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import jfig.canvas.FigTrafo2D;
import jfig.java2d.FigArrow2D;
import jfig.java2d.FigTools2D;
import jfig.objects.FigArc;
import jfig.objects.FigAttribs;
import jfig.objects.FigRenderer;
import jfig.objects.Point;

public class FigArcRenderer
implements FigRenderer {
    FigArc arc;
    GeneralPath path2D;
    BasicStroke stroke;
    Color color;
    Paint paint;
    FigArrow2D frontArrow;
    FigArrow2D backArrow;

    private final int _arrowpos2(double d, int n, Point[] pointArray) {
        int n2 = 2;
        try {
            if (n == 6 || n == 7) {
                d = FigArrow2D.getLengthFactor(n) * d;
            }
            double d2 = pointArray[1].x - pointArray[0].x;
            double d3 = pointArray[1].y - pointArray[0].y;
            double d4 = Math.sqrt(d2 * d2 + d3 * d3);
            n2 = (int)(d / d4);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (n2 < 1) {
            n2 = 1;
        }
        if (n2 >= pointArray.length) {
            n2 = pointArray.length - 1;
        }
        return n2;
    }

    public void paint(Graphics graphics, FigTrafo2D figTrafo2D) {
        if (!this.arc.isVisible()) {
            return;
        }
        try {
            Graphics2D graphics2D = (Graphics2D)graphics;
            AffineTransform affineTransform = graphics2D.getTransform();
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setTransform(FigTools2D.createCompoundTransform(affineTransform, figTrafo2D));
            if (this.paint != null) {
                graphics2D.setPaint(this.paint);
                graphics2D.fill(this.path2D);
            }
            if ((double)this.stroke.getLineWidth() > 0.0) {
                graphics2D.setColor(this.color);
                graphics2D.setStroke(this.stroke);
                graphics2D.draw(this.path2D);
            }
            if (this.frontArrow != null) {
                this.frontArrow.paint(graphics2D);
            }
            if (this.backArrow != null) {
                this.backArrow.paint(graphics2D);
            }
            graphics2D.setTransform(affineTransform);
            graphics2D.setStroke(stroke);
            if (this.arc.isShowPoints()) {
                FigTools2D.showPoints((Graphics)graphics2D, figTrafo2D, this.arc.getPoints());
            }
            if (this.arc.isSelected()) {
                FigTools2D.showSelected((Graphics)graphics2D, figTrafo2D, this.arc.getPoints());
            }
        }
        catch (Throwable throwable) {
            System.err.println("-E- FigArcRenderer(2D).paint: " + throwable);
            throwable.printStackTrace();
        }
    }

    public FigArcRenderer(FigArc figArc) {
        this.arc = figArc;
        FigAttribs figAttribs = this.arc.getAttributes();
        boolean bl = false;
        if (figAttribs.fillStyle != 1) {
            bl = true;
        }
        boolean bl2 = bl;
        boolean bl3 = false;
        if (figAttribs.arrowMode == 0) {
            bl3 = true;
        }
        boolean bl4 = bl3;
        Point[] pointArray = this.arc.getInterpolatedArcPoints();
        this.color = figAttribs.lineColor;
        this.paint = FigTools2D.createPaint(figAttribs);
        this.stroke = FigTools2D.createStroke(figAttribs, 1, FigTools2D.getStrokeCapStyle(figAttribs));
        int n = 0;
        int n2 = pointArray.length - 1;
        int n3 = -1;
        int n4 = -1;
        if (figAttribs.fillStyle == 1) {
            if ((figAttribs.arrowMode & 1) != 0) {
                n3 = this._arrowpos2(figAttribs.arrow_f_Length, figAttribs.arrow_f_Style, pointArray);
                this.frontArrow = FigTools2D.createFrontArrow(this.arc, pointArray, n3);
                if (figAttribs.arrow_f_Style != 2) {
                    n2 -= n3;
                }
            }
            if ((figAttribs.arrowMode & 2) != 0) {
                n4 = this._arrowpos2(figAttribs.arrow_b_Length, figAttribs.arrow_b_Style, pointArray);
                this.backArrow = FigTools2D.createBackArrow(this.arc, pointArray, n4);
                if (figAttribs.arrow_b_Style != 2) {
                    n = n4;
                }
            }
        }
        this.path2D = bl2 || bl4 ? FigTools2D.createPath(pointArray, bl2) : (pointArray.length <= 3 ? FigTools2D.createArrowCorrectedLine(pointArray, figAttribs) : FigTools2D.createPath(pointArray, n, n2, false));
    }
}

