/*
 * Decompiled with CFR 0.152.
 */
package nl.umcg.deelenp.genotypeharmonizer;

import java.io.File;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.log4j.Logger;
import org.molgenis.genotype.GenotypeDataException;
import org.molgenis.genotype.GenotypedDataWriterFormats;
import org.molgenis.genotype.RandomAccessGenotypeDataReaderFormats;

public class GenotypeHarmonizerParamaters {
    private static final Logger LOGGER = Logger.getLogger(GenotypeHarmonizerParamaters.class);
    private static final Options OPTIONS = new Options();
    private final String[] inputBasePaths;
    private final RandomAccessGenotypeDataReaderFormats inputType;
    private final String refBasePath;
    private final RandomAccessGenotypeDataReaderFormats refType;
    private final String outputBasePath;
    private final GenotypedDataWriterFormats outputType;
    private final boolean debugMode;
    private final boolean updateId;
    private final int minSnpsToAlignOn;
    private final int flankSnpsToConsider;
    private final double minLdToIncludeAlign;
    private final double maxMafForMafAlignment;
    private final double minimumPosteriorProbability;
    private final String forceSeqName;
    private final boolean ldCheck;
    private final boolean keep;
    private final File variantFilterListFile;
    private final File variantPosFilterListFile;
    private final String seqFilterIn;
    private final File sampleFilterListFile;
    private final File logFile;
    private final File snpUpdateFile;
    private final File snpLogFile;
    private final double minHwePvalue;
    private final float minCallRate;
    private final float minMAF;
    private final double minMachR2;
    private static final int DEFAULT_MIN_VARIANTS_TO_ALIGN_ON = 3;
    private static final int DEFAULT_FLANK_VARIANTS_TO_CONSIDER = 100;
    private static final double DEFAULT_MIN_LD_TO_INCLUDE_ALIGN = 0.3;
    private static final double DEFAULT_MAX_MAF_FOR_MAF_ALIGNMENT = 0.0;
    private static final double DEFAULT_MINIMUM_POSTERIOR_PROBABILITY = 0.4;

    public GenotypeHarmonizerParamaters(String ... args) throws ParseException {
        GenotypedDataWriterFormats outputTypeTmp;
        CommandLine commandLine;
        block39: {
            PosixParser parser = new PosixParser();
            commandLine = parser.parse(OPTIONS, args, false);
            this.inputBasePaths = commandLine.getOptionValues('i');
            try {
                if (commandLine.hasOption('I')) {
                    this.inputType = RandomAccessGenotypeDataReaderFormats.valueOf(commandLine.getOptionValue('I').toUpperCase());
                    break block39;
                }
                if (this.inputBasePaths[0].endsWith(".vcf")) {
                    throw new ParseException("Only vcf.gz is supported. Please see manual on how to do create a vcf.gz file.");
                }
                try {
                    this.inputType = RandomAccessGenotypeDataReaderFormats.matchFormatToPath(this.inputBasePaths[0]);
                }
                catch (GenotypeDataException e) {
                    throw new ParseException("Unable to determine input type based on specified path. Please specify --inputType");
                }
            }
            catch (IllegalArgumentException e) {
                throw new ParseException("Error parsing --inputType \"" + commandLine.getOptionValue('I') + "\" is not a valid input data format");
            }
        }
        if (commandLine.hasOption('r')) {
            this.refBasePath = commandLine.getOptionValue('r');
            try {
                if (commandLine.hasOption('R')) {
                    this.refType = RandomAccessGenotypeDataReaderFormats.valueOf(commandLine.getOptionValue('R').toUpperCase());
                }
                if (this.refBasePath.endsWith(".vcf")) {
                    throw new ParseException("Only vcf.gz is supported. Please see manual on how to do create a vcf.gz file.");
                }
                try {
                    this.refType = RandomAccessGenotypeDataReaderFormats.matchFormatToPath(this.refBasePath);
                }
                catch (GenotypeDataException e) {
                    throw new ParseException("Unable to determine reference type based on specified path. Please specify --refType");
                }
            }
            catch (IllegalArgumentException e) {
                throw new ParseException("Error parsing --refType \"" + commandLine.getOptionValue('R') + "\" is not a valid reference data format");
            }
        } else {
            this.refBasePath = null;
            this.refType = null;
        }
        this.outputBasePath = commandLine.getOptionValue('o');
        if (commandLine.hasOption('O')) {
            try {
                this.outputType = GenotypedDataWriterFormats.valueOf(commandLine.getOptionValue('O').toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new ParseException("Error parsing --outputType \"" + commandLine.getOptionValue('O') + "\" is not a valid output data format");
            }
        }
        try {
            outputTypeTmp = GenotypedDataWriterFormats.valueOf(this.inputType.name());
        }
        catch (IllegalArgumentException e) {
            outputTypeTmp = GenotypedDataWriterFormats.PLINK_BED;
        }
        this.outputType = outputTypeTmp;
        this.debugMode = commandLine.hasOption('d');
        this.updateId = commandLine.hasOption("id");
        try {
            this.minSnpsToAlignOn = commandLine.hasOption('m') ? Integer.parseInt(commandLine.getOptionValue('m')) : 3;
        }
        catch (NumberFormatException e) {
            throw new ParseException("Error parsing --min-variants \"" + commandLine.getOptionValue('m') + "\" is not an int");
        }
        try {
            this.flankSnpsToConsider = commandLine.hasOption('v') ? Integer.parseInt(commandLine.getOptionValue('v')) : 100;
        }
        catch (NumberFormatException e) {
            throw new ParseException("Error parsing --variants \"" + commandLine.getOptionValue('v') + "\" is not an int");
        }
        try {
            this.minLdToIncludeAlign = commandLine.hasOption('l') ? Double.parseDouble(commandLine.getOptionValue('l')) : 0.3;
        }
        catch (NumberFormatException e) {
            throw new ParseException("Error parsing --min-ld \"" + commandLine.getOptionValue('l') + "\" is not a double");
        }
        try {
            this.maxMafForMafAlignment = commandLine.hasOption("ma") ? Double.parseDouble(commandLine.getOptionValue("ma")) : 0.0;
        }
        catch (NumberFormatException e) {
            throw new ParseException("Error parsing --mafAlign \"" + commandLine.getOptionValue("ma") + "\" is not a double");
        }
        try {
            this.minimumPosteriorProbability = commandLine.hasOption("ip") ? Double.parseDouble(commandLine.getOptionValue("ip")) : 0.4;
        }
        catch (NumberFormatException e) {
            throw new ParseException("Error parsing --inputProb \"" + commandLine.getOptionValue("ip") + "\" is not an double");
        }
        this.forceSeqName = commandLine.hasOption('f') ? commandLine.getOptionValue('f') : null;
        this.ldCheck = commandLine.hasOption('c');
        this.keep = commandLine.hasOption('k');
        if (this.outputType == GenotypedDataWriterFormats.TRITYPER) {
            File outputFolder = new File(this.outputBasePath);
            this.logFile = new File(outputFolder, "GenotypeHarmonizer.log");
            this.snpUpdateFile = new File(outputFolder, "GenotypeHarmonizer_idUpdates.txt");
            this.snpLogFile = new File(outputFolder, "GenotypeHarmonizer_snpLog.log");
        } else {
            this.logFile = new File(this.outputBasePath + ".log");
            this.snpUpdateFile = new File(this.outputBasePath + "_idUpdates.txt");
            this.snpLogFile = new File(this.outputBasePath + "_snpLog.log");
        }
        this.variantFilterListFile = commandLine.hasOption("vf") ? new File(commandLine.getOptionValue("vf")) : null;
        this.variantPosFilterListFile = commandLine.hasOption("pf") ? new File(commandLine.getOptionValue("pf")) : null;
        this.seqFilterIn = commandLine.hasOption("ch") ? commandLine.getOptionValue("ch") : null;
        this.sampleFilterListFile = commandLine.hasOption("sf") ? new File(commandLine.getOptionValue("sf")) : null;
        try {
            this.minHwePvalue = commandLine.hasOption("hf") ? Double.parseDouble(commandLine.getOptionValue("hf")) : 0.0;
        }
        catch (NumberFormatException e) {
            throw new ParseException("Error parsing --hweFilter \"" + commandLine.getOptionValue("hw") + "\" is not a double");
        }
        try {
            this.minMAF = commandLine.hasOption("mf") ? Float.parseFloat(commandLine.getOptionValue("mf")) : 0.0f;
        }
        catch (NumberFormatException e) {
            throw new ParseException("Error parsing --mafFilter \"" + commandLine.getOptionValue("mf") + "\" is not a double");
        }
        try {
            this.minMachR2 = commandLine.hasOption("mrf") ? Double.parseDouble(commandLine.getOptionValue("mrf")) : 0.0;
        }
        catch (NumberFormatException e) {
            throw new ParseException("Error parsing --machR2Filter \"" + commandLine.getOptionValue("mrf") + "\" is not a double");
        }
        try {
            this.minCallRate = commandLine.hasOption("cf") ? Float.parseFloat(commandLine.getOptionValue("cf")) : 0.0f;
        }
        catch (NumberFormatException e) {
            throw new ParseException("Error parsing --callRateFilter \"" + commandLine.getOptionValue("cf") + "\" is not an double");
        }
    }

    public static void printHelp() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(" ", OPTIONS);
    }

    public void printOptions() {
        StringBuilder inputPaths = new StringBuilder();
        for (String path : this.inputBasePaths) {
            inputPaths.append(path);
            inputPaths.append(' ');
        }
        System.out.println("Interpreted arguments: ");
        System.out.println(" - Input base path: " + inputPaths);
        LOGGER.info("Input base path: " + inputPaths);
        System.out.println(" - Input data type: " + this.inputType.getName());
        LOGGER.info("Input data type: " + this.inputType.getName());
        System.out.println(" - Output base path: " + this.outputBasePath);
        LOGGER.info("Output base path: " + this.outputBasePath);
        System.out.println(" - Output data type: " + this.outputType.getName());
        LOGGER.info("Output data type: " + this.outputType.getName());
        if (this.refBasePath != null) {
            System.out.println(" - Reference base path: " + this.refBasePath);
            LOGGER.info("Reference base path: " + this.refBasePath);
            System.out.println(" - Reference data type: " + this.refType.getName());
            LOGGER.info("Reference data type: " + this.refType.getName());
            System.out.println(" - Number of flank variants to consider for LD alignment: " + this.flankSnpsToConsider);
            LOGGER.info("Number of flank variants to consider for LD alignment: " + this.flankSnpsToConsider);
            System.out.println(" - Minimum LD of flanking variants before using for LD alignment: " + this.minLdToIncludeAlign);
            LOGGER.info("Minimum LD of flanking variants before using for LD alignment: " + this.minLdToIncludeAlign);
            System.out.println(" - Minimum number of variants needed to for LD alignment: " + this.minSnpsToAlignOn);
            LOGGER.info("Minimum number of variants needed to for LD alignment: " + this.minSnpsToAlignOn);
            System.out.println(" - Maximum MAF of variants to use minor allele as backup for alignment: " + this.maxMafForMafAlignment);
            LOGGER.info("Maximum MAF of variants to use minor allele as backup for alignment: " + this.maxMafForMafAlignment);
            System.out.println(" - Update study IDs: " + (this.updateId ? "yes" : "no"));
            LOGGER.info("Update study variant IDs: " + (this.updateId ? "yes" : "no"));
            System.out.println(" - Keep variants not in reference data: " + (this.keep ? "yes" : "no"));
            LOGGER.info("Keep variants not in reference data: " + (this.keep ? "yes" : "no"));
        } else {
            System.out.println(" - Reference base path not set, not performing harmonization.");
            LOGGER.info("Reference base path not set, not performing harmonization.");
        }
        System.out.println(" - Minimum posterior probability for input data: " + this.minimumPosteriorProbability);
        LOGGER.info("Minimum posterior probability for input data: " + this.minimumPosteriorProbability);
        System.out.println(" - LD checker " + (this.ldCheck ? "on" : "off"));
        LOGGER.info("LD checker " + (this.ldCheck ? "on" : "off"));
        System.out.println(" - Force input sequence name: " + (this.forceSeqName == null ? "not forcing" : "forcing to: " + this.forceSeqName));
        LOGGER.info("Force input sequence name: " + (this.forceSeqName == null ? "not forcing" : "forcing to: " + this.forceSeqName));
        if (this.sampleFilterListFile != null) {
            LOGGER.info("Filter input data to samples present in: " + this.sampleFilterListFile);
            System.out.println(" - Filter input data to samples present in: " + this.sampleFilterListFile);
        }
        if (this.variantFilterListFile != null) {
            LOGGER.info("Filter input data to variants present in: " + this.variantFilterListFile);
            System.out.println(" - Filter input data to variants present in: " + this.variantFilterListFile);
        }
        if (this.variantPosFilterListFile != null) {
            LOGGER.info("Filter input data to variants with postions present in: " + this.variantPosFilterListFile);
            System.out.println(" - Filter input data to variants with postions present in: " + this.variantPosFilterListFile);
        }
        if (this.minMAF > 0.0f) {
            LOGGER.info("Filter input data on minimum MAF: " + this.minMAF);
            System.out.println(" - Filter input data on minimum MAF: " + this.minMAF);
        }
        if (this.minHwePvalue > 0.0) {
            LOGGER.info("Filter input data on minimum HWE p-value: " + this.minHwePvalue);
            System.out.println(" - Filter input data on minimum HWE p-value: " + this.minHwePvalue);
        }
        if (this.minCallRate > 0.0f) {
            LOGGER.info("Filter input data on minimum variant call-rate: " + this.minCallRate);
            System.out.println(" - Filter input data on minimum variant call-rate: " + this.minCallRate);
        }
        if (this.minMachR2 > 0.0) {
            LOGGER.info("Filter input data on minimum MACH R2 measure: " + this.minMachR2);
            System.out.println(" - Filter input data on minimum MACH R2 measure: " + this.minMachR2);
        }
        if (this.seqFilterIn != null) {
            LOGGER.info("Filter input data on variant on: " + this.seqFilterIn);
            System.out.println(" - Filter input data on variant on: " + this.seqFilterIn);
        }
        LOGGER.info("Debug mode: " + (this.debugMode ? "on" : "off"));
        System.out.println();
    }

    public String[] getInputBasePaths() {
        return this.inputBasePaths;
    }

    public String getRefBasePath() {
        return this.refBasePath;
    }

    public RandomAccessGenotypeDataReaderFormats getRefType() {
        return this.refType;
    }

    public String getOutputBasePath() {
        return this.outputBasePath;
    }

    public GenotypedDataWriterFormats getOutputType() {
        return this.outputType;
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public boolean isUpdateId() {
        return this.updateId;
    }

    public int getMinSnpsToAlignOn() {
        return this.minSnpsToAlignOn;
    }

    public int getFlankSnpsToConsider() {
        return this.flankSnpsToConsider;
    }

    public double getMinLdToIncludeAlign() {
        return this.minLdToIncludeAlign;
    }

    public double getMaxMafForMafAlignment() {
        return this.maxMafForMafAlignment;
    }

    public double getMinimumPosteriorProbability() {
        return this.minimumPosteriorProbability;
    }

    public String getForceSeqName() {
        return this.forceSeqName;
    }

    public boolean isLdCheck() {
        return this.ldCheck;
    }

    public boolean isKeep() {
        return this.keep;
    }

    public File getVariantFilterListFile() {
        return this.variantFilterListFile;
    }

    public File getVariantPosFilterListFile() {
        return this.variantPosFilterListFile;
    }

    public String getSeqFilterIn() {
        return this.seqFilterIn;
    }

    public File getSampleFilterListFile() {
        return this.sampleFilterListFile;
    }

    public File getLogFile() {
        return this.logFile;
    }

    public File getSnpUpdateFile() {
        return this.snpUpdateFile;
    }

    public double getMinHwePvalue() {
        return this.minHwePvalue;
    }

    public float getMinCallRate() {
        return this.minCallRate;
    }

    public float getMinMAF() {
        return this.minMAF;
    }

    public RandomAccessGenotypeDataReaderFormats getInputType() {
        return this.inputType;
    }

    public File getSnpLogFile() {
        return this.snpLogFile;
    }

    public double getMinMachR2() {
        return this.minMachR2;
    }

    static {
        OptionBuilder.withArgName("basePath");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription("The base path of the data to align. The extensions are determined based on the input data type.");
        OptionBuilder.withLongOpt("input");
        OptionBuilder.isRequired();
        Option option = OptionBuilder.create("i");
        OPTIONS.addOption(option);
        OptionBuilder.withArgName("basePath");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("The base bath of the reference data. The extensions are determined based on the reference data type.");
        OptionBuilder.withLongOpt("ref");
        option = OptionBuilder.create("r");
        OPTIONS.addOption(option);
        OptionBuilder.withArgName("type");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("The input data type. If not defined will attempt to automatically select the first matching dataset on the specified path\n* PED_MAP - plink PED MAP files.\n* PLINK_BED - plink BED BIM FAM files.\n* VCF - bgziped vcf with tabix index file\n* VCFFOLDER - matches all bgziped vcf files + tabix index in a folder\n* SHAPEIT2 - shapeit2 phased haplotypes .haps & .sample\n* GEN - Oxford .gen & .sample\n* TRITYPER - TriTyper format folder");
        OptionBuilder.withLongOpt("inputType");
        option = OptionBuilder.create("I");
        OPTIONS.addOption(option);
        OptionBuilder.withArgName("type");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("The reference data type. If not defined will attempt to automatically select the first matching dataset on the specified path\n* PED_MAP - plink PED MAP files.\n* PLINK_BED - plink BED BIM FAM files.\n* VCF - bgziped vcf with tabix index file\n* VCF_FOLDER - matches all bgziped vcf files + tabix index in a folder\n* SHAPEIT2 - shapeit2 phased haplotypes .haps & .sample\n* GEN - Oxford .gen & .sample\n* TRITYPER - TriTyper format folder");
        OptionBuilder.withLongOpt("refType");
        option = OptionBuilder.create("R");
        OPTIONS.addOption(option);
        OptionBuilder.withArgName("basePath");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("The output bash path");
        OptionBuilder.withLongOpt("output");
        OptionBuilder.isRequired();
        option = OptionBuilder.create("o");
        OPTIONS.addOption(option);
        OptionBuilder.withArgName("type");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("The output data type. Defaults to --inputType or to PLINK_BED if there is no writer for the impute type.\n* PED_MAP - plink PED MAP files\n* PLINK_BED - plink BED BIM FAM files\n* SHAPEIT2 - shapeit2 phased haplotypes\n* GEN - Oxford .gen & .sample\n* TRITYPER - TriTyper format folder");
        OptionBuilder.withLongOpt("outputType");
        option = OptionBuilder.create("O");
        OPTIONS.addOption(option);
        OptionBuilder.withArgName("int");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Number of variants on either flank to consider using for LD-strand alignment. Must be equal or larger than --min-variants. Defaults to 100");
        OptionBuilder.withLongOpt("variants");
        option = OptionBuilder.create("v");
        OPTIONS.addOption(option);
        OptionBuilder.withArgName("double");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Minimum LD between variant to align or check and a flanking variants in both input as reference. Defaults to 0.3. It is NOT recommend to set this to zero");
        OptionBuilder.withLongOpt("min-ld");
        option = OptionBuilder.create("l");
        OPTIONS.addOption(option);
        OptionBuilder.withArgName("int");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Minimum number of variants above ld-cutoff to do LD alignment. Variants that do not meet this requirement are excluded. Defaults to 3. Min value: 1");
        OptionBuilder.withLongOpt("min-variants");
        option = OptionBuilder.create("m");
        OPTIONS.addOption(option);
        OptionBuilder.withArgName("boolean");
        OptionBuilder.withDescription("Check ld structure of all variants after alignment and exclude variants that deviate. This option negates the effect of --mafAlign");
        OptionBuilder.withLongOpt("check-ld");
        option = OptionBuilder.create("c");
        OPTIONS.addOption(option);
        OptionBuilder.withArgName("boolean");
        OptionBuilder.withDescription("Activate debug mode. This will result in a more verbose log file");
        OptionBuilder.withLongOpt("debug");
        option = OptionBuilder.create("d");
        OPTIONS.addOption(option);
        OptionBuilder.withArgName("boolean");
        OptionBuilder.withDescription("Update variants IDs of study data to match reference data");
        OptionBuilder.withLongOpt("update-id");
        option = OptionBuilder.create("id");
        OPTIONS.addOption(option);
        OptionBuilder.withArgName("boolean");
        OptionBuilder.withDescription("Keep variants not present in reference data");
        OptionBuilder.withLongOpt("keep");
        option = OptionBuilder.create("k");
        OPTIONS.addOption(option);
        OptionBuilder.withArgName("string");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Shapeit2 does not output the sequence name in the first column of the haplotype file. Use this option to force the chromosome for all variants. This option is only valid in combination with --inputType SHAPEIT2");
        OptionBuilder.withLongOpt("forceChr");
        option = OptionBuilder.create("f");
        OPTIONS.addOption(option);
        OptionBuilder.withArgName("double");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("If there are not enough variants in LD and the minor allele frequency (MAF) of a variant <= the specified value in both study as in reference then the minor allele can be used as a backup for alignment. Defaults to 0.0");
        OptionBuilder.withLongOpt("mafAlign");
        option = OptionBuilder.create("ma");
        OPTIONS.addOption(option);
        OptionBuilder.withArgName("double");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("The minimum posterior probability to call genotypes in the input data 0.4");
        OptionBuilder.withLongOpt("inputProb");
        option = OptionBuilder.create("ip");
        OPTIONS.addOption(option);
        OptionBuilder.withArgName("double");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("The minimum minor allele frequency to include variant from input data");
        OptionBuilder.withLongOpt("mafFilter");
        option = OptionBuilder.create("mf");
        OPTIONS.addOption(option);
        OptionBuilder.withArgName("double");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("The minimum MACH R2 measure to include SNPs");
        OptionBuilder.withLongOpt("machR2Filter");
        option = OptionBuilder.create("mrf");
        OPTIONS.addOption(option);
        OptionBuilder.withArgName("double");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("The minimum call rate to include variant from input data");
        OptionBuilder.withLongOpt("callRateFilter");
        option = OptionBuilder.create("cf");
        OPTIONS.addOption(option);
        OptionBuilder.withArgName("double");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("The minimum hardy weinberg equilibrium p-value to include variant from input data");
        OptionBuilder.withLongOpt("hweFilter");
        option = OptionBuilder.create("hf");
        OPTIONS.addOption(option);
        OptionBuilder.withArgName("string");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Filter input data on chromosome");
        OptionBuilder.withLongOpt("chrFilter");
        option = OptionBuilder.create("ch");
        OPTIONS.addOption(option);
        OptionBuilder.withArgName("string");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Path to file with variant IDs to include from input data.");
        OptionBuilder.withLongOpt("variantFilterList");
        option = OptionBuilder.create("vf");
        OPTIONS.addOption(option);
        OptionBuilder.withArgName("string");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Path to file with samples IDs to include from input data. For plink data only the sample id (column 2) is used");
        OptionBuilder.withLongOpt("sampleFilterList");
        option = OptionBuilder.create("sf");
        OPTIONS.addOption(option);
        OptionBuilder.withArgName("string");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Path to file with variant CHR\tPOS or CHR:POS to include from input data.");
        OptionBuilder.withLongOpt("variantPosFilterList");
        option = OptionBuilder.create("pf");
        OPTIONS.addOption(option);
    }
}

