/*
 * Decompiled with CFR 0.152.
 */
package JSci.awt;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;

public abstract class DoubleBufferedCanvas
extends Canvas {
    private Image buffer = null;
    private boolean doRedraw = true;

    public final void paint(Graphics graphics) {
        if (this.doRedraw) {
            this.doRedraw = false;
            int n = this.getSize().width;
            int n2 = this.getSize().height;
            this.buffer = this.createImage(n, n2);
            if (this.buffer == null) {
                return;
            }
            Graphics graphics2 = this.buffer.getGraphics();
            Color color = graphics2.getColor();
            graphics2.setColor(this.getBackground());
            graphics2.fillRect(0, 0, n, n2);
            graphics2.setColor(color);
            this.offscreenPaint(graphics2);
        }
        graphics.drawImage(this.buffer, 0, 0, null);
    }

    public final void update(Graphics graphics) {
        this.paint(graphics);
    }

    public final void print(Graphics graphics) {
        this.offscreenPaint(graphics);
    }

    public final void redraw() {
        this.doRedraw = true;
        this.repaint();
    }

    protected final Graphics getOffscreenGraphics() {
        return this.buffer != null ? this.buffer.getGraphics() : null;
    }

    protected abstract void offscreenPaint(Graphics var1);
}

