/*
 * Decompiled with CFR 0.152.
 */
package JSci.awt;

import JSci.awt.AbstractGraphModel;
import JSci.awt.CategoryGraph2DModel;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;

public final class DefaultCategoryGraph2DModel
extends AbstractGraphModel
implements CategoryGraph2DModel,
TableModelListener {
    private static final int X_AXIS_COLUMN = 0;
    private static final int SERIES_COLUMN = 1;
    private Object[] defaultCategories = new Object[0];
    private final List series = new ArrayList();
    private int pos = 0;
    private DataSeries curSeries = null;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Float;

    public void setCategories(Object[] objectArray) {
        if (this.defaultCategories.length != objectArray.length) {
            this.defaultCategories = new Object[objectArray.length];
        }
        System.arraycopy(objectArray, 0, this.defaultCategories, 0, objectArray.length);
    }

    public void addSeries(float[] fArray) {
        this.addSeries(new DataSeries(this.defaultCategories, fArray));
    }

    public void addSeries(double[] dArray) {
        this.addSeries(new DataSeries(this.defaultCategories, dArray));
    }

    public void addSeries(DataSeries dataSeries) {
        this.series.add(dataSeries);
        this.fireGraphDataChanged();
        dataSeries.addTableModelListener(this);
    }

    public void addSeries(Object[] objectArray, float[] fArray) {
        this.addSeries(new DataSeries(objectArray, fArray));
    }

    public void addSeries(Object[] objectArray, double[] dArray) {
        this.addSeries(new DataSeries(objectArray, dArray));
    }

    public void changeSeries(int n, DataSeries dataSeries) {
        this.getSeries(n).removeTableModelListener(this);
        this.series.set(n, dataSeries);
        this.fireGraphDataChanged();
        dataSeries.addTableModelListener(this);
    }

    public void changeSeries(int n, float[] fArray) {
        this.getSeries(n).setValues(fArray);
    }

    public void changeSeries(int n, double[] dArray) {
        this.getSeries(n).setValues(dArray);
    }

    public void removeSeries(int n) {
        this.getSeries(n).removeTableModelListener(this);
        this.series.remove(n);
        this.fireGraphDataChanged();
    }

    public DataSeries getSeries(int n) {
        return (DataSeries)this.series.get(n);
    }

    public void setSeriesVisible(int n, boolean bl) {
        this.getSeries(n).setVisible(bl);
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        if (tableModelEvent.getColumn() == 1) {
            this.fireGraphSeriesUpdated(this.series.indexOf(tableModelEvent.getSource()));
        }
    }

    public String getCategory(int n) {
        return this.curSeries.getCategory(n).toString();
    }

    public float getValue(int n) {
        return this.curSeries.getValue(n);
    }

    public int seriesLength() {
        return this.curSeries.length();
    }

    public void firstSeries() {
        this.curSeries = this.getSeries(0);
        this.pos = 0;
        while (!this.curSeries.isVisible() && this.pos < this.series.size() - 1) {
            this.curSeries = this.getSeries(++this.pos);
        }
    }

    public boolean nextSeries() {
        if (this.pos == this.series.size() - 1) {
            return false;
        }
        do {
            this.curSeries = this.getSeries(++this.pos);
        } while (!this.curSeries.isVisible() && this.pos < this.series.size() - 1);
        return this.curSeries.isVisible();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class DataSeries
    extends AbstractTableModel {
        protected Object[] xAxis = new Object[0];
        protected float[] series = new float[0];
        private boolean isVis = true;

        protected DataSeries() {
        }

        public DataSeries(Object[] objectArray, float[] fArray) {
            this.setCategories(objectArray);
            this.setValues(fArray);
        }

        public DataSeries(Object[] objectArray, double[] dArray) {
            this.setCategories(objectArray);
            this.setValues(dArray);
        }

        public void setCategories(Object[] objectArray) {
            if (this.xAxis.length != objectArray.length) {
                this.xAxis = new Object[objectArray.length];
            }
            System.arraycopy(objectArray, 0, this.xAxis, 0, objectArray.length);
            this.fireTableColumnUpdated(0);
        }

        public void setValues(float[] fArray) {
            if (this.series.length != fArray.length) {
                this.series = new float[fArray.length];
            }
            System.arraycopy(fArray, 0, this.series, 0, fArray.length);
            this.fireTableColumnUpdated(1);
        }

        public void setValues(double[] dArray) {
            if (this.series.length != dArray.length) {
                this.series = new float[dArray.length];
            }
            for (int i = 0; i < dArray.length; ++i) {
                this.series[i] = (float)dArray[i];
            }
            this.fireTableColumnUpdated(1);
        }

        public Object getCategory(int n) {
            return this.xAxis[n];
        }

        public void setCategory(int n, Object object) {
            this.xAxis[n] = object;
            this.fireTableCellUpdated(n, 0);
        }

        public float getValue(int n) {
            return this.series[n];
        }

        public void setValue(int n, float f) {
            this.series[n] = f;
            this.fireTableCellUpdated(n, 1);
        }

        public int length() {
            return Math.min(this.xAxis.length, this.series.length);
        }

        public final void setVisible(boolean bl) {
            if (bl != this.isVis) {
                this.isVis = bl;
                this.fireTableDataChanged();
            }
        }

        public final boolean isVisible() {
            return this.isVis;
        }

        private void fireTableColumnUpdated(int n) {
            if (n == 0) {
                this.fireTableChanged(new TableModelEvent(this, 0, this.xAxis.length - 1, n));
            } else if (n == 1) {
                this.fireTableChanged(new TableModelEvent(this, 0, this.series.length - 1, n));
            }
        }

        public String getColumnName(int n) {
            if (n == 0) {
                return "X";
            }
            if (n == 1) {
                return "Y";
            }
            return null;
        }

        public Class getColumnClass(int n) {
            if (n == 0) {
                return class$java$lang$Object == null ? (class$java$lang$Object = DefaultCategoryGraph2DModel.class$("java.lang.Object")) : class$java$lang$Object;
            }
            return class$java$lang$Float == null ? (class$java$lang$Float = DefaultCategoryGraph2DModel.class$("java.lang.Float")) : class$java$lang$Float;
        }

        public final int getRowCount() {
            return this.length();
        }

        public final int getColumnCount() {
            return 2;
        }

        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return this.getCategory(n);
            }
            if (n2 == 1) {
                return new Float(this.getValue(n));
            }
            return null;
        }

        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 0) {
                this.setCategory(n, object);
            } else if (n2 == 1) {
                this.setValue(n, ((Float)object).floatValue());
            }
        }

        public boolean isCellEditable(int n, int n2) {
            return true;
        }
    }
}

