/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.genotype.vcf;

import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sf.samtools.util.BlockCompressedInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.molgenis.genotype.AbstractRandomAccessGenotypeData;
import org.molgenis.genotype.Allele;
import org.molgenis.genotype.Alleles;
import org.molgenis.genotype.GenotypeDataException;
import org.molgenis.genotype.Sample;
import org.molgenis.genotype.Sequence;
import org.molgenis.genotype.SimpleSequence;
import org.molgenis.genotype.annotation.Annotation;
import org.molgenis.genotype.annotation.SampleAnnotation;
import org.molgenis.genotype.annotation.VcfAnnotation;
import org.molgenis.genotype.tabix.TabixFileNotFoundException;
import org.molgenis.genotype.tabix.TabixIndex;
import org.molgenis.genotype.util.CalledDosageConvertor;
import org.molgenis.genotype.util.FixedSizeIterable;
import org.molgenis.genotype.util.ProbabilitiesConvertor;
import org.molgenis.genotype.variant.GeneticVariant;
import org.molgenis.genotype.variant.GeneticVariantMeta;
import org.molgenis.genotype.variant.GenotypeRecord;
import org.molgenis.genotype.variant.ReadOnlyGeneticVariant;
import org.molgenis.genotype.variant.sampleProvider.CachedSampleVariantProvider;
import org.molgenis.genotype.variant.sampleProvider.SampleVariantUniqueIdProvider;
import org.molgenis.genotype.variant.sampleProvider.SampleVariantsProvider;
import org.molgenis.genotype.vcf.VcfGeneticVariantMeta;
import org.molgenis.genotype.vcf.VcfGenotypeRecord;
import org.molgenis.vcf.VcfInfo;
import org.molgenis.vcf.VcfReader;
import org.molgenis.vcf.VcfRecord;
import org.molgenis.vcf.VcfSample;
import org.molgenis.vcf.meta.VcfMeta;
import org.molgenis.vcf.meta.VcfMetaContig;
import org.molgenis.vcf.meta.VcfMetaInfo;

public class VcfGenotypeData
extends AbstractRandomAccessGenotypeData
implements SampleVariantsProvider {
    private static final Logger LOG = Logger.getLogger(VcfGenotypeData.class);
    private final File bzipVcfFile;
    private final TabixIndex tabixIndex;
    private final int sampleVariantProviderUniqueId;
    private final SampleVariantsProvider variantProvider;
    private final VcfMeta vcfMeta;
    private transient Map<String, Annotation> cachedSampleAnnotationsMap;
    private transient GeneticVariant cachedGeneticVariant;
    private transient VcfRecord cachedVcfRecord;
    private static int totalRandomAccessRequest = 0;
    private static int currentlyOpenFileHandlers = 0;
    private static int closedFileHandlers = 0;
    private final double minimumPosteriorProbabilityToCall;

    public VcfGenotypeData(File bzipVcfFile, int cacheSize, double minimumPosteriorProbabilityToCall) throws FileNotFoundException, IOException {
        this(bzipVcfFile, new File(bzipVcfFile.getAbsolutePath() + ".tbi"), cacheSize, minimumPosteriorProbabilityToCall);
    }

    public VcfGenotypeData(File bzipVcfFile, File tabixIndexFile, double minimumPosteriorProbabilityToCall) throws FileNotFoundException, IOException {
        this(bzipVcfFile, tabixIndexFile, 100, minimumPosteriorProbabilityToCall);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VcfGenotypeData(File bzipVcfFile, File tabixIndexFile, int cacheSize, double minimumPosteriorProbabilityToCall) throws FileNotFoundException, IOException {
        if (!bzipVcfFile.isFile()) {
            throw new FileNotFoundException("VCF file not found at " + bzipVcfFile.getAbsolutePath());
        }
        if (!bzipVcfFile.canRead()) {
            throw new IOException("Cannot access VCF file at: " + bzipVcfFile.getAbsolutePath());
        }
        if (!tabixIndexFile.isFile()) {
            throw new TabixFileNotFoundException(tabixIndexFile.getAbsolutePath(), "VCF tabix file not found at " + tabixIndexFile.getAbsolutePath());
        }
        if (!tabixIndexFile.canRead()) {
            throw new IOException("Cannot read tabix file for VCF at: " + tabixIndexFile.getAbsolutePath());
        }
        if (minimumPosteriorProbabilityToCall < 0.0 || minimumPosteriorProbabilityToCall > 1.0) {
            throw new GenotypeDataException("Min posterior probability to call must be >0 and <=1 not:" + minimumPosteriorProbabilityToCall);
        }
        this.bzipVcfFile = bzipVcfFile;
        this.tabixIndex = new TabixIndex(tabixIndexFile, bzipVcfFile, null);
        this.minimumPosteriorProbabilityToCall = minimumPosteriorProbabilityToCall;
        VcfReader vcfReader = new VcfReader(new BlockCompressedInputStream(bzipVcfFile));
        try {
            this.vcfMeta = vcfReader.getVcfMeta();
        }
        finally {
            vcfReader.close();
        }
        this.variantProvider = cacheSize <= 0 ? this : new CachedSampleVariantProvider(this, cacheSize);
        this.sampleVariantProviderUniqueId = SampleVariantUniqueIdProvider.getNextUniqueId();
    }

    @Override
    public Iterator<GeneticVariant> iterator() {
        BlockCompressedInputStream inputStream;
        try {
            inputStream = new BlockCompressedInputStream(this.bzipVcfFile);
        }
        catch (IOException e) {
            throw new GenotypeDataException(e);
        }
        final VcfReader vcfReader = new VcfReader(inputStream);
        return new Iterator<GeneticVariant>(){
            private final Iterator<VcfRecord> it;
            {
                this.it = vcfReader.iterator();
            }

            @Override
            public boolean hasNext() {
                boolean hasNext = this.it.hasNext();
                if (!hasNext) {
                    try {
                        vcfReader.close();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                return hasNext;
            }

            @Override
            public GeneticVariant next() {
                VcfRecord vcfRecord = this.it.next();
                return VcfGenotypeData.this.toGeneticVariant(vcfRecord);
            }

            @Override
            public void remove() {
                this.it.remove();
            }
        };
    }

    @Override
    public List<Alleles> getSampleVariants(GeneticVariant variant) {
        VcfRecord vcfRecord = this.getVcfRecord(variant);
        int nrSamples = vcfRecord.getNrSamples();
        if (nrSamples == 0) {
            return Collections.emptyList();
        }
        int idx = vcfRecord.getFormatIndex("GT");
        if (idx != -1) {
            ArrayList<Alleles> alleles = new ArrayList<Alleles>(nrSamples);
            for (VcfSample vcfSample : vcfRecord.getSamples()) {
                List<Allele> vcfAlleles = vcfSample.getAlleles();
                alleles.add(Alleles.createAlleles(vcfAlleles));
            }
            return alleles;
        }
        if (vcfRecord.getFormatIndex("GP") != -1) {
            return ProbabilitiesConvertor.convertProbabilitiesToAlleles(this.getSampleProbilities(variant), variant.getVariantAlleles(), this.minimumPosteriorProbabilityToCall);
        }
        if (vcfRecord.getFormatIndex("DS") != -1) {
            return CalledDosageConvertor.convertDosageToAlleles(this.getSampleDosage(variant), variant.getVariantAlleles());
        }
        ArrayList<Alleles> sampleAlleles = new ArrayList<Alleles>(nrSamples);
        for (int i = 0; i < nrSamples; ++i) {
            sampleAlleles.add(Alleles.BI_ALLELIC_MISSING);
        }
        return sampleAlleles;
    }

    @Override
    public Map<String, Annotation> getVariantAnnotationsMap() {
        if (this.cachedSampleAnnotationsMap == null) {
            this.cachedSampleAnnotationsMap = new LinkedHashMap<String, Annotation>();
            for (VcfMetaInfo info : this.vcfMeta.getInfoMeta()) {
                this.cachedSampleAnnotationsMap.put(info.getId(), VcfAnnotation.fromVcfInfo(info));
            }
        }
        return this.cachedSampleAnnotationsMap;
    }

    public List<Sequence> getSequences() {
        List<String> seqNames = this.getSeqNames();
        HashMap<String, Integer> sequenceLengthById = new HashMap<String, Integer>();
        for (VcfMetaContig contig : this.vcfMeta.getContigMeta()) {
            sequenceLengthById.put(contig.getId(), contig.getLength());
        }
        ArrayList<Sequence> sequences = new ArrayList<Sequence>(seqNames.size());
        for (String seqName : seqNames) {
            sequences.add(new SimpleSequence(seqName, (Integer)sequenceLengthById.get(seqName), this));
        }
        return sequences;
    }

    @Override
    public List<Sample> getSamples() {
        ArrayList<Sample> samples = new ArrayList<Sample>();
        for (String sampleName : this.vcfMeta.getSampleNames()) {
            samples.add(new Sample(sampleName, null, null));
        }
        return samples;
    }

    @Override
    public int cacheSize() {
        return 0;
    }

    @Override
    public List<Boolean> getSamplePhasing(GeneticVariant variant) {
        VcfRecord vcfRecord = this.getVcfRecord(variant);
        int nrSamples = vcfRecord.getNrSamples();
        if (nrSamples == 0) {
            return Collections.emptyList();
        }
        ArrayList<Boolean> phasing = new ArrayList<Boolean>(nrSamples);
        for (VcfSample vcfSample : vcfRecord.getSamples()) {
            List<Boolean> genotypePhasings = vcfSample.getPhasings();
            if (genotypePhasings == null || genotypePhasings.isEmpty()) {
                phasing.add(Boolean.FALSE);
                continue;
            }
            if (genotypePhasings.size() == 1) {
                phasing.add(genotypePhasings.get(0));
                continue;
            }
            if (genotypePhasings.contains(Boolean.FALSE)) {
                phasing.add(Boolean.FALSE);
                continue;
            }
            phasing.add(Boolean.TRUE);
        }
        return phasing;
    }

    @Override
    public int getSampleVariantProviderUniqueId() {
        return this.sampleVariantProviderUniqueId;
    }

    @Override
    public Map<String, SampleAnnotation> getSampleAnnotationsMap() {
        return Collections.emptyMap();
    }

    @Override
    public byte[] getSampleCalledDosage(GeneticVariant variant) {
        return CalledDosageConvertor.convertCalledAllelesToCalledDosage(this.getSampleVariants(variant), variant.getVariantAlleles(), variant.getRefAllele());
    }

    @Override
    public float[] getSampleDosage(GeneticVariant variant) {
        float[] dosages;
        VcfRecord vcfRecord = this.getVcfRecord(variant);
        int nrSamples = vcfRecord.getNrSamples();
        if (nrSamples == 0) {
            return new float[0];
        }
        int idx = vcfRecord.getFormatIndex("DS");
        if (idx != -1) {
            dosages = new float[nrSamples];
            int i = 0;
            for (VcfSample vcfSample : vcfRecord.getSamples()) {
                String dosage = vcfSample.getData(idx);
                if (dosage == null) {
                    dosages[i++] = -1.0f;
                    continue;
                }
                try {
                    dosages[i++] = Math.abs((Float.parseFloat(dosage) - 2.0f) * -1.0f);
                }
                catch (NumberFormatException e) {
                    throw new GenotypeDataException("Error in sample dosage (DS) value for sample [" + this.vcfMeta.getSampleName(i) + "], found value: " + dosage);
                }
            }
        } else if (vcfRecord.getFormatIndex("GP") != -1) {
            dosages = ProbabilitiesConvertor.convertProbabilitiesToDosage(this.getSampleProbilities(variant), this.minimumPosteriorProbabilityToCall);
        } else if (vcfRecord.getFormatIndex("GT") != -1) {
            dosages = CalledDosageConvertor.convertCalledAllelesToDosage(this.getSampleVariants(variant), variant.getVariantAlleles(), variant.getRefAllele());
        } else {
            dosages = new float[nrSamples];
            for (int i = 0; i < nrSamples; ++i) {
                dosages[i] = -1.0f;
            }
        }
        return dosages;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public boolean isOnlyContaingSaveProbabilityGenotypes() {
        return false;
    }

    @Override
    public float[][] getSampleProbilities(GeneticVariant variant) {
        VcfRecord vcfRecord = this.getVcfRecord(variant);
        int nrSamples = vcfRecord.getNrSamples();
        if (nrSamples == 0) {
            return new float[0][0];
        }
        float[][] probs = null;
        int idx = vcfRecord.getFormatIndex("GP");
        if (idx != -1) {
            probs = new float[nrSamples][3];
            int i = 0;
            for (VcfSample vcfSample : vcfRecord.getSamples()) {
                String probabilitiesStr = vcfSample.getData(idx);
                if (probabilitiesStr == null) {
                    probs[i] = new float[]{0.0f, 0.0f, 0.0f};
                } else {
                    String[] probabilities = StringUtils.split((String)probabilitiesStr, (char)',');
                    if (probabilities.length != 3) {
                        throw new GenotypeDataException("Error in sample prob (GP) value for sample [" + this.vcfMeta.getSampleName(i) + "], found value: " + probabilitiesStr);
                    }
                    for (int j = 0; j < 3; ++j) {
                        try {
                            probs[i][j] = Float.parseFloat(probabilities[j]);
                            continue;
                        }
                        catch (NumberFormatException e) {
                            throw new GenotypeDataException("Error in sample prob (GP) value for sample [" + this.vcfMeta.getSampleName(i) + "], found value: " + probabilitiesStr);
                        }
                    }
                }
                ++i;
            }
        } else {
            probs = vcfRecord.getFormatIndex("GT") != -1 ? ProbabilitiesConvertor.convertCalledAllelesToProbability(this.getSampleVariants(variant), variant.getVariantAlleles()) : (vcfRecord.getFormatIndex("DS") != -1 ? ProbabilitiesConvertor.convertDosageToProbabilityHeuristic(this.getSampleDosage(variant)) : new float[nrSamples][3]);
        }
        return probs;
    }

    @Override
    public FixedSizeIterable<GenotypeRecord> getSampleGenotypeRecords(GeneticVariant variant) {
        final VcfRecord vcfRecord = this.getVcfRecord(variant);
        return new FixedSizeIterable<GenotypeRecord>(){

            @Override
            public Iterator<GenotypeRecord> iterator() {
                Iterable<VcfSample> samples = vcfRecord.getSamples();
                return Iterators.transform(samples.iterator(), (Function)new Function<VcfSample, GenotypeRecord>(){

                    public GenotypeRecord apply(VcfSample vcfSample) {
                        return VcfGenotypeData.this.toGenotypeRecord(vcfRecord, vcfSample);
                    }
                });
            }

            @Override
            public int size() {
                return vcfRecord.getNrSamples();
            }
        };
    }

    @Override
    public List<String> getSeqNames() {
        return new ArrayList<String>(this.tabixIndex.getSeqNames());
    }

    @Override
    public Iterable<GeneticVariant> getSequenceGeneticVariants(String seqName) {
        return this.getVariantsByRange(seqName, 0, Integer.MAX_VALUE);
    }

    @Override
    public Iterable<GeneticVariant> getVariantsByPos(String seqName, int startPos) {
        return this.getVariantsByRange(seqName, startPos - 1, startPos);
    }

    @Override
    public GeneticVariant getSnpVariantByPos(String seqName, int startPos) {
        Iterable<GeneticVariant> variants = this.getVariantsByPos(seqName, startPos);
        GeneticVariant snp = null;
        for (GeneticVariant variant : variants) {
            if (snp != null || !variant.isSnp()) continue;
            snp = variant;
        }
        return snp;
    }

    @Override
    public Iterable<GeneticVariant> getVariantsByRange(final String seqName, final int rangeStart, final int rangeEnd) {
        if (rangeStart < 0) {
            throw new GenotypeDataException("Illegal start pos for VCF variant query: " + rangeStart);
        }
        return new Iterable<GeneticVariant>(){

            @Override
            public Iterator<GeneticVariant> iterator() {
                try {
                    ++totalRandomAccessRequest;
                    ++currentlyOpenFileHandlers;
                    return new Iterator<GeneticVariant>(){
                        private final BlockCompressedInputStream stream;
                        private final TabixIndex.TabixIterator it;
                        private String line;
                        {
                            this.stream = new BlockCompressedInputStream(VcfGenotypeData.this.bzipVcfFile);
                            this.it = VcfGenotypeData.this.tabixIndex.queryTabixIndex(seqName, rangeStart, rangeEnd, this.stream);
                            this.line = this.readFirst(this.it);
                        }

                        private String readFirst(TabixIndex.TabixIterator it) {
                            if (it == null) {
                                try {
                                    this.stream.close();
                                }
                                catch (IOException e) {
                                    throw new GenotypeDataException(e);
                                }
                                --currentlyOpenFileHandlers;
                                ++closedFileHandlers;
                                return null;
                            }
                            try {
                                String firstLine = it.next();
                                if (firstLine == null) {
                                    --currentlyOpenFileHandlers;
                                    ++closedFileHandlers;
                                    it.close();
                                }
                                return firstLine;
                            }
                            catch (IOException e) {
                                throw new GenotypeDataException(e);
                            }
                        }

                        @Override
                        public boolean hasNext() {
                            return this.line != null;
                        }

                        @Override
                        public GeneticVariant next() {
                            VcfRecord vcfRecord = new VcfRecord(VcfGenotypeData.this.vcfMeta, StringUtils.split((String)this.line, (char)'\t'));
                            try {
                                this.line = this.it.next();
                                if (this.line == null) {
                                    --currentlyOpenFileHandlers;
                                    ++closedFileHandlers;
                                    this.it.close();
                                }
                            }
                            catch (IOException e) {
                                throw new GenotypeDataException(e);
                            }
                            return VcfGenotypeData.this.toGeneticVariant(vcfRecord);
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }
                catch (FileNotFoundException e) {
                    if (e.getMessage().endsWith("(Too many open files)")) {
                        throw new GenotypeDataException("VCF reader trying to open more file connections than allowed by operating system. Currently open connections: " + currentlyOpenFileHandlers + " total opened: " + totalRandomAccessRequest + " total closed: " + closedFileHandlers, e);
                    }
                    throw new GenotypeDataException(e);
                }
                catch (IOException e) {
                    throw new GenotypeDataException(e);
                }
            }
        };
    }

    private VcfRecord getVcfRecord(GeneticVariant variant) {
        if (!variant.equals(this.cachedGeneticVariant)) {
            BlockCompressedInputStream stream = null;
            ++totalRandomAccessRequest;
            ++currentlyOpenFileHandlers;
            try {
                String line;
                stream = new BlockCompressedInputStream(this.bzipVcfFile);
                TabixIndex.TabixIterator it = this.tabixIndex.queryTabixIndex(variant.getSequenceName(), variant.getStartPos() - 1, variant.getStartPos(), stream);
                while ((line = it.next()) != null) {
                    VcfRecord vcfRecord = new VcfRecord(this.vcfMeta, StringUtils.split((String)line, (char)'\t'));
                    if (!variant.equals(this.toGeneticVariant(vcfRecord))) continue;
                    this.cachedVcfRecord = vcfRecord;
                    this.cachedGeneticVariant = variant;
                    break;
                }
                stream.close();
            }
            catch (FileNotFoundException e) {
                if (e.getMessage().endsWith("(Too many open files)")) {
                    throw new GenotypeDataException("VCF reader trying to open more file connections than allowed by operating system. Currently open connections: " + currentlyOpenFileHandlers + " total opened: " + totalRandomAccessRequest + " total closed: " + closedFileHandlers, e);
                }
                throw new GenotypeDataException(e);
            }
            catch (IOException e) {
                throw new GenotypeDataException(e);
            }
            finally {
                --currentlyOpenFileHandlers;
                ++closedFileHandlers;
                IOUtils.closeQuietly((InputStream)stream);
            }
        }
        return this.cachedVcfRecord;
    }

    private GeneticVariant toGeneticVariant(VcfRecord vcfRecord) {
        Alleles alleles;
        List<String> identifiers = vcfRecord.getIdentifiers();
        int pos = vcfRecord.getPosition();
        String sequenceName = vcfRecord.getChromosome();
        Allele refAllele = vcfRecord.getReferenceAllele();
        List<Allele> altAlleles = vcfRecord.getAlternateAlleles();
        HashMap<String, Object> annotationMap = new HashMap<String, Object>();
        for (VcfInfo vcfInfo : vcfRecord.getInformation()) {
            annotationMap.put(vcfInfo.getKey(), vcfInfo.getVal());
        }
        if (altAlleles == null || altAlleles.isEmpty()) {
            alleles = Alleles.createAlleles(refAllele);
        } else {
            ArrayList<Allele> allelesList = new ArrayList<Allele>(altAlleles.size() + 1);
            allelesList.add(refAllele);
            allelesList.addAll(altAlleles);
            alleles = Alleles.createAlleles(allelesList);
        }
        VcfGeneticVariantMeta geneticVariantMeta = new VcfGeneticVariantMeta(this.vcfMeta, Arrays.asList(vcfRecord.getFormat()));
        GeneticVariant geneticVariant = ReadOnlyGeneticVariant.createVariant((GeneticVariantMeta)geneticVariantMeta, identifiers, pos, sequenceName, annotationMap, this.variantProvider, alleles, refAllele);
        this.cachedVcfRecord = vcfRecord;
        this.cachedGeneticVariant = geneticVariant;
        return geneticVariant;
    }

    private GenotypeRecord toGenotypeRecord(VcfRecord vcfRecord, VcfSample vcfSample) {
        return new VcfGenotypeRecord(this.vcfMeta, vcfRecord, vcfSample);
    }
}

