/*
 * Decompiled with CFR 0.152.
 */
package JSci.awt;

import JSci.awt.DoubleBufferedCanvas;
import JSci.awt.Graph2DModel;
import JSci.awt.GraphDataEvent;
import JSci.awt.GraphDataListener;
import JSci.maths.ExtraMath;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public class Histogram
extends DoubleBufferedCanvas
implements GraphDataListener {
    protected Graph2DModel model;
    protected Point origin = new Point();
    protected Color[] seriesColor = new Color[]{Color.blue, Color.green, Color.red, Color.yellow, Color.cyan, Color.lightGray, Color.magenta, Color.orange, Color.pink};
    protected boolean numbering = true;
    protected NumberFormat xNumberFormat = new DecimalFormat("##0.0");
    protected NumberFormat yNumberFormat = new DecimalFormat("##0.0");
    protected boolean gridLines = false;
    private final Color gridLineColor = Color.lightGray;
    private float xScale;
    private float yScale;
    private float minX;
    private float minY;
    private float maxX;
    private float maxY;
    private boolean autoXExtrema = true;
    private boolean autoYExtrema = true;
    private float xGrowth;
    private float yGrowth;
    private final float xIncPixels = 40.0f;
    private final float yIncPixels = 40.0f;
    private float xInc;
    private float yInc;
    private boolean autoXInc = true;
    private boolean autoYInc = true;
    protected final int scalePad = 5;
    protected final int axisPad = 25;
    protected int leftAxisPad;

    public Histogram(Graph2DModel graph2DModel) {
        this.model = graph2DModel;
        this.model.addGraphDataListener(this);
        this.dataChanged(new GraphDataEvent(this.model));
    }

    public final void setModel(Graph2DModel graph2DModel) {
        this.model.removeGraphDataListener(this);
        this.model = graph2DModel;
        this.model.addGraphDataListener(this);
        this.dataChanged(new GraphDataEvent(this.model));
    }

    public final Graph2DModel getModel() {
        return this.model;
    }

    public void dataChanged(GraphDataEvent graphDataEvent) {
        if (graphDataEvent.isIncremental()) {
            Graphics graphics = this.getOffscreenGraphics();
            if (graphics == null) {
                return;
            }
            int n = graphDataEvent.getSeries();
            if (n == -1) {
                this.model.firstSeries();
                int n2 = 0;
                do {
                    int n3 = this.model.seriesLength() - 1;
                    this.incrementalRescale(this.model.getXCoord(n3), this.model.getYCoord(n3));
                    graphics.setColor(this.seriesColor[n2]);
                    this.drawDataPoint(graphics, n3);
                    ++n2;
                } while (this.model.nextSeries());
            } else {
                int n4;
                this.model.firstSeries();
                for (n4 = 0; n4 < n; ++n4) {
                    this.model.nextSeries();
                }
                int n5 = this.model.seriesLength() - 1;
                this.incrementalRescale(this.model.getXCoord(n5), this.model.getYCoord(n5));
                graphics.setColor(this.seriesColor[n4]);
                this.drawDataPoint(graphics, n5);
            }
            this.repaint();
        } else {
            int n = 1;
            this.model.firstSeries();
            while (this.model.nextSeries()) {
                ++n;
            }
            if (n > this.seriesColor.length) {
                Color[] colorArray = this.seriesColor;
                this.seriesColor = new Color[n];
                System.arraycopy(colorArray, 0, this.seriesColor, 0, colorArray.length);
                for (int i = colorArray.length; i < n; ++i) {
                    this.seriesColor[i] = this.seriesColor[i - colorArray.length];
                }
            }
            if (this.autoXExtrema) {
                this.setXExtrema(0.0f, 0.0f);
            }
            if (this.autoYExtrema) {
                this.setYExtrema(0.0f, 0.0f);
            }
            this.redraw();
        }
    }

    private void incrementalRescale(float f, float f2) {
        float f3 = f < this.minX ? (this.autoXExtrema ? Math.min(f, this.minX - this.xGrowth) : this.minX - this.xGrowth) : this.minX;
        float f4 = f > this.maxX ? (this.autoXExtrema ? Math.max(f, this.maxX + this.xGrowth) : this.maxX + this.xGrowth) : this.maxX;
        this.rescaleX(f3, f4);
        f3 = f2 < this.minY ? (this.autoYExtrema ? Math.min(f2, this.minY - this.yGrowth) : this.minY - this.yGrowth) : this.minY;
        f4 = f2 > this.maxY ? (this.autoYExtrema ? Math.max(f2, this.maxY + this.yGrowth) : this.maxY + this.yGrowth) : this.maxY;
        this.rescaleY(f3, f4);
    }

    public final void setNumbering(boolean bl) {
        this.numbering = bl;
        this.leftAxisPad = 25;
        if (this.numbering && this.getFont() != null) {
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            int n = fontMetrics.stringWidth(this.yNumberFormat.format(this.maxY));
            int n2 = fontMetrics.stringWidth(this.yNumberFormat.format(this.minY));
            int n3 = Math.max(n2, n);
            if (this.minX < 0.0f) {
                int n4 = (int)((float)(Math.max(this.getSize().width, this.getMinimumSize().width) - 60) * this.minX / (this.minX - this.maxX));
                n3 = Math.max(n3 - n4, 0);
            }
            this.leftAxisPad += n3;
        }
        this.rescale();
    }

    public void addNotify() {
        super.addNotify();
        this.setNumbering(this.numbering);
    }

    public final void setNumberFormat(NumberFormat numberFormat) {
        this.xNumberFormat = numberFormat;
        this.yNumberFormat = numberFormat;
        this.setNumbering(this.numbering);
    }

    public final void setXNumberFormat(NumberFormat numberFormat) {
        this.xNumberFormat = numberFormat;
        this.setNumbering(this.numbering);
    }

    public final void setYNumberFormat(NumberFormat numberFormat) {
        this.yNumberFormat = numberFormat;
        this.setNumbering(this.numbering);
    }

    public final void setGridLines(boolean bl) {
        this.gridLines = bl;
        this.redraw();
    }

    public final void setXIncrement(float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException("Increment should be positive.");
        }
        if (f == 0.0f) {
            if (!this.autoXInc) {
                this.autoXInc = true;
                this.rescale();
            }
        } else {
            this.autoXInc = false;
            if (f != this.xInc) {
                this.xInc = f;
                this.rescale();
            }
        }
    }

    public final float getXIncrement() {
        return this.xInc;
    }

    public final void setYIncrement(float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException("Increment should be positive.");
        }
        if (f == 0.0f) {
            if (!this.autoYInc) {
                this.autoYInc = true;
                this.rescale();
            }
        } else {
            this.autoYInc = false;
            if (f != this.yInc) {
                this.yInc = f;
                this.rescale();
            }
        }
    }

    public final float getYIncrement() {
        return this.yInc;
    }

    public final void setXExtrema(float f, float f2) {
        if (f == 0.0f && f2 == 0.0f) {
            this.autoXExtrema = true;
            f = Float.POSITIVE_INFINITY;
            f2 = Float.NEGATIVE_INFINITY;
            this.model.firstSeries();
            do {
                for (int i = 0; i < this.model.seriesLength(); ++i) {
                    float f3 = this.model.getXCoord(i);
                    if (Float.isNaN(f3)) continue;
                    f = Math.min(f3, f);
                    f2 = Math.max(f3, f2);
                }
            } while (this.model.nextSeries());
            if (f == f2) {
                f -= 0.5f;
                f2 += 0.5f;
            }
            if (f == Float.POSITIVE_INFINITY || f2 == Float.NEGATIVE_INFINITY) {
                f = -5.0f;
                f2 = 5.0f;
            }
        } else {
            if (f2 <= f) {
                throw new IllegalArgumentException("Maximum should be greater than minimum; max = " + f2 + " and min = " + f);
            }
            this.autoXExtrema = false;
        }
        this.rescaleX(f, f2);
    }

    public final void setXExtrema(float f, float f2, float f3) {
        this.setXExtrema(f, f2);
        this.xGrowth = f3;
    }

    public final float getXMinimum() {
        return this.minX;
    }

    public final float getXMaximum() {
        return this.maxX;
    }

    private void rescaleX(float f, float f2) {
        if (f != this.minX || f2 != this.maxX) {
            this.minX = f;
            this.maxX = f2;
            this.setNumbering(this.numbering);
        }
    }

    public final void setYExtrema(float f, float f2) {
        if (f == 0.0f && f2 == 0.0f) {
            this.autoYExtrema = true;
            f = Float.POSITIVE_INFINITY;
            f2 = Float.NEGATIVE_INFINITY;
            this.model.firstSeries();
            do {
                for (int i = 0; i < this.model.seriesLength(); ++i) {
                    float f3 = this.model.getYCoord(i);
                    if (Float.isNaN(f3)) continue;
                    f = Math.min(f3, f);
                    f2 = Math.max(f3, f2);
                }
            } while (this.model.nextSeries());
            if (f == f2) {
                f2 += 5.0f;
            }
            if (f == Float.POSITIVE_INFINITY || f2 == Float.NEGATIVE_INFINITY) {
                f = 0.0f;
                f2 = 5.0f;
            }
        } else {
            if (f2 <= f) {
                throw new IllegalArgumentException("Maximum should be greater than minimum; max = " + f2 + " and min = " + f);
            }
            this.autoYExtrema = false;
        }
        this.rescaleY(f, f2);
    }

    public final void setYExtrema(float f, float f2, float f3) {
        this.setYExtrema(f, f2);
        this.yGrowth = f3;
    }

    public final float getYMinimum() {
        return this.minY;
    }

    public final float getYMaximum() {
        return this.maxY;
    }

    private void rescaleY(float f, float f2) {
        if (f != this.minY || f2 != this.maxY) {
            this.minY = f;
            this.maxY = f2;
            this.setNumbering(this.numbering);
        }
    }

    public final Rectangle2D.Float getExtrema() {
        return new Rectangle2D.Float(this.minX, this.minY, this.maxX - this.minX, this.maxY - this.minY);
    }

    public final void setColor(int n, Color color) {
        this.seriesColor[n] = color;
        this.redraw();
    }

    public final Color getColor(int n) {
        return this.seriesColor[n];
    }

    public final void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.rescale();
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public Dimension getMinimumSize() {
        return new Dimension(170, 170);
    }

    protected final void rescale() {
        Dimension dimension = this.getMinimumSize();
        Dimension dimension2 = this.getSize();
        int n = Math.max(dimension2.width, dimension.width);
        int n2 = Math.max(dimension2.height, dimension.height);
        this.xScale = (float)((double)(n - (this.leftAxisPad + 25)) / (double)(this.maxX - this.minX));
        this.yScale = (float)((double)(n2 - 50) / (double)(this.maxY - this.minY));
        if (this.autoXInc) {
            this.xInc = (float)ExtraMath.round(40.0 / (double)this.xScale, 1);
            if (this.xInc == 0.0f) {
                this.xInc = Float.MIN_VALUE;
            }
        }
        if (this.autoYInc) {
            this.yInc = (float)ExtraMath.round(40.0 / (double)this.yScale, 1);
            if (this.yInc == 0.0f) {
                this.yInc = Float.MIN_VALUE;
            }
        }
        this.origin.x = this.leftAxisPad - Math.round(this.minX * this.xScale);
        this.origin.y = n2 - 25 + Math.round(this.minY * this.yScale);
        this.redraw();
    }

    protected final Point dataToScreen(float f, float f2) {
        return new Point(this.origin.x + Math.round(this.xScale * f), this.origin.y - Math.round(this.yScale * f2));
    }

    protected final Point2D.Float screenToData(Point point) {
        double d = (double)(point.x - this.origin.x) / (double)this.xScale;
        double d2 = (double)(this.origin.y - point.y) / (double)this.yScale;
        return new Point2D.Float((float)d, (float)d2);
    }

    protected final void drawAxes(Graphics graphics) {
        Dimension dimension = this.getSize();
        int n = dimension.width;
        int n2 = dimension.height;
        graphics.setColor(this.getForeground());
        if (this.gridLines || this.numbering) {
            Point point;
            double d;
            Point point2;
            double d2;
            float f = this.minY > 0.0f ? this.minY : (this.maxY <= 0.0f ? this.maxY : 0.0f);
            double d3 = d2 = this.minX > 0.0f ? (double)this.minX : (double)this.xInc;
            while (d2 <= (double)this.maxX) {
                point2 = this.dataToScreen((float)d2, f);
                if (this.gridLines) {
                    graphics.setColor(this.gridLineColor);
                    graphics.drawLine(point2.x, 20, point2.x, n2 - 20);
                    graphics.setColor(this.getForeground());
                }
                if (this.numbering) {
                    this.drawXLabel(graphics, d2, point2);
                }
                d2 += (double)this.xInc;
            }
            for (d2 = (double)(-this.xInc); d2 >= (double)this.minX; d2 -= (double)this.xInc) {
                point2 = this.dataToScreen((float)d2, f);
                if (this.gridLines) {
                    graphics.setColor(this.gridLineColor);
                    graphics.drawLine(point2.x, 20, point2.x, n2 - 20);
                    graphics.setColor(this.getForeground());
                }
                if (!this.numbering) continue;
                this.drawXLabel(graphics, d2, point2);
            }
            float f2 = this.minX > 0.0f ? this.minX : (this.maxX < 0.0f ? this.maxX : 0.0f);
            double d4 = d = this.minY > 0.0f ? (double)this.minY : (double)this.yInc;
            while (d <= (double)this.maxY) {
                point = this.dataToScreen(f2, (float)d);
                if (this.gridLines) {
                    graphics.setColor(this.gridLineColor);
                    graphics.drawLine(this.leftAxisPad - 5, point.y, n - 20, point.y);
                    graphics.setColor(this.getForeground());
                }
                if (this.numbering) {
                    this.drawYLabel(graphics, d, point);
                }
                d += (double)this.yInc;
            }
            for (d = (double)(-this.yInc); d >= (double)this.minY; d -= (double)this.yInc) {
                point = this.dataToScreen(f2, (float)d);
                if (this.gridLines) {
                    graphics.setColor(this.gridLineColor);
                    graphics.drawLine(this.leftAxisPad - 5, point.y, n - 20, point.y);
                    graphics.setColor(this.getForeground());
                }
                if (!this.numbering) continue;
                this.drawYLabel(graphics, d, point);
            }
        }
        if (this.minY > 0.0f) {
            graphics.drawLine(this.leftAxisPad - 5, n2 - 25, n - 20, n2 - 25);
        } else if (this.maxY < 0.0f) {
            graphics.drawLine(this.leftAxisPad - 5, 25, n - 20, 25);
        } else {
            graphics.drawLine(this.leftAxisPad - 5, this.origin.y, n - 20, this.origin.y);
        }
        if (this.minX > 0.0f) {
            graphics.drawLine(this.leftAxisPad, 20, this.leftAxisPad, n2 - 20);
        } else if (this.maxX < 0.0f) {
            graphics.drawLine(n - 25, 20, n - 25, n2 - 20);
        } else {
            graphics.drawLine(this.origin.x, 20, this.origin.x, n2 - 20);
        }
    }

    protected void drawXLabel(Graphics graphics, double d, Point point) {
        boolean bl;
        String string = this.xNumberFormat.format(d);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = fontMetrics.stringWidth(string);
        int n2 = fontMetrics.getHeight();
        boolean bl2 = bl = this.maxY <= 0.0f;
        if (bl) {
            graphics.drawLine(point.x, point.y, point.x, point.y - 5);
            graphics.drawString(string, point.x - n / 2, point.y - 7);
        } else {
            graphics.drawLine(point.x, point.y, point.x, point.y + 5);
            graphics.drawString(string, point.x - n / 2, point.y + 5 + n2);
        }
    }

    protected void drawYLabel(Graphics graphics, double d, Point point) {
        String string = this.yNumberFormat.format(d);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = fontMetrics.stringWidth(string);
        int n2 = fontMetrics.getHeight();
        graphics.drawLine(point.x, point.y, point.x - 5, point.y);
        graphics.drawString(string, point.x - 8 - n, point.y + n2 / 3);
    }

    protected void drawData(Graphics graphics) {
        int n;
        this.model.firstSeries();
        for (n = 1; n < this.model.seriesLength(); ++n) {
            graphics.setColor(this.seriesColor[0]);
            this.drawDataPoint(graphics, n);
        }
        n = 1;
        while (this.model.nextSeries()) {
            for (int i = 1; i < this.model.seriesLength(); ++i) {
                graphics.setColor(this.seriesColor[n]);
                this.drawDataPoint(graphics, i);
            }
            ++n;
        }
    }

    private void drawDataPoint(Graphics graphics, int n) {
        if (n == 0) {
            return;
        }
        float f = this.model.getYCoord(n);
        Point point = this.dataToScreen(this.model.getXCoord(n - 1), 0.0f);
        Point point2 = this.dataToScreen(this.model.getXCoord(n), f);
        int n2 = f < 0.0f ? point.y : point2.y;
        int n3 = Math.abs(point2.x - point.x);
        int n4 = Math.abs(point2.y - point.y);
        graphics.fillRect(point.x, n2, n3, n4);
        graphics.setColor(Color.black);
        graphics.drawRect(point.x, n2, n3, n4);
    }

    protected void offscreenPaint(Graphics graphics) {
        Dimension dimension = this.getSize();
        int n = dimension.width;
        int n2 = dimension.height;
        graphics.setClip(this.leftAxisPad - 5, 20, n - (this.leftAxisPad + 25 - 10), n2 - 40);
        this.drawData(graphics);
        graphics.setClip(null);
        this.drawAxes(graphics);
    }
}

