/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.genotype.util;

import org.molgenis.genotype.GenotypeDataException;
import org.molgenis.genotype.util.ProbabilitiesConvertor;

public class MachR2Calculator {
    public static double calculateMachR2(float[][] probs) {
        float[] dosages = ProbabilitiesConvertor.convertProbabilitiesToDosage(probs, 0.0);
        int nonMissingCount = 0;
        double dosageSum = 0.0;
        double dosageSqrSum = 0.0;
        for (float dosage : dosages) {
            if (dosage > 2.0f) {
                throw new GenotypeDataException("Error in calculating MACH r2, found dosage larger than 2: " + dosage);
            }
            if (!(dosage >= 0.0f)) continue;
            ++nonMissingCount;
            dosageSum += (double)dosage;
            dosageSqrSum += Math.pow(dosage, 2.0);
        }
        double estimatedAlleleFrequency = dosageSum / (double)(2 * nonMissingCount);
        if (estimatedAlleleFrequency <= 0.0 || estimatedAlleleFrequency >= 1.0) {
            return 1.0;
        }
        return (dosageSqrSum / (double)nonMissingCount - Math.pow(dosageSum / (double)nonMissingCount, 2.0)) / (2.0 * estimatedAlleleFrequency * (1.0 - estimatedAlleleFrequency));
    }
}

