/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.zip.GZIPInputStream;
import net.sf.samtools.seekablestream.SeekableStream;
import net.sf.samtools.seekablestream.SeekableStreamFactory;
import org.broad.tribble.AbstractFeatureReader;
import org.broad.tribble.CloseableTribbleIterator;
import org.broad.tribble.Feature;
import org.broad.tribble.FeatureCodec;
import org.broad.tribble.Tribble;
import org.broad.tribble.TribbleException;
import org.broad.tribble.index.Block;
import org.broad.tribble.index.Index;
import org.broad.tribble.index.IndexFactory;
import org.broad.tribble.readers.PositionalBufferedStream;
import org.broad.tribble.util.ParsingUtils;

public class TribbleIndexedFeatureReader<T extends Feature>
extends AbstractFeatureReader {
    private Index index;

    public TribbleIndexedFeatureReader(String string, FeatureCodec featureCodec, boolean bl) throws IOException {
        super(string, featureCodec);
        if (bl) {
            String string2 = Tribble.indexFile(string);
            if (ParsingUtils.resourceExists(string2)) {
                this.index = IndexFactory.loadIndex(string2);
            } else if (ParsingUtils.resourceExists(string2 = string2 + ".gz")) {
                this.index = IndexFactory.loadIndex(string2);
            } else {
                throw new TribbleException("An index is required, but none found.");
            }
        }
        this.readHeader();
    }

    public TribbleIndexedFeatureReader(String string, FeatureCodec featureCodec, Index index) throws IOException {
        this(string, featureCodec, false);
        this.index = index;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public List<String> getSequenceNames() {
        return this.index == null ? new ArrayList<String>() : new ArrayList<String>(this.index.getSequenceNames());
    }

    private void readHeader() throws IOException {
        InputStream inputStream = null;
        PositionalBufferedStream positionalBufferedStream = null;
        try {
            inputStream = ParsingUtils.openInputStream(this.path);
            if (this.path.endsWith("gz")) {
                inputStream = new GZIPInputStream(new BufferedInputStream(inputStream));
            }
            positionalBufferedStream = new PositionalBufferedStream(inputStream);
            this.header = this.codec.readHeader(positionalBufferedStream);
        }
        catch (Exception exception) {
            throw new TribbleException.MalformedFeatureFile("Unable to parse header with error: " + exception.getMessage(), this.path, exception);
        }
        finally {
            if (positionalBufferedStream != null) {
                positionalBufferedStream.close();
            } else if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    @Override
    public CloseableTribbleIterator query(String string, int n, int n2) throws IOException {
        if (this.index == null) {
            throw new TribbleException("Index not found for: " + this.path);
        }
        if (this.index.containsChromosome(string)) {
            List<Block> list = this.index.getBlocks(string, n - 1, n2);
            return new QueryIterator(string, n, n2, list);
        }
        return new AbstractFeatureReader.EmptyIterator();
    }

    @Override
    public CloseableTribbleIterator iterator() throws IOException {
        return new WFIterator();
    }

    static class BlockStreamWrapper
    extends InputStream {
        SeekableStream seekableStream;
        long maxPosition;

        BlockStreamWrapper(SeekableStream seekableStream, Block block) throws IOException {
            this.seekableStream = seekableStream;
            seekableStream.seek(block.getStartPosition());
            this.maxPosition = block.getEndPosition();
        }

        @Override
        public int read() throws IOException {
            return this.seekableStream.position() > this.maxPosition ? -1 : this.seekableStream.read();
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            long l = this.maxPosition - this.seekableStream.position();
            if (l <= 0L) {
                return -1;
            }
            int n3 = (int)Math.min((long)n2, Math.min(l, Integer.MAX_VALUE));
            return this.seekableStream.read(byArray, n, n3);
        }
    }

    class QueryIterator<T extends Feature>
    implements CloseableTribbleIterator {
        private String chr;
        private String chrAlias;
        int start;
        int end;
        private T currentRecord;
        private PositionalBufferedStream stream;
        private Iterator<Block> blockIterator;
        private SeekableStream seekableStream;

        public QueryIterator(String string, int n, int n2, List<Block> list) throws IOException {
            this.seekableStream = SeekableStreamFactory.getStreamFor(TribbleIndexedFeatureReader.this.path);
            this.chr = string;
            this.start = n;
            this.end = n2;
            this.blockIterator = list.iterator();
            this.advanceBlock();
            this.readNextRecord();
            this.chrAlias = this.currentRecord == null ? string : this.currentRecord.getChr();
        }

        @Override
        public boolean hasNext() {
            return this.currentRecord != null;
        }

        @Override
        public T next() {
            T t = this.currentRecord;
            try {
                this.readNextRecord();
            }
            catch (IOException iOException) {
                throw new RuntimeException("Unable to read the next record, the last record was at " + t.getChr() + ":" + t.getStart() + "-" + t.getEnd(), iOException);
            }
            return t;
        }

        private void advanceBlock() throws IOException {
            while (this.blockIterator != null && this.blockIterator.hasNext()) {
                Block block = this.blockIterator.next();
                if (block.getSize() <= 0L) continue;
                this.seekableStream.seek(block.getStartPosition());
                int n = Math.min(2000000, block.getSize() > 100000000L ? 10000000 : (int)block.getSize());
                this.stream = new PositionalBufferedStream(new BlockStreamWrapper(this.seekableStream, block), n);
                return;
            }
            if (this.stream != null) {
                this.stream.close();
                this.stream = null;
            }
        }

        private void readNextRecord() throws IOException {
            if (this.stream == null) {
                return;
            }
            this.currentRecord = null;
            while (true) {
                if (!this.stream.isDone()) {
                    Feature feature = null;
                    try {
                        feature = (Feature)TribbleIndexedFeatureReader.this.codec.decode(this.stream);
                        if (feature == null) continue;
                        if (this.chrAlias != null && !feature.getChr().equals(this.chrAlias) || feature.getStart() > this.end) {
                            if (this.blockIterator.hasNext()) {
                                this.advanceBlock();
                                continue;
                            }
                            return;
                        }
                        if (feature.getEnd() < this.start) continue;
                        this.currentRecord = feature;
                        return;
                    }
                    catch (TribbleException tribbleException) {
                        tribbleException.setSource(TribbleIndexedFeatureReader.this.path);
                        throw tribbleException;
                    }
                    catch (NumberFormatException numberFormatException) {
                        String string = "Error parsing line: " + this.stream.getPosition();
                        throw new TribbleException.MalformedFeatureFile(string, TribbleIndexedFeatureReader.this.path, numberFormatException);
                    }
                }
                if (this.blockIterator == null || !this.blockIterator.hasNext()) break;
                this.advanceBlock();
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove is not supported.");
        }

        @Override
        public void close() {
            if (this.stream != null) {
                this.stream.close();
            }
            try {
                this.seekableStream.close();
            }
            catch (IOException iOException) {
                throw new TribbleException("Couldn't close seekable stream", iOException);
            }
        }

        @Override
        public Iterator<T> iterator() {
            return this;
        }
    }

    class WFIterator<T extends Feature>
    implements CloseableTribbleIterator {
        private T currentRecord;
        private PositionalBufferedStream stream;

        public WFIterator() throws IOException {
            InputStream inputStream = ParsingUtils.openInputStream(TribbleIndexedFeatureReader.this.path);
            if (TribbleIndexedFeatureReader.this.path.endsWith(".gz")) {
                GZIPInputStream gZIPInputStream = new GZIPInputStream(new BufferedInputStream(inputStream, 512000));
                this.stream = new PositionalBufferedStream(gZIPInputStream, 1000);
            } else {
                this.stream = new PositionalBufferedStream(inputStream, 512000);
            }
            if (TribbleIndexedFeatureReader.this.header.skipHeaderBytes()) {
                this.stream.skip(TribbleIndexedFeatureReader.this.header.getHeaderEnd());
            }
            this.readNextRecord();
        }

        @Override
        public boolean hasNext() {
            return this.currentRecord != null;
        }

        @Override
        public T next() {
            T t = this.currentRecord;
            try {
                this.readNextRecord();
            }
            catch (IOException iOException) {
                throw new RuntimeException("Unable to read the next record, the last record was at " + t.getChr() + ":" + t.getStart() + "-" + t.getEnd(), iOException);
            }
            return t;
        }

        private void readNextRecord() throws IOException {
            this.currentRecord = null;
            while (!this.stream.isDone()) {
                Object var1_1 = null;
                try {
                    var1_1 = TribbleIndexedFeatureReader.this.codec.decode(this.stream);
                    if (var1_1 == null) continue;
                    this.currentRecord = var1_1;
                    return;
                }
                catch (TribbleException tribbleException) {
                    tribbleException.setSource(TribbleIndexedFeatureReader.this.path);
                    throw tribbleException;
                }
                catch (NumberFormatException numberFormatException) {
                    String string = "Error parsing line at byte position: " + this.stream.getPosition();
                    throw new TribbleException.MalformedFeatureFile(string, TribbleIndexedFeatureReader.this.path, numberFormatException);
                }
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove is not supported in Iterators");
        }

        @Override
        public void close() {
            this.stream.close();
        }

        @Override
        public WFIterator<T> iterator() {
            return this;
        }
    }
}

