/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.vcf;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.broadinstitute.variant.variantcontext.VariantContext;
import org.broadinstitute.variant.vcf.VCFContigHeaderLine;

public class VariantContextComparator
implements Comparator<VariantContext> {
    private final Map<String, Integer> contigIndexLookup;

    public VariantContextComparator(List<String> list) {
        if (list.size() == 0) {
            throw new IllegalArgumentException("One or more contigs must be in the contig list.");
        }
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        int n = 0;
        for (String string : list) {
            hashMap.put(string, n++);
        }
        if (hashMap.size() != list.size()) {
            throw new IllegalArgumentException("There are duplicate contigs/chromosomes in the input contig list.");
        }
        this.contigIndexLookup = Collections.unmodifiableMap(hashMap);
    }

    public VariantContextComparator(Collection<VCFContigHeaderLine> collection) {
        if (collection.size() == 0) {
            throw new IllegalArgumentException("One or more header lines must be in the header line collection.");
        }
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        for (VCFContigHeaderLine vCFContigHeaderLine : collection) {
            hashMap.put(vCFContigHeaderLine.getID(), vCFContigHeaderLine.getContigIndex());
        }
        if (hashMap.size() != collection.size()) {
            throw new IllegalArgumentException("There are duplicate contigs/chromosomes in the input header line collection.");
        }
        HashSet hashSet = new HashSet(hashMap.values());
        if (hashSet.size() != collection.size()) {
            throw new IllegalArgumentException("One or more contigs share the same index number.");
        }
        this.contigIndexLookup = Collections.unmodifiableMap(hashMap);
    }

    @Override
    public int compare(VariantContext variantContext, VariantContext variantContext2) {
        int n = this.contigIndexLookup.get(variantContext.getChr()) - this.contigIndexLookup.get(variantContext2.getChr());
        return n != 0 ? n : variantContext.getStart() - variantContext2.getStart();
    }

    public boolean isCompatible(Collection<VCFContigHeaderLine> collection) {
        for (VCFContigHeaderLine vCFContigHeaderLine : collection) {
            Integer n = this.contigIndexLookup.get(vCFContigHeaderLine.getID());
            if (n != null && vCFContigHeaderLine.getContigIndex().intValue() == n.intValue()) continue;
            return false;
        }
        return true;
    }
}

