/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.sam;

import java.io.File;
import net.sf.picard.PicardException;
import net.sf.picard.cmdline.CommandLineProgram;
import net.sf.picard.cmdline.Option;
import net.sf.picard.cmdline.Usage;
import net.sf.picard.io.IoUtil;
import net.sf.picard.util.Log;
import net.sf.picard.util.ProgressLogger;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMFileWriter;
import net.sf.samtools.SAMFileWriterFactory;
import net.sf.samtools.SAMRecord;

public class SamFormatConverter
extends CommandLineProgram {
    private static final String PROGRAM_VERSION = "1.0";
    @Usage
    public String USAGE = this.getStandardUsagePreamble() + "Convert a BAM file to a SAM file, or BAM to SAM.\n" + "" + "Input and output formats are determined by file extension.";
    @Option(doc="The BAM or SAM file to parse.", shortName="I")
    public File INPUT;
    @Option(doc="The BAM or SAM output file. ", shortName="O")
    public File OUTPUT;

    public static void main(String[] stringArray) {
        new SamFormatConverter().instanceMainWithExit(stringArray);
    }

    @Override
    protected int doWork() {
        IoUtil.assertFileIsReadable(this.INPUT);
        IoUtil.assertFileIsWritable(this.OUTPUT);
        SAMFileReader sAMFileReader = new SAMFileReader(IoUtil.openFileForReading(this.INPUT));
        SAMFileWriter sAMFileWriter = new SAMFileWriterFactory().makeSAMOrBAMWriter(sAMFileReader.getFileHeader(), true, this.OUTPUT);
        if (this.CREATE_INDEX.booleanValue() && sAMFileWriter.getFileHeader().getSortOrder() != SAMFileHeader.SortOrder.coordinate) {
            throw new PicardException("Can't CREATE_INDEX unless sort order is coordinate");
        }
        ProgressLogger progressLogger = new ProgressLogger(Log.getInstance(SamFormatConverter.class));
        for (SAMRecord sAMRecord : sAMFileReader) {
            sAMFileWriter.addAlignment(sAMRecord);
            progressLogger.record(sAMRecord);
        }
        sAMFileReader.close();
        sAMFileWriter.close();
        return 0;
    }
}

