/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.sam;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.sf.picard.PicardException;
import net.sf.picard.cmdline.CommandLineProgram;
import net.sf.picard.cmdline.Option;
import net.sf.picard.cmdline.Usage;
import net.sf.picard.io.IoUtil;
import net.sf.picard.sam.MergingSamRecordIterator;
import net.sf.picard.sam.SamFileHeaderMerger;
import net.sf.picard.sam.SamPairUtil;
import net.sf.picard.util.Log;
import net.sf.picard.util.PeekableIterator;
import net.sf.picard.util.ProgressLogger;
import net.sf.samtools.BAMRecordCodec;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMFileWriter;
import net.sf.samtools.SAMFileWriterFactory;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMRecordQueryNameComparator;
import net.sf.samtools.util.RuntimeIOException;
import net.sf.samtools.util.SortingCollection;

public class FixMateInformation
extends CommandLineProgram {
    @Usage
    public final String USAGE = "Ensure that all mate-pair information is in sync between each read  and it's mate pair.  If no OUTPUT file is supplied then the output is written to a temporary file  and then copied over the INPUT file.  Reads marked with the secondary alignment flag are written to the output file unchanged.";
    @Option(shortName="I", doc="The input file to fix.")
    public List<File> INPUT;
    @Option(shortName="O", optional=true, doc="The output file to write to. If no output file is supplied, the input file is overwritten.")
    public File OUTPUT;
    @Option(shortName="SO", optional=true, doc="Optional sort order if the OUTPUT file should be sorted differently than the INPUT file.")
    public SAMFileHeader.SortOrder SORT_ORDER;
    private static final Log log = Log.getInstance(FixMateInformation.class);
    protected SAMFileWriter out;

    public static void main(String[] stringArray) {
        new FixMateInformation().instanceMainWithExit(stringArray);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected int doWork() {
        void var4_10;
        Object object;
        Object object2;
        Object object3;
        boolean bl;
        Object object4;
        boolean bl2 = true;
        ArrayList<SAMFileReader> arrayList = new ArrayList<SAMFileReader>();
        for (File file : this.INPUT) {
            IoUtil.assertFileIsReadable(file);
            object4 = new SAMFileReader(file);
            arrayList.add(new SAMFileReader(file));
            if (((SAMFileReader)object4).getFileHeader().getSortOrder() == SAMFileHeader.SortOrder.queryname) continue;
            bl2 = false;
        }
        if (this.OUTPUT != null) {
            this.OUTPUT = this.OUTPUT.getAbsoluteFile();
        }
        boolean bl3 = bl = this.OUTPUT != null;
        if (bl) {
            IoUtil.assertFileIsWritable(this.OUTPUT);
        } else {
            if (this.INPUT.size() != 1) {
                throw new PicardException("Must specify either an explicit OUTPUT file or a single INPUT file to be overridden.");
            }
            File file = this.INPUT.get(0).getAbsoluteFile();
            object4 = file.getParentFile().getAbsoluteFile();
            try {
                IoUtil.assertFileIsWritable(file);
                IoUtil.assertDirectoryIsWritable((File)object4);
                this.OUTPUT = File.createTempFile(file.getName() + ".being_fixed.", ".bam", (File)object4);
            }
            catch (IOException iOException) {
                throw new RuntimeIOException("Could not create tmp file in " + ((File)object4).getAbsolutePath());
            }
        }
        if (this.INPUT.size() > 1) {
            object3 = new ArrayList<SAMFileHeader>(arrayList.size());
            for (SAMFileReader sAMFileReader : arrayList) {
                object3.add(sAMFileReader.getFileHeader());
            }
            object2 = bl2 ? SAMFileHeader.SortOrder.queryname : SAMFileHeader.SortOrder.unsorted;
            SamFileHeaderMerger samFileHeaderMerger = new SamFileHeaderMerger((SAMFileHeader.SortOrder)((Object)object2), (Collection<SAMFileHeader>)object3, false);
            object = new MergingSamRecordIterator(samFileHeaderMerger, arrayList, false);
            object4 = samFileHeaderMerger.getMergedHeader();
        } else {
            object = ((SAMFileReader)arrayList.get(0)).iterator();
            object4 = ((SAMFileReader)arrayList.get(0)).getFileHeader();
        }
        if (bl2) {
            PeekableIterator<SAMRecord> peekableIterator = new PeekableIterator<SAMRecord>((Iterator<SAMRecord>)object);
        } else {
            log.info("Sorting input into queryname order.");
            object3 = SortingCollection.newInstance(SAMRecord.class, new BAMRecordCodec((SAMFileHeader)object4), new SAMRecordQueryNameComparator(), (int)this.MAX_RECORDS_IN_RAM, this.TMP_DIR);
            while (object.hasNext()) {
                ((SortingCollection)object3).add(object.next());
            }
            PeekableIterator<SAMRecord> peekableIterator = new PeekableIterator<SAMRecord>(((SortingCollection)object3).iterator(), (SortingCollection)object3){
                final /* synthetic */ SortingCollection val$sorter;
                {
                    this.val$sorter = sortingCollection;
                    super(iterator);
                }

                @Override
                public void close() {
                    super.close();
                    this.val$sorter.cleanup();
                }
            };
            log.info("Sorting by queryname complete.");
        }
        object3 = this.SORT_ORDER == null ? ((SAMFileReader)arrayList.get(0)).getFileHeader().getSortOrder() : this.SORT_ORDER;
        log.info("Output will be sorted by " + object3);
        ((SAMFileHeader)object4).setSortOrder((SAMFileHeader.SortOrder)((Object)object3));
        if (this.CREATE_INDEX.booleanValue() && ((SAMFileHeader)object4).getSortOrder() != SAMFileHeader.SortOrder.coordinate) {
            throw new PicardException("Can't CREATE_INDEX unless sort order is coordinate");
        }
        this.createSamFileWriter((SAMFileHeader)object4);
        log.info("Traversing query name sorted records and fixing up mate pair information.");
        object = new ProgressLogger(log);
        while (var4_10.hasNext()) {
            object3 = (SAMRecord)var4_10.next();
            if (((SAMRecord)object3).getNotPrimaryAlignmentFlag()) {
                this.writeAlignment((SAMRecord)object3);
                ((ProgressLogger)object).record((SAMRecord)object3);
                continue;
            }
            object2 = null;
            while (var4_10.hasNext() && ((SAMRecord)(object2 = (SAMRecord)var4_10.peek())).getNotPrimaryAlignmentFlag()) {
                var4_10.next();
                this.writeAlignment((SAMRecord)object2);
                ((ProgressLogger)object).record((SAMRecord)object2);
                object2 = null;
            }
            if (object2 != null && ((SAMRecord)object3).getReadName().equals(((SAMRecord)object2).getReadName())) {
                var4_10.next();
                SamPairUtil.setMateInfo((SAMRecord)object3, (SAMRecord)object2, (SAMFileHeader)object4);
                this.writeAlignment((SAMRecord)object3);
                this.writeAlignment((SAMRecord)object2);
                ((ProgressLogger)object).record(new SAMRecord[]{object3, object2});
                continue;
            }
            this.writeAlignment((SAMRecord)object3);
            ((ProgressLogger)object).record((SAMRecord)object3);
        }
        var4_10.close();
        if (((SAMFileHeader)object4).getSortOrder() == SAMFileHeader.SortOrder.queryname) {
            log.info("Closing output file.");
        } else {
            log.info("Finished processing reads; re-sorting output file.");
        }
        this.closeWriter();
        if (bl) return 0;
        log.info("Replacing input file with fixed file.");
        object3 = this.INPUT.get(0).getAbsoluteFile();
        object2 = new File(((File)object3).getParentFile(), ((File)object3).getName() + ".old");
        if (!((File)object2).exists() && ((File)object3).renameTo((File)object2)) {
            File file;
            if (!this.OUTPUT.renameTo((File)object3)) {
                log.error("Could not move new file to " + ((File)object3).getAbsolutePath());
                log.error("Input file preserved as: " + ((File)object2).getAbsolutePath());
                log.error("New file preserved as: " + this.OUTPUT.getAbsolutePath());
                return 1;
            }
            if (!((File)object2).delete()) {
                log.warn("Could not delete old file: " + ((File)object2).getAbsolutePath());
                return 1;
            }
            if (this.CREATE_INDEX == false) return 0;
            File file2 = new File(this.OUTPUT.getParent(), this.OUTPUT.getName().substring(0, this.OUTPUT.getName().length() - 4) + ".bai");
            if (file2.renameTo(file = new File(((File)object3).getParent(), ((File)object3).getName().substring(0, ((File)object3).getName().length() - 4) + ".bai"))) return 0;
            log.warn("Could not overwrite index file: " + file.getAbsolutePath());
            return 0;
        }
        log.error("Could not move input file out of the way: " + ((File)object3).getAbsolutePath());
        if (this.OUTPUT.delete()) return 1;
        log.error("Could not delete temporary file: " + this.OUTPUT.getAbsolutePath());
        return 1;
    }

    protected void createSamFileWriter(SAMFileHeader sAMFileHeader) {
        this.out = new SAMFileWriterFactory().makeSAMOrBAMWriter(sAMFileHeader, sAMFileHeader.getSortOrder() == SAMFileHeader.SortOrder.queryname, this.OUTPUT);
    }

    protected void writeAlignment(SAMRecord sAMRecord) {
        this.out.addAlignment(sAMRecord);
    }

    protected void closeWriter() {
        this.out.close();
    }
}

